/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.anchor;

import java.awt.Point;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.model.StateModel;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.anchor.CenterAnchor;
import org.netbeans.modules.visual.anchor.CircularAnchor;
import org.netbeans.modules.visual.anchor.DirectionalAnchor;
import org.netbeans.modules.visual.anchor.FixedAnchor;
import org.netbeans.modules.visual.anchor.FreeRectangularAnchor;
import org.netbeans.modules.visual.anchor.ProxyAnchor;
import org.netbeans.modules.visual.anchor.RectangularAnchor;

public final class AnchorFactory {
    private AnchorFactory() {
    }

    public static Anchor createFixedAnchor(Point point) {
        return new FixedAnchor(point);
    }

    public static Anchor createProxyAnchor(StateModel stateModel, Anchor ... anchorArray) {
        return stateModel != null && stateModel.getMaxStates() == anchorArray.length ? new ProxyAnchor(stateModel, anchorArray) : null;
    }

    public static Anchor createCenterAnchor(Widget widget) {
        return widget != null ? new CenterAnchor(widget) : null;
    }

    public static Anchor createCircularAnchor(Widget widget, int n) {
        return widget != null && n >= 0 ? new CircularAnchor(widget, n) : null;
    }

    public static Anchor createRectangularAnchor(Widget widget) {
        return AnchorFactory.createRectangularAnchor(widget, true);
    }

    public static Anchor createRectangularAnchor(Widget widget, boolean bl) {
        return widget != null ? new RectangularAnchor(widget, bl) : null;
    }

    public static Anchor createDirectionalAnchor(Widget widget, DirectionalAnchorKind directionalAnchorKind) {
        return AnchorFactory.createDirectionalAnchor(widget, directionalAnchorKind, 0);
    }

    public static Anchor createDirectionalAnchor(Widget widget, DirectionalAnchorKind directionalAnchorKind, int n) {
        return widget != null && directionalAnchorKind != null ? new DirectionalAnchor(widget, directionalAnchorKind, n) : null;
    }

    public static Anchor createFreeRectangularAnchor(Widget widget, boolean bl) {
        return widget != null ? new FreeRectangularAnchor(widget, bl) : null;
    }

    public static enum DirectionalAnchorKind {
        HORIZONTAL,
        VERTICAL;

    }
}

