/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.DirectedGraph;

public class LayeredGraph<N, E> {
    private DirectedGraph<N, E> originalGraph;
    private List<List<DirectedGraph.Vertex<N>>> layers;

    protected LayeredGraph(DirectedGraph<N, E> directedGraph) {
        this.originalGraph = directedGraph;
        this.layers = new ArrayList<List<DirectedGraph.Vertex<N>>>();
    }

    public static <N, E> LayeredGraph<N, E> createGraph(DirectedGraph<N, E> directedGraph) {
        LayeredGraph<N, E> layeredGraph = new LayeredGraph<N, E>(directedGraph);
        layeredGraph.createGraph();
        return layeredGraph;
    }

    protected void createGraph() {
        Collection<DirectedGraph.Vertex<N>> collection = this.originalGraph.getRootVertices();
        for (DirectedGraph.Vertex<N> vertex : collection) {
            this.assignLayers(vertex, 0);
        }
    }

    public DirectedGraph<N, E> getOriginalGraph() {
        return this.originalGraph;
    }

    private void assignLayers(DirectedGraph.Vertex<N> vertex, int n) {
        this.assignLayer(vertex, n);
        Collection<DirectedGraph.Vertex<N>> collection = vertex.getLowerNeighbors();
        for (DirectedGraph.Vertex<N> vertex2 : collection) {
            int n2 = vertex2.getNumber();
            if (n2 > n) continue;
            this.assignLayers(vertex2, n + 1);
        }
    }

    public void assignLayer(DirectedGraph.Vertex<N> vertex, int n) {
        List<DirectedGraph.Vertex<N>> list;
        int n2 = vertex.getNumber();
        if (n2 != -1) {
            list = this.getLayer(n2);
            list.remove(vertex);
        }
        list = this.getLayer(n);
        list.add(vertex);
        vertex.setNumber(n);
        vertex.setY(n);
        vertex.setX(list.size());
    }

    public List<List<DirectedGraph.Vertex<N>>> getLayers() {
        return this.layers;
    }

    public List<DirectedGraph.Vertex<N>> getLayer(int n) {
        int n2 = this.layers.size();
        if (n >= n2) {
            for (int i = n2; i <= n; ++i) {
                this.layers.add(new ArrayList());
            }
        }
        return this.layers.get(n);
    }

    public boolean[][] computeAdjacencyMatrix(int n) {
        List<DirectedGraph.Vertex<N>> list = this.layers.get(n);
        List<DirectedGraph.Vertex<N>> list2 = this.layers.get(n + 1);
        int n2 = list.size();
        int n3 = list2.size();
        boolean[][] blArray = new boolean[n2][n3];
        for (int i = 0; i < n2; ++i) {
            DirectedGraph.Vertex<N> vertex = list.get(i);
            if (vertex == null) continue;
            Collection<DirectedGraph.Vertex<N>> collection = vertex.getLowerNeighbors();
            for (DirectedGraph.Vertex<N> vertex2 : collection) {
                int n4 = list2.indexOf(vertex2);
                if (n4 <= -1) continue;
                blArray[i][n4] = true;
            }
        }
        return blArray;
    }

    public float[] computeLowerBarycenters(int n) {
        boolean[][] blArray = this.computeAdjacencyMatrix(n);
        List<DirectedGraph.Vertex<N>> list = this.layers.get(n);
        List<DirectedGraph.Vertex<N>> list2 = this.layers.get(n + 1);
        int n2 = list.size();
        int n3 = list2.size();
        float[] fArray = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f = 0.0f;
            float f2 = 0.0f;
            for (int j = 0; j < n2; ++j) {
                if (!blArray[j][i]) continue;
                DirectedGraph.Vertex<N> vertex = list.get(j);
                f += (float)vertex.getX();
                f2 += 1.0f;
            }
            DirectedGraph.Vertex<N> vertex = list2.get(i);
            fArray[i] = f / f2;
        }
        return fArray;
    }

    public float[] computeUpperBarycenters(int n) {
        boolean[][] blArray = this.computeAdjacencyMatrix(n);
        List<DirectedGraph.Vertex<N>> list = this.layers.get(n);
        List<DirectedGraph.Vertex<N>> list2 = this.layers.get(n + 1);
        int n2 = list.size();
        int n3 = list2.size();
        float[] fArray = new float[n2];
        for (int i = 0; i < n2; ++i) {
            float f = 0.0f;
            float f2 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                if (!blArray[i][j]) continue;
                DirectedGraph.Vertex<N> vertex = list2.get(j);
                f += (float)vertex.getX();
                f2 += 1.0f;
            }
            DirectedGraph.Vertex<N> vertex = list.get(i);
            fArray[i] = f / f2;
        }
        return fArray;
    }
}

