/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;

public class ConvertClusterPath
extends Task {
    private String from;
    private String id;
    private String basedir;
    private String to;

    public void setTo(String to) {
        this.to = to;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void execute() throws BuildException {
        try {
            if (this.from == null || this.from.length() == 0) {
                throw new BuildException("From parameter not specified.", this.getLocation());
            }
            if ((this.id == null || this.id.length() == 0) && this.to == null && this.to.length() == 0) {
                throw new BuildException("Either 'to' or 'id' parameter for converted path must be specified.", this.getLocation());
            }
            if (this.basedir == null || this.basedir.length() == 0) {
                this.basedir = this.getProject().getBaseDir().getAbsolutePath();
            }
            this.log("Converting cluster.path from '" + this.from + "' relative to '" + this.basedir + "'.", 3);
            FileUtils fu = FileUtils.getFileUtils();
            Project fakeproj = new Project();
            fakeproj.setBasedir(this.basedir);
            Path absPath = new Path(fakeproj, this.from);
            this.log("Converted path: '" + absPath.toString() + "'.", 3);
            final Pattern pat = Pattern.compile("(?:.*[\\\\/])?([^/\\\\]*?)([0-9.]+)?[/\\\\]?$");
            Path convPath = new Path(fakeproj);
            for (FileResource element : absPath) {
                File parent;
                File f = element.getFile();
                String fPath = f.getAbsolutePath();
                final Matcher cm = pat.matcher(fPath);
                if (f.exists()) {
                    if (!f.isDirectory()) {
                        throw new BuildException("Only directories can be elements of cluster.path. Got '" + fPath + "'", this.getLocation());
                    }
                    convPath.createPathElement().setLocation(f);
                    continue;
                }
                if (cm.matches() && (parent = f.getParentFile()) != null) {
                    File[] alternate = parent.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            Matcher am = pat.matcher(name);
                            return am.matches() && cm.group(1).equalsIgnoreCase(am.group(1));
                        }
                    });
                    if (alternate == null) {
                        Matcher matcher = Pattern.compile("^\\$\\{nbplatform\\.(.*)\\.netbeans\\.dest\\.dir\\}$").matcher(parent.getName());
                        if (matcher.matches()) {
                            throw new BuildException("Unknown platform name '" + matcher.group(1) + "'.", this.getLocation());
                        }
                        this.log("Warning: parent dir '" + parent.getAbsolutePath() + "' does not exist.", 1);
                        continue;
                    }
                    if (alternate.length > 0 && alternate[0].isDirectory()) {
                        if (cm.group(2) != null) {
                            this.log("Warning: cluster '" + fPath + "' not found, using '" + alternate[0].getAbsolutePath() + "' instead.", 1);
                        } else {
                            this.log("Cluster '" + alternate[0].getAbsolutePath() + "' found matching bare name '" + fPath + "'.", 3);
                        }
                        convPath.createPathElement().setLocation(alternate[0]);
                        continue;
                    }
                }
                this.log("Warning: no numbered cluster matching bare name '" + fPath + "' found.", 1);
            }
            if (this.id != null && this.id.length() > 0) {
                this.getProject().addReference(this.id, (Object)convPath);
            }
            if (this.to != null && this.to.length() > 0) {
                this.getProject().setProperty(this.to, convPath.toString());
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }
}

