/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import org.gradle.internal.event.DefaultListenerManager;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.logging.progress.DefaultProgressLoggerFactory;
import org.gradle.internal.logging.progress.ProgressListener;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.time.Clock;
import org.gradle.tooling.internal.consumer.LoggingProvider;

public class SynchronizedLogging
implements LoggingProvider {
    private final ThreadLocal<ThreadLoggingServices> services = new ThreadLocal();
    private final Clock clock;
    private final BuildOperationIdFactory buildOperationIdFactory;

    public SynchronizedLogging(Clock clock, BuildOperationIdFactory buildOperationIdFactory) {
        this.clock = clock;
        this.buildOperationIdFactory = buildOperationIdFactory;
    }

    @Override
    public ListenerManager getListenerManager() {
        return this.services().listenerManager;
    }

    @Override
    public ProgressLoggerFactory getProgressLoggerFactory() {
        return this.services().progressLoggerFactory;
    }

    private ThreadLoggingServices services() {
        ThreadLoggingServices threadServices = this.services.get();
        if (threadServices == null) {
            DefaultListenerManager manager = new DefaultListenerManager(Scope.Global.class);
            DefaultProgressLoggerFactory progressLoggerFactory = new DefaultProgressLoggerFactory((ProgressListener)manager.getBroadcaster(ProgressListener.class), this.clock, this.buildOperationIdFactory);
            threadServices = new ThreadLoggingServices((ListenerManager)manager, (ProgressLoggerFactory)progressLoggerFactory);
            this.services.set(threadServices);
        }
        return threadServices;
    }

    private static class ThreadLoggingServices {
        final ListenerManager listenerManager;
        final ProgressLoggerFactory progressLoggerFactory;

        private ThreadLoggingServices(ListenerManager listenerManager, ProgressLoggerFactory progressLoggerFactory) {
            this.listenerManager = listenerManager;
            this.progressLoggerFactory = progressLoggerFactory;
        }
    }
}

