/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.SonyTag9050bDirectory;

public class SonyTag9050bDescriptor
extends TagDescriptor<SonyTag9050bDirectory> {
    public SonyTag9050bDescriptor(@NotNull SonyTag9050bDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 57: {
                return this.getFlashStatusDescription();
            }
            case 70: {
                return this.getSonyExposureTimeDescription();
            }
            case 136: {
                return this.getInternalSerialNumberDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getInternalSerialNumberDescription() {
        int[] values = ((SonyTag9050bDirectory)this._directory).getIntArray(136);
        if (values == null) {
            return null;
        }
        StringBuilder sn = new StringBuilder();
        for (int value : values) {
            sn.append(String.format("%02x", value));
        }
        return sn.toString();
    }

    @Nullable
    public String getSonyExposureTimeDescription() {
        Float value = ((SonyTag9050bDirectory)this._directory).getFloatObject(70);
        if (value == null) {
            return null;
        }
        if (value.floatValue() == 0.0f) {
            return "0";
        }
        return String.format("1/%s", (int)(0.5 + (double)(1.0f / value.floatValue())));
    }

    @Nullable
    public String getFlashStatusDescription() {
        Integer value = ((SonyTag9050bDirectory)this._directory).getInteger(57);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "No flash present";
            }
            case 2: {
                return "Flash inhibited";
            }
            case 64: {
                return "Built-in flash present";
            }
            case 65: {
                return "Built-in flash fired";
            }
            case 66: {
                return "Built-in flash inhibited";
            }
            case 128: {
                return "External flash present";
            }
            case 129: {
                return "External flash fired";
            }
        }
        return "Unknown (" + value + ")";
    }
}

