/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;

public class TextContextualPopupMenu
extends JPopupMenu {
    private static final String EDITABLE = "editable";
    protected JTextComponent component;
    protected boolean undoRedo;
    protected final UndoAction undoAction = new UndoAction();
    protected final RedoAction redoAction = new RedoAction();
    protected final UndoManager undo = new UndoManager();
    protected final transient UndoableEditListener undoEditListener = e -> {
        this.undo.addEdit(e.getEdit());
        this.updateUndoRedoState();
    };
    protected final transient PropertyChangeListener propertyChangeListener = evt -> {
        if (EDITABLE.equals(evt.getPropertyName())) {
            this.removeAll();
            this.addMenuEntries();
        }
    };

    protected TextContextualPopupMenu() {
    }

    private void updateUndoRedoState() {
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    protected TextContextualPopupMenu attach(JTextComponent component, boolean undoRedo) {
        if (component != null && !this.isAttached()) {
            this.component = component;
            if (undoRedo && component.isEditable()) {
                this.enableUndoRedo();
            }
            this.addMenuEntries();
            component.addPropertyChangeListener(EDITABLE, this.propertyChangeListener);
        }
        return this;
    }

    private void enableUndoRedo() {
        if (!this.undoRedo) {
            this.component.getDocument().addUndoableEditListener(this.undoEditListener);
            if (!GraphicsEnvironment.isHeadless()) {
                Optional<Shortcut> undoShortcut = Shortcut.listAll().stream().filter(shortcut -> "system:undo".equals(shortcut.getShortText())).findFirst();
                Optional<Shortcut> redoShortcut = Shortcut.listAll().stream().filter(shortcut -> "system:redo".equals(shortcut.getShortText())).findFirst();
                if (undoShortcut.isPresent()) {
                    this.component.getInputMap().put(undoShortcut.get().getKeyStroke(), this.undoAction);
                } else {
                    this.component.getInputMap().put(KeyStroke.getKeyStroke(90, PlatformManager.getPlatform().getMenuShortcutKeyMaskEx()), this.undoAction);
                }
                if (redoShortcut.isPresent()) {
                    this.component.getInputMap().put(redoShortcut.get().getKeyStroke(), this.redoAction);
                } else {
                    this.component.getInputMap().put(KeyStroke.getKeyStroke(89, PlatformManager.getPlatform().getMenuShortcutKeyMaskEx()), this.redoAction);
                }
            }
            this.undoRedo = true;
        }
    }

    private void disableUndoRedo() {
        if (this.undoRedo) {
            if (!GraphicsEnvironment.isHeadless()) {
                this.component.getInputMap().remove(KeyStroke.getKeyStroke(90, PlatformManager.getPlatform().getMenuShortcutKeyMaskEx()));
                this.component.getInputMap().remove(KeyStroke.getKeyStroke(89, PlatformManager.getPlatform().getMenuShortcutKeyMaskEx()));
            }
            this.component.getDocument().removeUndoableEditListener(this.undoEditListener);
            this.undoRedo = false;
        }
    }

    private void addMenuEntries() {
        if (this.component.isEditable()) {
            if (this.undoRedo) {
                this.addMenuEntry(new JMenuItem(this.undoAction), "undo");
                this.addMenuEntry(new JMenuItem(this.redoAction), "redo");
                this.addSeparator();
            }
            this.addMenuEntry(this.component, I18n.tr("Cut", new Object[0]), "cut-to-clipboard", "cut");
        }
        this.addMenuEntry(this.component, I18n.tr("Copy", new Object[0]), "copy-to-clipboard", "copy");
        if (this.component.isEditable()) {
            this.addMenuEntry(this.component, I18n.tr("Paste", new Object[0]), "paste-from-clipboard", "paste");
            this.addMenuEntry(this.component, I18n.tr("Delete", new Object[0]), "delete-next", "dialogs/delete");
        }
        this.addSeparator();
        this.addMenuEntry(this.component, I18n.tr("Select All", new Object[0]), "select-all", "dialogs/select");
    }

    protected TextContextualPopupMenu detach() {
        if (this.isAttached()) {
            this.component.removePropertyChangeListener(EDITABLE, this.propertyChangeListener);
            this.removeAll();
            if (this.undoRedo) {
                this.disableUndoRedo();
            }
            this.component = null;
        }
        return this;
    }

    public static PopupMenuLauncher enableMenuFor(JTextComponent component, boolean undoRedo) {
        PopupMenuLauncher launcher = new PopupMenuLauncher(new TextContextualPopupMenu().attach(component, undoRedo), true);
        component.addMouseListener(launcher);
        return launcher;
    }

    public static void disableMenuFor(JTextComponent component, PopupMenuLauncher launcher) {
        if (launcher.getMenu() instanceof TextContextualPopupMenu) {
            ((TextContextualPopupMenu)launcher.getMenu()).detach();
            component.removeMouseListener(launcher);
        }
    }

    public void discardAllUndoableEdits() {
        this.undo.discardAllEdits();
        this.updateUndoRedoState();
    }

    public final boolean isAttached() {
        return this.component != null;
    }

    protected void addMenuEntry(JTextComponent component, String label, String actionName, String iconName) {
        Action action = component.getActionMap().get(actionName);
        if (action != null) {
            JMenuItem mi = new JMenuItem(action);
            mi.setText(label);
            this.addMenuEntry(mi, iconName);
        }
    }

    protected void addMenuEntry(JMenuItem mi, String iconName) {
        if (iconName != null && Config.getPref().getBoolean("text.popupmenu.useicons", true)) {
            ImageIcon icon = new ImageProvider(iconName).setSize(ImageProvider.ImageSizes.SMALLICON).get();
            mi.setIcon(icon);
        }
        this.add(mi);
    }

    protected class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(I18n.tr("Redo", new Object[0]));
            new ImageProvider("redo").getResource().attachImageIcon(this);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TextContextualPopupMenu.this.undo.redo();
            }
            catch (CannotRedoException ex) {
                Logging.trace(ex);
            }
            finally {
                this.updateRedoState();
                TextContextualPopupMenu.this.undoAction.updateUndoState();
            }
        }

        public void updateRedoState() {
            if (TextContextualPopupMenu.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", TextContextualPopupMenu.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", I18n.tr("Redo", new Object[0]));
            }
        }
    }

    protected class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(I18n.tr("Undo", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TextContextualPopupMenu.this.undo.undo();
            }
            catch (CannotUndoException ex) {
                Logging.trace(ex);
            }
            finally {
                this.updateUndoState();
                TextContextualPopupMenu.this.redoAction.updateRedoState();
            }
        }

        public void updateUndoState() {
            if (TextContextualPopupMenu.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", TextContextualPopupMenu.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", I18n.tr("Undo", new Object[0]));
            }
        }
    }
}

