/* spliceGraph.h was originally generated by the autoSql program, which also 
 * generated spliceGraph.c and spliceGraph.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef SPLICEGRAPH_H
#define SPLICEGRAPH_H

struct spliceNode
/* A Single splice site node in a splicing graph */
    {
    struct spliceNode *next;  /* Next in singly linked list. */
    char *tName;	/* name of target sequence, often a chrom. */
    int tStart;	/* start in tName. */
    int tEnd;	/* end in tName. */
    char strand[3];	/* + or - strand. */
    unsigned id;	/* Unique ID. */
    unsigned type;	/* Type of splice site, see enum ggVertexType. */
    unsigned class;	/* Number of node in graph, different than ID. */
    unsigned color;	/* Used for algorithm classification. */
    unsigned edgeCount;	/* Number of edges leaving from this graph. */
    unsigned *edges;	/* Ids of spliceNodes that this edge connects to. */
    };

struct spliceNode *spliceNodeLoad(char **row);
/* Load a spliceNode from row fetched with select * from spliceNode
 * from database.  Dispose of this with spliceNodeFree(). */

struct spliceNode *spliceNodeLoadAll(char *fileName);
/* Load all spliceNode from a tab-separated file.
 * Dispose of this with spliceNodeFreeList(). */

struct spliceNode *spliceNodeCommaIn(char **pS, struct spliceNode *ret);
/* Create a spliceNode out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new spliceNode */

void spliceNodeFree(struct spliceNode **pEl);
/* Free a single dynamically allocated spliceNode such as created
 * with spliceNodeLoad(). */

void spliceNodeFreeList(struct spliceNode **pList);
/* Free a list of dynamically allocated spliceNode's */

void spliceNodeOutput(struct spliceNode *el, FILE *f, char sep, char lastSep);
/* Print out spliceNode.  Separate fields with sep. Follow last field with lastSep. */

#define spliceNodeTabOut(el,f) spliceNodeOutput(el,f,'\t','\n');
/* Print out spliceNode as a line in a tab-separated file. */

#define spliceNodeCommaOut(el,f) spliceNodeOutput(el,f,',',',');
/* Print out spliceNode as a comma separated list including final comma. */

struct splicePath
/* Path of one EST/mRNA through splieNodes */
    {
    struct splicePath *next;  /* Next in singly linked list. */
    char *tName;	/* name of target sequence, often a chrom. */
    int tStart;	/* start in tName. */
    int tEnd;	/* end in tName. */
    char *qName;	/* Accession of mRNA or EST. */
    char strand[3];	/* + or - strand. */
    char *path;	/* String representation of path. */
    unsigned nodeCount;	/* Number of nodes in graph. */
    struct spliceNode *nodes;	/* Array of dynamically allocated spliceNodes whose id corresponds to their index in array. */
    };

struct splicePath *splicePathLoad(char **row);
/* Load a splicePath from row fetched with select * from splicePath
 * from database.  Dispose of this with splicePathFree(). */

struct splicePath *splicePathLoadAll(char *fileName);
/* Load all splicePath from a tab-separated file.
 * Dispose of this with splicePathFreeList(). */

struct splicePath *splicePathCommaIn(char **pS, struct splicePath *ret);
/* Create a splicePath out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new splicePath */

void splicePathFree(struct splicePath **pEl);
/* Free a single dynamically allocated splicePath such as created
 * with splicePathLoad(). */

void splicePathFreeList(struct splicePath **pList);
/* Free a list of dynamically allocated splicePath's */

void splicePathOutput(struct splicePath *el, FILE *f, char sep, char lastSep);
/* Print out splicePath.  Separate fields with sep. Follow last field with lastSep. */

#define splicePathTabOut(el,f) splicePathOutput(el,f,'\t','\n');
/* Print out splicePath as a line in a tab-separated file. */

#define splicePathCommaOut(el,f) splicePathOutput(el,f,',',',');
/* Print out splicePath as a comma separated list including final comma. */

struct spliceGraph
/* A collection of spliceNodes forming a graph */
    {
    struct spliceGraph *next;  /* Next in singly linked list. */
    char *tName;	/* name of target sequence, often a chrom. */
    int tStart;	/* start in tName. */
    int tEnd;	/* end in tName. */
    char strand[3];	/* + or - strand. */
    unsigned classCount;	/* Number of different classes of nodes, two nodes are of same class if at same position. */
    unsigned *classStarts;	/* start in tName. */
    unsigned *classEnds;	/* end in tName. */
    unsigned *classTypes;	/* Type of splice site, see enum ggVertexType. */
    unsigned nodeCount;	/* Total number of nodes in graph. */
    unsigned nodeCapacity;	/* Maximum nodes allowed without expanding memory. */
    unsigned pathCount;	/* Number of different paths generating graph. */
    struct splicePath *paths;	/* Array of dynamically allocated splicePaths which make up the graph. */
    struct spliceNode **nodes;  /* Array of pointers to each node in graph, ids of nodes index into this array. */
    };

struct spliceGraph *spliceGraphLoad(char **row);
/* Load a spliceGraph from row fetched with select * from spliceGraph
 * from database.  Dispose of this with spliceGraphFree(). */

struct spliceGraph *spliceGraphLoadAll(char *fileName);
/* Load all spliceGraph from a tab-separated file.
 * Dispose of this with spliceGraphFreeList(). */

struct spliceGraph *spliceGraphCommaIn(char **pS, struct spliceGraph *ret);
/* Create a spliceGraph out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new spliceGraph */

void spliceGraphFree(struct spliceGraph **pEl);
/* Free a single dynamically allocated spliceGraph such as created
 * with spliceGraphLoad(). */

void spliceGraphFreeList(struct spliceGraph **pList);
/* Free a list of dynamically allocated spliceGraph's */

void spliceGraphOutput(struct spliceGraph *el, FILE *f, char sep, char lastSep);
/* Print out spliceGraph.  Separate fields with sep. Follow last field with lastSep. */

#define spliceGraphTabOut(el,f) spliceGraphOutput(el,f,'\t','\n');
/* Print out spliceGraph as a line in a tab-separated file. */

#define spliceGraphCommaOut(el,f) spliceGraphOutput(el,f,',',',');
/* Print out spliceGraph as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

void spliceGraphIncreaseCapacity(struct spliceGraph *sg, int neededSize);
/* Increase the nodeCapcity of nodes for spliceGraph. */

void spliceGraphAddNode(struct spliceGraph *sg, struct spliceNode *sn);
/* Add the spliceNode sn to the array of node pointers maintained by the spliceGraph. */

void spliceNodeConnect(struct spliceNode *sn1, struct spliceNode *sn2);
/* Create a directed edge from sn1 to sn2. */

#endif /* SPLICEGRAPH_H */

