/* simpleTest.h was originally generated by the autoSql program, which also 
 * generated simpleTest.c and simpleTest.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef SIMPLETEST_H
#define SIMPLETEST_H

#define POINT_NUM_COLS 2

struct point
/* A two dimensional point */
    {
    int x;	/* X dimension */
    int y;	/* Y dimension */
    };

struct point *pointLoad(char **row);
/* Load a point from row fetched with select * from point
 * from database.  Dispose of this with pointFree(). */

struct point *pointLoadAll(char *fileName);
/* Load all point from whitespace-separated file.
 * Dispose of this with pointFreeList(). */

struct point *pointLoadAllByChar(char *fileName, char chopper);
/* Load all point from chopper separated file.
 * Dispose of this with pointFreeList(). */

#define pointLoadAllByTab(a) pointLoadAllByChar(a, '\t');
/* Load all point from tab separated file.
 * Dispose of this with pointFreeList(). */

struct point *pointCommaIn(char **pS, struct point *ret);
/* Create a point out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new point */

void pointOutput(struct point *el, FILE *f, char sep, char lastSep);
/* Print out point.  Separate fields with sep. Follow last field with lastSep. */

#define pointTabOut(el,f) pointOutput(el,f,'\t','\n');
/* Print out point as a line in a tab-separated file. */

#define pointCommaOut(el,f) pointOutput(el,f,',',',');
/* Print out point as a comma separated list including final comma. */

#define NAMEDPOINT_NUM_COLS 2

struct namedPoint
/* A named point */
    {
    char *name;	/* Name of point */
    struct point point;	/* X/Y coordinates */
    };

struct namedPoint *namedPointLoad(char **row);
/* Load a namedPoint from row fetched with select * from namedPoint
 * from database.  Dispose of this with namedPointFree(). */

struct namedPoint *namedPointLoadAll(char *fileName);
/* Load all namedPoint from whitespace-separated file.
 * Dispose of this with namedPointFreeList(). */

struct namedPoint *namedPointLoadAllByChar(char *fileName, char chopper);
/* Load all namedPoint from chopper separated file.
 * Dispose of this with namedPointFreeList(). */

#define namedPointLoadAllByTab(a) namedPointLoadAllByChar(a, '\t');
/* Load all namedPoint from tab separated file.
 * Dispose of this with namedPointFreeList(). */

struct namedPoint *namedPointCommaIn(char **pS, struct namedPoint *ret);
/* Create a namedPoint out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new namedPoint */

void namedPointFreeInternals(struct namedPoint *array, int count);
/* Free internals of a simple type namedPoint (one not put on a list). */

void namedPointOutput(struct namedPoint *el, FILE *f, char sep, char lastSep);
/* Print out namedPoint.  Separate fields with sep. Follow last field with lastSep. */

#define namedPointTabOut(el,f) namedPointOutput(el,f,'\t','\n');
/* Print out namedPoint as a line in a tab-separated file. */

#define namedPointCommaOut(el,f) namedPointOutput(el,f,',',',');
/* Print out namedPoint as a comma separated list including final comma. */

#define TRIANGLE_NUM_COLS 2

struct triangle
/* A collection of three points. */
    {
    char *name;	/* Name of triangle */
    struct point points[3];	/* The three vertices */
    };

struct triangle *triangleLoad(char **row);
/* Load a triangle from row fetched with select * from triangle
 * from database.  Dispose of this with triangleFree(). */

struct triangle *triangleLoadAll(char *fileName);
/* Load all triangle from whitespace-separated file.
 * Dispose of this with triangleFreeList(). */

struct triangle *triangleLoadAllByChar(char *fileName, char chopper);
/* Load all triangle from chopper separated file.
 * Dispose of this with triangleFreeList(). */

#define triangleLoadAllByTab(a) triangleLoadAllByChar(a, '\t');
/* Load all triangle from tab separated file.
 * Dispose of this with triangleFreeList(). */

struct triangle *triangleCommaIn(char **pS, struct triangle *ret);
/* Create a triangle out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new triangle */

void triangleFreeInternals(struct triangle *array, int count);
/* Free internals of a simple type triangle (one not put on a list). */

void triangleOutput(struct triangle *el, FILE *f, char sep, char lastSep);
/* Print out triangle.  Separate fields with sep. Follow last field with lastSep. */

#define triangleTabOut(el,f) triangleOutput(el,f,'\t','\n');
/* Print out triangle as a line in a tab-separated file. */

#define triangleCommaOut(el,f) triangleOutput(el,f,',',',');
/* Print out triangle as a comma separated list including final comma. */

#define POLYGON_NUM_COLS 3

struct polygon
/* A bunch of connected points. */
    {
    char *name;	/* Name of polygon */
    int vertexCount;	/* Number of vertices */
    struct point *vertices;	/* The x/y coordinates of all vertices */
    };

struct polygon *polygonLoad(char **row);
/* Load a polygon from row fetched with select * from polygon
 * from database.  Dispose of this with polygonFree(). */

struct polygon *polygonLoadAll(char *fileName);
/* Load all polygon from whitespace-separated file.
 * Dispose of this with polygonFreeList(). */

struct polygon *polygonLoadAllByChar(char *fileName, char chopper);
/* Load all polygon from chopper separated file.
 * Dispose of this with polygonFreeList(). */

#define polygonLoadAllByTab(a) polygonLoadAllByChar(a, '\t');
/* Load all polygon from tab separated file.
 * Dispose of this with polygonFreeList(). */

struct polygon *polygonCommaIn(char **pS, struct polygon *ret);
/* Create a polygon out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new polygon */

void polygonFreeInternals(struct polygon *array, int count);
/* Free internals of a simple type polygon (one not put on a list). */

void polygonOutput(struct polygon *el, FILE *f, char sep, char lastSep);
/* Print out polygon.  Separate fields with sep. Follow last field with lastSep. */

#define polygonTabOut(el,f) polygonOutput(el,f,'\t','\n');
/* Print out polygon as a line in a tab-separated file. */

#define polygonCommaOut(el,f) polygonOutput(el,f,',',',');
/* Print out polygon as a comma separated list including final comma. */

#define PERSON_NUM_COLS 3

struct person
/* Info on a person */
    {
    char *firstName;	/* First name */
    char *lastName;	/* Last name */
    long long ssn;	/* Social security number */
    };

struct person *personLoad(char **row);
/* Load a person from row fetched with select * from person
 * from database.  Dispose of this with personFree(). */

struct person *personLoadAll(char *fileName);
/* Load all person from whitespace-separated file.
 * Dispose of this with personFreeList(). */

struct person *personLoadAllByChar(char *fileName, char chopper);
/* Load all person from chopper separated file.
 * Dispose of this with personFreeList(). */

#define personLoadAllByTab(a) personLoadAllByChar(a, '\t');
/* Load all person from tab separated file.
 * Dispose of this with personFreeList(). */

struct person *personCommaIn(char **pS, struct person *ret);
/* Create a person out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new person */

void personFreeInternals(struct person *array, int count);
/* Free internals of a simple type person (one not put on a list). */

void personOutput(struct person *el, FILE *f, char sep, char lastSep);
/* Print out person.  Separate fields with sep. Follow last field with lastSep. */

#define personTabOut(el,f) personOutput(el,f,'\t','\n');
/* Print out person as a line in a tab-separated file. */

#define personCommaOut(el,f) personOutput(el,f,',',',');
/* Print out person as a comma separated list including final comma. */

#define COUPLE_NUM_COLS 2

struct couple
/* Info on a group of people */
    {
    char *name;	/* Couple's name */
    struct person members[2];	/* Members of couple */
    };

struct couple *coupleLoad(char **row);
/* Load a couple from row fetched with select * from couple
 * from database.  Dispose of this with coupleFree(). */

struct couple *coupleLoadAll(char *fileName);
/* Load all couple from whitespace-separated file.
 * Dispose of this with coupleFreeList(). */

struct couple *coupleLoadAllByChar(char *fileName, char chopper);
/* Load all couple from chopper separated file.
 * Dispose of this with coupleFreeList(). */

#define coupleLoadAllByTab(a) coupleLoadAllByChar(a, '\t');
/* Load all couple from tab separated file.
 * Dispose of this with coupleFreeList(). */

struct couple *coupleCommaIn(char **pS, struct couple *ret);
/* Create a couple out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new couple */

void coupleFreeInternals(struct couple *array, int count);
/* Free internals of a simple type couple (one not put on a list). */

void coupleOutput(struct couple *el, FILE *f, char sep, char lastSep);
/* Print out couple.  Separate fields with sep. Follow last field with lastSep. */

#define coupleTabOut(el,f) coupleOutput(el,f,'\t','\n');
/* Print out couple as a line in a tab-separated file. */

#define coupleCommaOut(el,f) coupleOutput(el,f,',',',');
/* Print out couple as a comma separated list including final comma. */

#define GROUP_NUM_COLS 3

struct group
/* Info on a group of people */
    {
    char *name;	/* Name of group */
    int size;	/* Size of group */
    struct person *members;	/* All members of group */
    };

struct group *groupLoad(char **row);
/* Load a group from row fetched with select * from group
 * from database.  Dispose of this with groupFree(). */

struct group *groupLoadAll(char *fileName);
/* Load all group from whitespace-separated file.
 * Dispose of this with groupFreeList(). */

struct group *groupLoadAllByChar(char *fileName, char chopper);
/* Load all group from chopper separated file.
 * Dispose of this with groupFreeList(). */

#define groupLoadAllByTab(a) groupLoadAllByChar(a, '\t');
/* Load all group from tab separated file.
 * Dispose of this with groupFreeList(). */

struct group *groupCommaIn(char **pS, struct group *ret);
/* Create a group out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new group */

void groupFreeInternals(struct group *array, int count);
/* Free internals of a simple type group (one not put on a list). */

void groupOutput(struct group *el, FILE *f, char sep, char lastSep);
/* Print out group.  Separate fields with sep. Follow last field with lastSep. */

#define groupTabOut(el,f) groupOutput(el,f,'\t','\n');
/* Print out group as a line in a tab-separated file. */

#define groupCommaOut(el,f) groupOutput(el,f,',',',');
/* Print out group as a comma separated list including final comma. */

#define METAGROUP_NUM_COLS 3

struct metaGroup
/* Info on many groups */
    {
    char *name;	/* Name of group */
    int metaSize;	/* Number of groups */
    struct group *groups;	/* All groups in metaGroup */
    };

struct metaGroup *metaGroupLoad(char **row);
/* Load a metaGroup from row fetched with select * from metaGroup
 * from database.  Dispose of this with metaGroupFree(). */

struct metaGroup *metaGroupLoadAll(char *fileName);
/* Load all metaGroup from whitespace-separated file.
 * Dispose of this with metaGroupFreeList(). */

struct metaGroup *metaGroupLoadAllByChar(char *fileName, char chopper);
/* Load all metaGroup from chopper separated file.
 * Dispose of this with metaGroupFreeList(). */

#define metaGroupLoadAllByTab(a) metaGroupLoadAllByChar(a, '\t');
/* Load all metaGroup from tab separated file.
 * Dispose of this with metaGroupFreeList(). */

struct metaGroup *metaGroupCommaIn(char **pS, struct metaGroup *ret);
/* Create a metaGroup out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new metaGroup */

void metaGroupFreeInternals(struct metaGroup *array, int count);
/* Free internals of a simple type metaGroup (one not put on a list). */

void metaGroupOutput(struct metaGroup *el, FILE *f, char sep, char lastSep);
/* Print out metaGroup.  Separate fields with sep. Follow last field with lastSep. */

#define metaGroupTabOut(el,f) metaGroupOutput(el,f,'\t','\n');
/* Print out metaGroup as a line in a tab-separated file. */

#define metaGroupCommaOut(el,f) metaGroupOutput(el,f,',',',');
/* Print out metaGroup as a comma separated list including final comma. */

#define METAGROUPLOGO_NUM_COLS 2

struct metaGroupLogo
/* Tie together a polygonal logo with a metaGroup */
    {
    struct metaGroupLogo *next;  /* Next in singly linked list. */
    struct polygon logo;	/* Logo of meta groups */
    struct metaGroup conspiracy;	/* Conspiring meta groups */
    };

void metaGroupLogoStaticLoad(char **row, struct metaGroupLogo *ret);
/* Load a row from metaGroupLogo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct metaGroupLogo *metaGroupLogoLoad(char **row);
/* Load a metaGroupLogo from row fetched with select * from metaGroupLogo
 * from database.  Dispose of this with metaGroupLogoFree(). */

struct metaGroupLogo *metaGroupLogoLoadAll(char *fileName);
/* Load all metaGroupLogo from whitespace-separated file.
 * Dispose of this with metaGroupLogoFreeList(). */

struct metaGroupLogo *metaGroupLogoLoadAllByChar(char *fileName, char chopper);
/* Load all metaGroupLogo from chopper separated file.
 * Dispose of this with metaGroupLogoFreeList(). */

#define metaGroupLogoLoadAllByTab(a) metaGroupLogoLoadAllByChar(a, '\t');
/* Load all metaGroupLogo from tab separated file.
 * Dispose of this with metaGroupLogoFreeList(). */

struct metaGroupLogo *metaGroupLogoCommaIn(char **pS, struct metaGroupLogo *ret);
/* Create a metaGroupLogo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new metaGroupLogo */

void metaGroupLogoFree(struct metaGroupLogo **pEl);
/* Free a single dynamically allocated metaGroupLogo such as created
 * with metaGroupLogoLoad(). */

void metaGroupLogoFreeList(struct metaGroupLogo **pList);
/* Free a list of dynamically allocated metaGroupLogo's */

void metaGroupLogoOutput(struct metaGroupLogo *el, FILE *f, char sep, char lastSep);
/* Print out metaGroupLogo.  Separate fields with sep. Follow last field with lastSep. */

#define metaGroupLogoTabOut(el,f) metaGroupLogoOutput(el,f,'\t','\n');
/* Print out metaGroupLogo as a line in a tab-separated file. */

#define metaGroupLogoCommaOut(el,f) metaGroupLogoOutput(el,f,',',',');
/* Print out metaGroupLogo as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* SIMPLETEST_H */

