/* est3.h was originally generated by the autoSql program, which also 
 * generated est3.c and est3.sql.  This header links the database and the RAM 
 * representation of objects. */

#ifndef EST3_H
#define EST3_H

struct est3
/* EST 3-prime ends */
    {
    struct est3 *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char strand[2];	/* + or - strand */
    unsigned estCount;	/* Number of ESTs supporting this */
    };

void est3StaticLoad(char **row, struct est3 *ret);
/* Load a row from est3 table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct est3 *est3Load(char **row);
/* Load a est3 from row fetched with select * from est3
 * from database.  Dispose of this with est3Free(). */

struct est3 *est3CommaIn(char **pS, struct est3 *ret);
/* Create a est3 out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new est3 */

void est3Free(struct est3 **pEl);
/* Free a single dynamically allocated est3 such as created
 * with est3Load(). */

void est3FreeList(struct est3 **pList);
/* Free a list of dynamically allocated est3's */

void est3Output(struct est3 *el, FILE *f, char sep, char lastSep);
/* Print out est3.  Separate fields with sep. Follow last field with lastSep. */

#define est3TabOut(el,f) est3Output(el,f,'\t','\n');
/* Print out est3 as a line in a tab-separated file. */

#define est3CommaOut(el,f) est3Output(el,f,',',',');
/* Print out est3 as a comma separated list including final comma. */

#endif /* EST3_H */

