/* genomicDups.h was originally generated by the autoSql program, which also 
 * generated genomicDups.c and genomicDups.sql.  This header links the database and the RAM 
 * representation of objects. */

#ifndef GENOMICDUPS_H
#define GENOMICDUPS_H

struct genomicDups
/* Summary of large genomic Duplications (>1KB >90% similar) */
    {
    struct genomicDups *next;  /* Next in singly linked list. */
    char *chrom;	/* Human chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Other FPC contig involved */
    unsigned score;	/* Score from 900-1000.  1000 is best */
    char strand[2];	/* Value should be + or - */
    char *otherChrom;	/* Human chromosome */
    unsigned otherStart;	/* Start in other sequence */
    unsigned otherEnd;	/* End in other sequence */
    unsigned alignB;	/* bases Aligned */
    unsigned matchB;	/* aligned bases that match */
    unsigned mismatchB;	/* aligned bases that do not match */
    float fracMatch;	/* fraction of matching bases */
    float jcK;	/* K-value calculated with Jukes-Cantor */
    };

void genomicDupsStaticLoad(char **row, struct genomicDups *ret);
/* Load a row from genomicDups table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct genomicDups *genomicDupsLoad(char **row);
/* Load a genomicDups from row fetched with select * from genomicDups
 * from database.  Dispose of this with genomicDupsFree(). */

struct genomicDups *genomicDupsCommaIn(char **pS, struct genomicDups *ret);
/* Create a genomicDups out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new genomicDups */

void genomicDupsFree(struct genomicDups **pEl);
/* Free a single dynamically allocated genomicDups such as created
 * with genomicDupsLoad(). */

void genomicDupsFreeList(struct genomicDups **pList);
/* Free a list of dynamically allocated genomicDups's */

void genomicDupsOutput(struct genomicDups *el, FILE *f, char sep, char lastSep);
/* Print out genomicDups.  Separate fields with sep. Follow last field with lastSep. */

#define genomicDupsTabOut(el,f) genomicDupsOutput(el,f,'\t','\n');
/* Print out genomicDups as a line in a tab-separated file. */

#define genomicDupsCommaOut(el,f) genomicDupsOutput(el,f,',',',');
/* Print out genomicDups as a comma separated list including final comma. */

#endif /* GENOMICDUPS_H */

