/* knownInfo.h was originally generated by the autoSql program, which also 
 * generated knownInfo.c and knownInfo.sql.  This header links the database and the RAM 
 * representation of objects. */

#ifndef KNOWNINFO_H
#define KNOWNINFO_H

struct knownInfo
/* Auxiliary info about a known gene */
    {
    struct knownInfo *next;  /* Next in singly linked list. */
    char *name;	/* connects with genieKnown->name */
    char *transId;	/* Transcript id. Genie generated ID. */
    char *geneId;	/* Gene (not trascript) id */
    unsigned geneName;	/* Connect to geneName table */
    unsigned productName;	/* Connects to productName table */
    char *proteinId;	/* Genbank accession of protein? */
    char *ngi;	/* Genbank gi of nucleotide seq. */
    char *pgi;	/* Genbank gi of protein seq. */
    };

void knownInfoStaticLoad(char **row, struct knownInfo *ret);
/* Load a row from knownInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct knownInfo *knownInfoLoad(char **row);
/* Load a knownInfo from row fetched with select * from knownInfo
 * from database.  Dispose of this with knownInfoFree(). */

struct knownInfo *knownInfoCommaIn(char **pS, struct knownInfo *ret);
/* Create a knownInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new knownInfo */

void knownInfoFree(struct knownInfo **pEl);
/* Free a single dynamically allocated knownInfo such as created
 * with knownInfoLoad(). */

void knownInfoFreeList(struct knownInfo **pList);
/* Free a list of dynamically allocated knownInfo's */

void knownInfoOutput(struct knownInfo *el, FILE *f, char sep, char lastSep);
/* Print out knownInfo.  Separate fields with sep. Follow last field with lastSep. */

#define knownInfoTabOut(el,f) knownInfoOutput(el,f,'\t','\n');
/* Print out knownInfo as a line in a tab-separated file. */

#define knownInfoCommaOut(el,f) knownInfoOutput(el,f,',',',');
/* Print out knownInfo as a comma separated list including final comma. */

#endif /* KNOWNINFO_H */

