/* cnpRedon.c was originally generated by the autoSql program, which also 
 * generated cnpRedon.h and cnpRedon.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "cnpRedon.h"


void cnpRedonStaticLoad(char **row, struct cnpRedon *ret)
/* Load a row from cnpRedon table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlFloat(row[4]);
strcpy(ret->strand, row[5]);
}

struct cnpRedon *cnpRedonLoad(char **row)
/* Load a cnpRedon from row fetched with select * from cnpRedon
 * from database.  Dispose of this with cnpRedonFree(). */
{
struct cnpRedon *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlFloat(row[4]);
strcpy(ret->strand, row[5]);
return ret;
}

struct cnpRedon *cnpRedonLoadAll(char *fileName) 
/* Load all cnpRedon from a whitespace-separated file.
 * Dispose of this with cnpRedonFreeList(). */
{
struct cnpRedon *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = cnpRedonLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cnpRedon *cnpRedonLoadAllByChar(char *fileName, char chopper) 
/* Load all cnpRedon from a chopper separated file.
 * Dispose of this with cnpRedonFreeList(). */
{
struct cnpRedon *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cnpRedonLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cnpRedon *cnpRedonCommaIn(char **pS, struct cnpRedon *ret)
/* Create a cnpRedon out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cnpRedon */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlFloatComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
*pS = s;
return ret;
}

void cnpRedonFree(struct cnpRedon **pEl)
/* Free a single dynamically allocated cnpRedon such as created
 * with cnpRedonLoad(). */
{
struct cnpRedon *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freez(pEl);
}

void cnpRedonFreeList(struct cnpRedon **pList)
/* Free a list of dynamically allocated cnpRedon's */
{
struct cnpRedon *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cnpRedonFree(&el);
    }
*pList = NULL;
}

void cnpRedonOutput(struct cnpRedon *el, FILE *f, char sep, char lastSep) 
/* Print out cnpRedon.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

