/* cnpSharpCutoff.c was originally generated by the autoSql program, which also 
 * generated cnpSharpCutoff.h and cnpSharpCutoff.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "cnpSharpCutoff.h"


void cnpSharpCutoffStaticLoad(char **row, struct cnpSharpCutoff *ret)
/* Load a row from cnpSharpCutoff table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->sample = row[0];
ret->batch = sqlUnsigned(row[1]);
ret->value = atof(row[2]);
}

struct cnpSharpCutoff *cnpSharpCutoffLoad(char **row)
/* Load a cnpSharpCutoff from row fetched with select * from cnpSharpCutoff
 * from database.  Dispose of this with cnpSharpCutoffFree(). */
{
struct cnpSharpCutoff *ret;

AllocVar(ret);
ret->sample = cloneString(row[0]);
ret->batch = sqlUnsigned(row[1]);
ret->value = atof(row[2]);
return ret;
}

struct cnpSharpCutoff *cnpSharpCutoffLoadAll(char *fileName) 
/* Load all cnpSharpCutoff from a whitespace-separated file.
 * Dispose of this with cnpSharpCutoffFreeList(). */
{
struct cnpSharpCutoff *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = cnpSharpCutoffLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cnpSharpCutoff *cnpSharpCutoffLoadAllByChar(char *fileName, char chopper) 
/* Load all cnpSharpCutoff from a chopper separated file.
 * Dispose of this with cnpSharpCutoffFreeList(). */
{
struct cnpSharpCutoff *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cnpSharpCutoffLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cnpSharpCutoff *cnpSharpCutoffLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cnpSharpCutoff from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cnpSharpCutoffFreeList(). */
{
struct cnpSharpCutoff *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cnpSharpCutoffLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cnpSharpCutoffSaveToDb(struct sqlConnection *conn, struct cnpSharpCutoff *el, char *tableName, int updateSize)
/* Save cnpSharpCutoff as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use cnpSharpCutoffSaveToDbEscaped() */
{
struct dyString *update = newDyString(updateSize);
dyStringPrintf(update, "insert into %s values ( '%s',%u,%g)", 
	tableName,  el->sample,  el->batch,  el->value);
sqlUpdate(conn, update->string);
freeDyString(&update);
}

void cnpSharpCutoffSaveToDbEscaped(struct sqlConnection *conn, struct cnpSharpCutoff *el, char *tableName, int updateSize)
/* Save cnpSharpCutoff as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than cnpSharpCutoffSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 
{
struct dyString *update = newDyString(updateSize);
char  *sample;
sample = sqlEscapeString(el->sample);

dyStringPrintf(update, "insert into %s values ( '%s',%u,%g)", 
	tableName,  sample, el->batch , el->value );
sqlUpdate(conn, update->string);
freeDyString(&update);
freez(&sample);
}

struct cnpSharpCutoff *cnpSharpCutoffCommaIn(char **pS, struct cnpSharpCutoff *ret)
/* Create a cnpSharpCutoff out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cnpSharpCutoff */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->sample = sqlStringComma(&s);
ret->batch = sqlUnsignedComma(&s);
ret->value = sqlFloatComma(&s);
*pS = s;
return ret;
}

void cnpSharpCutoffFree(struct cnpSharpCutoff **pEl)
/* Free a single dynamically allocated cnpSharpCutoff such as created
 * with cnpSharpCutoffLoad(). */
{
struct cnpSharpCutoff *el;

if ((el = *pEl) == NULL) return;
freeMem(el->sample);
freez(pEl);
}

void cnpSharpCutoffFreeList(struct cnpSharpCutoff **pList)
/* Free a list of dynamically allocated cnpSharpCutoff's */
{
struct cnpSharpCutoff *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cnpSharpCutoffFree(&el);
    }
*pList = NULL;
}

void cnpSharpCutoffOutput(struct cnpSharpCutoff *el, FILE *f, char sep, char lastSep) 
/* Print out cnpSharpCutoff.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sample);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->batch);
fputc(sep,f);
fprintf(f, "%g", el->value);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

