# dless.sql was originally generated by the autoSql program, which also 
# generated dless.c and dless.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#data for DLESS predictions
CREATE TABLE dless (
    chrom varchar(255) not null,	# Chromosome or FPC contig
    chromStart int unsigned not null,	# Start position in chromosome
    chromEnd int unsigned not null,	# End position in chromosome
    name varchar(255) not null,	# Name of item (id)
    score float not null,	# Log-odds score (bits)
    type char(10) not null,	# Type of prediction.  enum('conserved', 'gain', 'loss')
    branch varchar(255) not null,	# Branch on which element was gained or lost
    pConsSub float not null,	# P-value of conservation in subtree beneath event
    pConsSup float not null,	# P-value of conservation in rest of tree
    pConsSubCond float not null,	# Conditional P-value of conservation in subtree given total
    pConsSupCond float not null,	# Conditional P-value of conservation in rest of tree given total
    condApprox char(7) not null,	# Whether approximation was used for conditional P-values.  enum('approx', 'exact')
    priorMeanSub float not null,	# Mean of prior distribution, subtree
    priorVarSub float not null,	# Variance of prior distribution, subtree
    priorMinSub int unsigned not null,	# Min of 95% c.i., subtree
    priorMaxSub int unsigned not null,	# Max of 95% c.i., subtree
    postMeanSub float not null,	# Mean of posterior distribution, subtree
    postVarSub float not null,	# Variance of posterior distribution, subtree
    priorMeanSup float not null,	# Mean of prior distribution, rest of tree
    priorVarSup float not null,	# Variance of prior distribution, rest of tree
    priorMinSup int unsigned not null,	# Min of 95% c.i., rest of tree
    priorMaxSup int unsigned not null,	# Max of 95% c.i., rest of tree
    postMeanSup float not null,	# Mean of posterior distribution, rest of tree
    postVarSup float not null,	# Variance of posterior distribution, rest of tree
              #Indices
    PRIMARY KEY(name)
);
