/* ld2.c was originally generated by the autoSql program, which also 
 * generated ld2.h and ld2.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "ld2.h"


void ld2StaticLoad(char **row, struct ld2 *ret)
/* Load a row from ld2 table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->ldCount = sqlUnsigned(row[4]);
ret->dprime = row[5];
ret->rsquared = row[6];
ret->lod = row[7];
ret->avgDprime = row[8][0];
ret->avgRsquared = row[9][0];
ret->avgLod = row[10][0];
ret->tInt = row[11][0];
}

struct ld2 *ld2Load(char **row)
/* Load a ld2 from row fetched with select * from ld2
 * from database.  Dispose of this with ld2Free(). */
{
struct ld2 *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->ldCount = sqlUnsigned(row[4]);
ret->dprime = cloneString(row[5]);
ret->rsquared = cloneString(row[6]);
ret->lod = cloneString(row[7]);
ret->avgDprime = row[8][0];
ret->avgRsquared = row[9][0];
ret->avgLod = row[10][0];
ret->tInt = row[11][0];
return ret;
}

struct ld2 *ld2LoadAll(char *fileName) 
/* Load all ld2 from a whitespace-separated file.
 * Dispose of this with ld2FreeList(). */
{
struct ld2 *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[12];

while (lineFileRow(lf, row))
    {
    el = ld2Load(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ld2 *ld2LoadAllByChar(char *fileName, char chopper) 
/* Load all ld2 from a chopper separated file.
 * Dispose of this with ld2FreeList(). */
{
struct ld2 *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[12];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = ld2Load(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ld2 *ld2CommaIn(char **pS, struct ld2 *ret)
/* Create a ld2 out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ld2 */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->ldCount = sqlUnsignedComma(&s);
ret->dprime = sqlStringComma(&s);
ret->rsquared = sqlStringComma(&s);
ret->lod = sqlStringComma(&s);
sqlFixedStringComma(&s, &(ret->avgDprime), sizeof(ret->avgDprime));
sqlFixedStringComma(&s, &(ret->avgRsquared), sizeof(ret->avgRsquared));
sqlFixedStringComma(&s, &(ret->avgLod), sizeof(ret->avgLod));
sqlFixedStringComma(&s, &(ret->tInt), sizeof(ret->tInt));
*pS = s;
return ret;
}

void ld2Free(struct ld2 **pEl)
/* Free a single dynamically allocated ld2 such as created
 * with ld2Load(). */
{
struct ld2 *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->dprime);
freeMem(el->rsquared);
freeMem(el->lod);
freez(pEl);
}

void ld2FreeList(struct ld2 **pList)
/* Free a list of dynamically allocated ld2's */
{
struct ld2 *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    ld2Free(&el);
    }
*pList = NULL;
}

void ld2Output(struct ld2 *el, FILE *f, char sep, char lastSep) 
/* Print out ld2.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->ldCount);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->dprime);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->rsquared);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->lod);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->avgDprime);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->avgRsquared);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->avgLod);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->tInt);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

