/* visiGene.h was originally generated by the autoSql program, which also 
 * generated visiGene.c and visiGene.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef VISIGENE_H
#define VISIGENE_H

#define FILELOCATION_NUM_COLS 2

struct fileLocation
/* Location of image, typically a file directory */
    {
    struct fileLocation *next;  /* Next in singly linked list. */
    int id;	/* ID of location */
    char *name;	/* Directory path usually */
    };

void fileLocationStaticLoad(char **row, struct fileLocation *ret);
/* Load a row from fileLocation table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct fileLocation *fileLocationLoad(char **row);
/* Load a fileLocation from row fetched with select * from fileLocation
 * from database.  Dispose of this with fileLocationFree(). */

struct fileLocation *fileLocationLoadAll(char *fileName);
/* Load all fileLocation from whitespace-separated file.
 * Dispose of this with fileLocationFreeList(). */

struct fileLocation *fileLocationLoadAllByChar(char *fileName, char chopper);
/* Load all fileLocation from chopper separated file.
 * Dispose of this with fileLocationFreeList(). */

#define fileLocationLoadAllByTab(a) fileLocationLoadAllByChar(a, '\t');
/* Load all fileLocation from tab separated file.
 * Dispose of this with fileLocationFreeList(). */

struct fileLocation *fileLocationCommaIn(char **pS, struct fileLocation *ret);
/* Create a fileLocation out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new fileLocation */

void fileLocationFree(struct fileLocation **pEl);
/* Free a single dynamically allocated fileLocation such as created
 * with fileLocationLoad(). */

void fileLocationFreeList(struct fileLocation **pList);
/* Free a list of dynamically allocated fileLocation's */

void fileLocationOutput(struct fileLocation *el, FILE *f, char sep, char lastSep);
/* Print out fileLocation.  Separate fields with sep. Follow last field with lastSep. */

#define fileLocationTabOut(el,f) fileLocationOutput(el,f,'\t','\n');
/* Print out fileLocation as a line in a tab-separated file. */

#define fileLocationCommaOut(el,f) fileLocationOutput(el,f,',',',');
/* Print out fileLocation as a comma separated list including final comma. */

#define STRAIN_NUM_COLS 3

struct strain
/* Name of strain (eg C57BL for a mouse) */
    {
    struct strain *next;  /* Next in singly linked list. */
    int id;	/* ID of strain */
    int taxon;	/* NCBI taxon of organism */
    char *name;	/* Name of strain */
    };

void strainStaticLoad(char **row, struct strain *ret);
/* Load a row from strain table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct strain *strainLoad(char **row);
/* Load a strain from row fetched with select * from strain
 * from database.  Dispose of this with strainFree(). */

struct strain *strainLoadAll(char *fileName);
/* Load all strain from whitespace-separated file.
 * Dispose of this with strainFreeList(). */

struct strain *strainLoadAllByChar(char *fileName, char chopper);
/* Load all strain from chopper separated file.
 * Dispose of this with strainFreeList(). */

#define strainLoadAllByTab(a) strainLoadAllByChar(a, '\t');
/* Load all strain from tab separated file.
 * Dispose of this with strainFreeList(). */

struct strain *strainCommaIn(char **pS, struct strain *ret);
/* Create a strain out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new strain */

void strainFree(struct strain **pEl);
/* Free a single dynamically allocated strain such as created
 * with strainLoad(). */

void strainFreeList(struct strain **pList);
/* Free a list of dynamically allocated strain's */

void strainOutput(struct strain *el, FILE *f, char sep, char lastSep);
/* Print out strain.  Separate fields with sep. Follow last field with lastSep. */

#define strainTabOut(el,f) strainOutput(el,f,'\t','\n');
/* Print out strain as a line in a tab-separated file. */

#define strainCommaOut(el,f) strainOutput(el,f,',',',');
/* Print out strain as a comma separated list including final comma. */

#define BODYPART_NUM_COLS 2

struct bodyPart
/* Brain, eye, kidney, etc.  Use 'whole' for whole body */
    {
    struct bodyPart *next;  /* Next in singly linked list. */
    int id;	/* ID of body part */
    char *name;	/* Name of body part */
    };

void bodyPartStaticLoad(char **row, struct bodyPart *ret);
/* Load a row from bodyPart table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct bodyPart *bodyPartLoad(char **row);
/* Load a bodyPart from row fetched with select * from bodyPart
 * from database.  Dispose of this with bodyPartFree(). */

struct bodyPart *bodyPartLoadAll(char *fileName);
/* Load all bodyPart from whitespace-separated file.
 * Dispose of this with bodyPartFreeList(). */

struct bodyPart *bodyPartLoadAllByChar(char *fileName, char chopper);
/* Load all bodyPart from chopper separated file.
 * Dispose of this with bodyPartFreeList(). */

#define bodyPartLoadAllByTab(a) bodyPartLoadAllByChar(a, '\t');
/* Load all bodyPart from tab separated file.
 * Dispose of this with bodyPartFreeList(). */

struct bodyPart *bodyPartCommaIn(char **pS, struct bodyPart *ret);
/* Create a bodyPart out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bodyPart */

void bodyPartFree(struct bodyPart **pEl);
/* Free a single dynamically allocated bodyPart such as created
 * with bodyPartLoad(). */

void bodyPartFreeList(struct bodyPart **pList);
/* Free a list of dynamically allocated bodyPart's */

void bodyPartOutput(struct bodyPart *el, FILE *f, char sep, char lastSep);
/* Print out bodyPart.  Separate fields with sep. Follow last field with lastSep. */

#define bodyPartTabOut(el,f) bodyPartOutput(el,f,'\t','\n');
/* Print out bodyPart as a line in a tab-separated file. */

#define bodyPartCommaOut(el,f) bodyPartOutput(el,f,',',',');
/* Print out bodyPart as a comma separated list including final comma. */

#define CELLTYPE_NUM_COLS 2

struct cellType
/* Neuron, glia, etc. */
    {
    struct cellType *next;  /* Next in singly linked list. */
    int id;	/* ID of cell type */
    char *name;	/* Name of cell type */
    };

void cellTypeStaticLoad(char **row, struct cellType *ret);
/* Load a row from cellType table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cellType *cellTypeLoad(char **row);
/* Load a cellType from row fetched with select * from cellType
 * from database.  Dispose of this with cellTypeFree(). */

struct cellType *cellTypeLoadAll(char *fileName);
/* Load all cellType from whitespace-separated file.
 * Dispose of this with cellTypeFreeList(). */

struct cellType *cellTypeLoadAllByChar(char *fileName, char chopper);
/* Load all cellType from chopper separated file.
 * Dispose of this with cellTypeFreeList(). */

#define cellTypeLoadAllByTab(a) cellTypeLoadAllByChar(a, '\t');
/* Load all cellType from tab separated file.
 * Dispose of this with cellTypeFreeList(). */

struct cellType *cellTypeCommaIn(char **pS, struct cellType *ret);
/* Create a cellType out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cellType */

void cellTypeFree(struct cellType **pEl);
/* Free a single dynamically allocated cellType such as created
 * with cellTypeLoad(). */

void cellTypeFreeList(struct cellType **pList);
/* Free a list of dynamically allocated cellType's */

void cellTypeOutput(struct cellType *el, FILE *f, char sep, char lastSep);
/* Print out cellType.  Separate fields with sep. Follow last field with lastSep. */

#define cellTypeTabOut(el,f) cellTypeOutput(el,f,'\t','\n');
/* Print out cellType as a line in a tab-separated file. */

#define cellTypeCommaOut(el,f) cellTypeOutput(el,f,',',',');
/* Print out cellType as a comma separated list including final comma. */

#define CELLSUBTYPE_NUM_COLS 2

struct cellSubtype
/* A more detailed splitting up of cell types.  What type of neuron, etc. */
    {
    struct cellSubtype *next;  /* Next in singly linked list. */
    int id;	/* ID of cell subtype */
    char *name;	/* Name of cell subtype */
    };

void cellSubtypeStaticLoad(char **row, struct cellSubtype *ret);
/* Load a row from cellSubtype table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cellSubtype *cellSubtypeLoad(char **row);
/* Load a cellSubtype from row fetched with select * from cellSubtype
 * from database.  Dispose of this with cellSubtypeFree(). */

struct cellSubtype *cellSubtypeLoadAll(char *fileName);
/* Load all cellSubtype from whitespace-separated file.
 * Dispose of this with cellSubtypeFreeList(). */

struct cellSubtype *cellSubtypeLoadAllByChar(char *fileName, char chopper);
/* Load all cellSubtype from chopper separated file.
 * Dispose of this with cellSubtypeFreeList(). */

#define cellSubtypeLoadAllByTab(a) cellSubtypeLoadAllByChar(a, '\t');
/* Load all cellSubtype from tab separated file.
 * Dispose of this with cellSubtypeFreeList(). */

struct cellSubtype *cellSubtypeCommaIn(char **pS, struct cellSubtype *ret);
/* Create a cellSubtype out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cellSubtype */

void cellSubtypeFree(struct cellSubtype **pEl);
/* Free a single dynamically allocated cellSubtype such as created
 * with cellSubtypeLoad(). */

void cellSubtypeFreeList(struct cellSubtype **pList);
/* Free a list of dynamically allocated cellSubtype's */

void cellSubtypeOutput(struct cellSubtype *el, FILE *f, char sep, char lastSep);
/* Print out cellSubtype.  Separate fields with sep. Follow last field with lastSep. */

#define cellSubtypeTabOut(el,f) cellSubtypeOutput(el,f,'\t','\n');
/* Print out cellSubtype as a line in a tab-separated file. */

#define cellSubtypeCommaOut(el,f) cellSubtypeOutput(el,f,',',',');
/* Print out cellSubtype as a comma separated list including final comma. */

#define SLICETYPE_NUM_COLS 2

struct sliceType
/* Horizontal, coronal, whole mount, etc. */
    {
    struct sliceType *next;  /* Next in singly linked list. */
    int id;	/* ID of section */
    char *name;	/* Name of horizontal/whole mount, etc. */
    };

void sliceTypeStaticLoad(char **row, struct sliceType *ret);
/* Load a row from sliceType table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct sliceType *sliceTypeLoad(char **row);
/* Load a sliceType from row fetched with select * from sliceType
 * from database.  Dispose of this with sliceTypeFree(). */

struct sliceType *sliceTypeLoadAll(char *fileName);
/* Load all sliceType from whitespace-separated file.
 * Dispose of this with sliceTypeFreeList(). */

struct sliceType *sliceTypeLoadAllByChar(char *fileName, char chopper);
/* Load all sliceType from chopper separated file.
 * Dispose of this with sliceTypeFreeList(). */

#define sliceTypeLoadAllByTab(a) sliceTypeLoadAllByChar(a, '\t');
/* Load all sliceType from tab separated file.
 * Dispose of this with sliceTypeFreeList(). */

struct sliceType *sliceTypeCommaIn(char **pS, struct sliceType *ret);
/* Create a sliceType out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new sliceType */

void sliceTypeFree(struct sliceType **pEl);
/* Free a single dynamically allocated sliceType such as created
 * with sliceTypeLoad(). */

void sliceTypeFreeList(struct sliceType **pList);
/* Free a list of dynamically allocated sliceType's */

void sliceTypeOutput(struct sliceType *el, FILE *f, char sep, char lastSep);
/* Print out sliceType.  Separate fields with sep. Follow last field with lastSep. */

#define sliceTypeTabOut(el,f) sliceTypeOutput(el,f,'\t','\n');
/* Print out sliceType as a line in a tab-separated file. */

#define sliceTypeCommaOut(el,f) sliceTypeOutput(el,f,',',',');
/* Print out sliceType as a comma separated list including final comma. */

#define FIXATION_NUM_COLS 2

struct fixation
/* Fixation conditions - 3% formaldehyde or the like */
    {
    struct fixation *next;  /* Next in singly linked list. */
    int id;	/* ID of fixation */
    char *description;	/* Text string describing fixation */
    };

void fixationStaticLoad(char **row, struct fixation *ret);
/* Load a row from fixation table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct fixation *fixationLoad(char **row);
/* Load a fixation from row fetched with select * from fixation
 * from database.  Dispose of this with fixationFree(). */

struct fixation *fixationLoadAll(char *fileName);
/* Load all fixation from whitespace-separated file.
 * Dispose of this with fixationFreeList(). */

struct fixation *fixationLoadAllByChar(char *fileName, char chopper);
/* Load all fixation from chopper separated file.
 * Dispose of this with fixationFreeList(). */

#define fixationLoadAllByTab(a) fixationLoadAllByChar(a, '\t');
/* Load all fixation from tab separated file.
 * Dispose of this with fixationFreeList(). */

struct fixation *fixationCommaIn(char **pS, struct fixation *ret);
/* Create a fixation out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new fixation */

void fixationFree(struct fixation **pEl);
/* Free a single dynamically allocated fixation such as created
 * with fixationLoad(). */

void fixationFreeList(struct fixation **pList);
/* Free a list of dynamically allocated fixation's */

void fixationOutput(struct fixation *el, FILE *f, char sep, char lastSep);
/* Print out fixation.  Separate fields with sep. Follow last field with lastSep. */

#define fixationTabOut(el,f) fixationOutput(el,f,'\t','\n');
/* Print out fixation as a line in a tab-separated file. */

#define fixationCommaOut(el,f) fixationOutput(el,f,',',',');
/* Print out fixation as a comma separated list including final comma. */

#define EMBEDDING_NUM_COLS 2

struct embedding
/* Embedding media for slices - paraffin, etc. */
    {
    struct embedding *next;  /* Next in singly linked list. */
    int id;	/* ID of embedding */
    char *description;	/* Text string describing embedding */
    };

void embeddingStaticLoad(char **row, struct embedding *ret);
/* Load a row from embedding table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct embedding *embeddingLoad(char **row);
/* Load a embedding from row fetched with select * from embedding
 * from database.  Dispose of this with embeddingFree(). */

struct embedding *embeddingLoadAll(char *fileName);
/* Load all embedding from whitespace-separated file.
 * Dispose of this with embeddingFreeList(). */

struct embedding *embeddingLoadAllByChar(char *fileName, char chopper);
/* Load all embedding from chopper separated file.
 * Dispose of this with embeddingFreeList(). */

#define embeddingLoadAllByTab(a) embeddingLoadAllByChar(a, '\t');
/* Load all embedding from tab separated file.
 * Dispose of this with embeddingFreeList(). */

struct embedding *embeddingCommaIn(char **pS, struct embedding *ret);
/* Create a embedding out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new embedding */

void embeddingFree(struct embedding **pEl);
/* Free a single dynamically allocated embedding such as created
 * with embeddingLoad(). */

void embeddingFreeList(struct embedding **pList);
/* Free a list of dynamically allocated embedding's */

void embeddingOutput(struct embedding *el, FILE *f, char sep, char lastSep);
/* Print out embedding.  Separate fields with sep. Follow last field with lastSep. */

#define embeddingTabOut(el,f) embeddingOutput(el,f,'\t','\n');
/* Print out embedding as a line in a tab-separated file. */

#define embeddingCommaOut(el,f) embeddingOutput(el,f,',',',');
/* Print out embedding as a comma separated list including final comma. */

#define PERMEABLIZATION_NUM_COLS 2

struct permeablization
/* Permeablization conditions */
    {
    struct permeablization *next;  /* Next in singly linked list. */
    int id;	/* ID of treatment */
    char *description;	/* Text string describing conditions */
    };

void permeablizationStaticLoad(char **row, struct permeablization *ret);
/* Load a row from permeablization table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct permeablization *permeablizationLoad(char **row);
/* Load a permeablization from row fetched with select * from permeablization
 * from database.  Dispose of this with permeablizationFree(). */

struct permeablization *permeablizationLoadAll(char *fileName);
/* Load all permeablization from whitespace-separated file.
 * Dispose of this with permeablizationFreeList(). */

struct permeablization *permeablizationLoadAllByChar(char *fileName, char chopper);
/* Load all permeablization from chopper separated file.
 * Dispose of this with permeablizationFreeList(). */

#define permeablizationLoadAllByTab(a) permeablizationLoadAllByChar(a, '\t');
/* Load all permeablization from tab separated file.
 * Dispose of this with permeablizationFreeList(). */

struct permeablization *permeablizationCommaIn(char **pS, struct permeablization *ret);
/* Create a permeablization out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new permeablization */

void permeablizationFree(struct permeablization **pEl);
/* Free a single dynamically allocated permeablization such as created
 * with permeablizationLoad(). */

void permeablizationFreeList(struct permeablization **pList);
/* Free a list of dynamically allocated permeablization's */

void permeablizationOutput(struct permeablization *el, FILE *f, char sep, char lastSep);
/* Print out permeablization.  Separate fields with sep. Follow last field with lastSep. */

#define permeablizationTabOut(el,f) permeablizationOutput(el,f,'\t','\n');
/* Print out permeablization as a line in a tab-separated file. */

#define permeablizationCommaOut(el,f) permeablizationOutput(el,f,',',',');
/* Print out permeablization as a comma separated list including final comma. */

#define CONTRIBUTOR_NUM_COLS 2

struct contributor
/* Info on contributor */
    {
    struct contributor *next;  /* Next in singly linked list. */
    int id;	/* ID of contributor */
    char *name;	/* Name in format like Kent W.J. */
    };

void contributorStaticLoad(char **row, struct contributor *ret);
/* Load a row from contributor table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct contributor *contributorLoad(char **row);
/* Load a contributor from row fetched with select * from contributor
 * from database.  Dispose of this with contributorFree(). */

struct contributor *contributorLoadAll(char *fileName);
/* Load all contributor from whitespace-separated file.
 * Dispose of this with contributorFreeList(). */

struct contributor *contributorLoadAllByChar(char *fileName, char chopper);
/* Load all contributor from chopper separated file.
 * Dispose of this with contributorFreeList(). */

#define contributorLoadAllByTab(a) contributorLoadAllByChar(a, '\t');
/* Load all contributor from tab separated file.
 * Dispose of this with contributorFreeList(). */

struct contributor *contributorCommaIn(char **pS, struct contributor *ret);
/* Create a contributor out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new contributor */

void contributorFree(struct contributor **pEl);
/* Free a single dynamically allocated contributor such as created
 * with contributorLoad(). */

void contributorFreeList(struct contributor **pList);
/* Free a list of dynamically allocated contributor's */

void contributorOutput(struct contributor *el, FILE *f, char sep, char lastSep);
/* Print out contributor.  Separate fields with sep. Follow last field with lastSep. */

#define contributorTabOut(el,f) contributorOutput(el,f,'\t','\n');
/* Print out contributor as a line in a tab-separated file. */

#define contributorCommaOut(el,f) contributorOutput(el,f,',',',');
/* Print out contributor as a comma separated list including final comma. */

#define JOURNAL_NUM_COLS 3

struct journal
/* Information on a journal */
    {
    struct journal *next;  /* Next in singly linked list. */
    int id;	/* ID of journal */
    char *name;	/* Name of journal */
    char *url;	/* Journal's main URL */
    };

void journalStaticLoad(char **row, struct journal *ret);
/* Load a row from journal table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct journal *journalLoad(char **row);
/* Load a journal from row fetched with select * from journal
 * from database.  Dispose of this with journalFree(). */

struct journal *journalLoadAll(char *fileName);
/* Load all journal from whitespace-separated file.
 * Dispose of this with journalFreeList(). */

struct journal *journalLoadAllByChar(char *fileName, char chopper);
/* Load all journal from chopper separated file.
 * Dispose of this with journalFreeList(). */

#define journalLoadAllByTab(a) journalLoadAllByChar(a, '\t');
/* Load all journal from tab separated file.
 * Dispose of this with journalFreeList(). */

struct journal *journalCommaIn(char **pS, struct journal *ret);
/* Create a journal out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new journal */

void journalFree(struct journal **pEl);
/* Free a single dynamically allocated journal such as created
 * with journalLoad(). */

void journalFreeList(struct journal **pList);
/* Free a list of dynamically allocated journal's */

void journalOutput(struct journal *el, FILE *f, char sep, char lastSep);
/* Print out journal.  Separate fields with sep. Follow last field with lastSep. */

#define journalTabOut(el,f) journalOutput(el,f,'\t','\n');
/* Print out journal as a line in a tab-separated file. */

#define journalCommaOut(el,f) journalOutput(el,f,',',',');
/* Print out journal as a comma separated list including final comma. */

#define COPYRIGHT_NUM_COLS 2

struct copyright
/* Copyright information */
    {
    struct copyright *next;  /* Next in singly linked list. */
    int id;	/* ID of copyright */
    char *notice;	/* Text of copyright notice */
    };

void copyrightStaticLoad(char **row, struct copyright *ret);
/* Load a row from copyright table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct copyright *copyrightLoad(char **row);
/* Load a copyright from row fetched with select * from copyright
 * from database.  Dispose of this with copyrightFree(). */

struct copyright *copyrightLoadAll(char *fileName);
/* Load all copyright from whitespace-separated file.
 * Dispose of this with copyrightFreeList(). */

struct copyright *copyrightLoadAllByChar(char *fileName, char chopper);
/* Load all copyright from chopper separated file.
 * Dispose of this with copyrightFreeList(). */

#define copyrightLoadAllByTab(a) copyrightLoadAllByChar(a, '\t');
/* Load all copyright from tab separated file.
 * Dispose of this with copyrightFreeList(). */

struct copyright *copyrightCommaIn(char **pS, struct copyright *ret);
/* Create a copyright out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new copyright */

void copyrightFree(struct copyright **pEl);
/* Free a single dynamically allocated copyright such as created
 * with copyrightLoad(). */

void copyrightFreeList(struct copyright **pList);
/* Free a list of dynamically allocated copyright's */

void copyrightOutput(struct copyright *el, FILE *f, char sep, char lastSep);
/* Print out copyright.  Separate fields with sep. Follow last field with lastSep. */

#define copyrightTabOut(el,f) copyrightOutput(el,f,'\t','\n');
/* Print out copyright as a line in a tab-separated file. */

#define copyrightCommaOut(el,f) copyrightOutput(el,f,',',',');
/* Print out copyright as a comma separated list including final comma. */

#define SUBMISSIONSOURCE_NUM_COLS 5

struct submissionSource
/* Source of data - an external database, a contributor, etc. */
    {
    struct submissionSource *next;  /* Next in singly linked list. */
    int id;	/* ID of submission source */
    char *name;	/* Short name: Jackson Labs, Paul Gray, etc. */
    char *acknowledgement;	/* Something extra to put in the caption after copyright */
    char *sourceUrl;	/* URL for image source */
    char *itemUrl;	/* URL for item.  Put %s where imageFile.submitId should go */
    };

void submissionSourceStaticLoad(char **row, struct submissionSource *ret);
/* Load a row from submissionSource table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct submissionSource *submissionSourceLoad(char **row);
/* Load a submissionSource from row fetched with select * from submissionSource
 * from database.  Dispose of this with submissionSourceFree(). */

struct submissionSource *submissionSourceLoadAll(char *fileName);
/* Load all submissionSource from whitespace-separated file.
 * Dispose of this with submissionSourceFreeList(). */

struct submissionSource *submissionSourceLoadAllByChar(char *fileName, char chopper);
/* Load all submissionSource from chopper separated file.
 * Dispose of this with submissionSourceFreeList(). */

#define submissionSourceLoadAllByTab(a) submissionSourceLoadAllByChar(a, '\t');
/* Load all submissionSource from tab separated file.
 * Dispose of this with submissionSourceFreeList(). */

struct submissionSource *submissionSourceCommaIn(char **pS, struct submissionSource *ret);
/* Create a submissionSource out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new submissionSource */

void submissionSourceFree(struct submissionSource **pEl);
/* Free a single dynamically allocated submissionSource such as created
 * with submissionSourceLoad(). */

void submissionSourceFreeList(struct submissionSource **pList);
/* Free a list of dynamically allocated submissionSource's */

void submissionSourceOutput(struct submissionSource *el, FILE *f, char sep, char lastSep);
/* Print out submissionSource.  Separate fields with sep. Follow last field with lastSep. */

#define submissionSourceTabOut(el,f) submissionSourceOutput(el,f,'\t','\n');
/* Print out submissionSource as a line in a tab-separated file. */

#define submissionSourceCommaOut(el,f) submissionSourceOutput(el,f,',',',');
/* Print out submissionSource as a comma separated list including final comma. */

#define SUBMISSIONSET_NUM_COLS 10

struct submissionSet
/* Info on a batch of images submitted at once */
    {
    struct submissionSet *next;  /* Next in singly linked list. */
    int id;	/* ID of submission set */
    char *name;	/* Name of submission set */
    char *contributors;	/* Comma-separated list of contributors in format Kent W.J., Wu F.Y. */
    int year;	/* Year of publication or submission */
    char *publication;	/* Name of publication */
    char *pubUrl;	/* Publication URL */
    int journal;	/* Journal for publication */
    int copyright;	/* Copyright notice */
    int submissionSource;	/* Source of this submission */
    int privateUser;	/* ID of user allowed to view. If 0 all can see. */
    };

void submissionSetStaticLoad(char **row, struct submissionSet *ret);
/* Load a row from submissionSet table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct submissionSet *submissionSetLoad(char **row);
/* Load a submissionSet from row fetched with select * from submissionSet
 * from database.  Dispose of this with submissionSetFree(). */

struct submissionSet *submissionSetLoadAll(char *fileName);
/* Load all submissionSet from whitespace-separated file.
 * Dispose of this with submissionSetFreeList(). */

struct submissionSet *submissionSetLoadAllByChar(char *fileName, char chopper);
/* Load all submissionSet from chopper separated file.
 * Dispose of this with submissionSetFreeList(). */

#define submissionSetLoadAllByTab(a) submissionSetLoadAllByChar(a, '\t');
/* Load all submissionSet from tab separated file.
 * Dispose of this with submissionSetFreeList(). */

struct submissionSet *submissionSetCommaIn(char **pS, struct submissionSet *ret);
/* Create a submissionSet out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new submissionSet */

void submissionSetFree(struct submissionSet **pEl);
/* Free a single dynamically allocated submissionSet such as created
 * with submissionSetLoad(). */

void submissionSetFreeList(struct submissionSet **pList);
/* Free a list of dynamically allocated submissionSet's */

void submissionSetOutput(struct submissionSet *el, FILE *f, char sep, char lastSep);
/* Print out submissionSet.  Separate fields with sep. Follow last field with lastSep. */

#define submissionSetTabOut(el,f) submissionSetOutput(el,f,'\t','\n');
/* Print out submissionSet as a line in a tab-separated file. */

#define submissionSetCommaOut(el,f) submissionSetOutput(el,f,',',',');
/* Print out submissionSet as a comma separated list including final comma. */

#define SUBMISSIONCONTRIBUTOR_NUM_COLS 2

struct submissionContributor
/* Association between contributors and submissionSets */
    {
    struct submissionContributor *next;  /* Next in singly linked list. */
    int submissionSet;	/* ID in submissionSet table */
    int contributor;	/* ID in contributor table */
    };

void submissionContributorStaticLoad(char **row, struct submissionContributor *ret);
/* Load a row from submissionContributor table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct submissionContributor *submissionContributorLoad(char **row);
/* Load a submissionContributor from row fetched with select * from submissionContributor
 * from database.  Dispose of this with submissionContributorFree(). */

struct submissionContributor *submissionContributorLoadAll(char *fileName);
/* Load all submissionContributor from whitespace-separated file.
 * Dispose of this with submissionContributorFreeList(). */

struct submissionContributor *submissionContributorLoadAllByChar(char *fileName, char chopper);
/* Load all submissionContributor from chopper separated file.
 * Dispose of this with submissionContributorFreeList(). */

#define submissionContributorLoadAllByTab(a) submissionContributorLoadAllByChar(a, '\t');
/* Load all submissionContributor from tab separated file.
 * Dispose of this with submissionContributorFreeList(). */

struct submissionContributor *submissionContributorCommaIn(char **pS, struct submissionContributor *ret);
/* Create a submissionContributor out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new submissionContributor */

void submissionContributorFree(struct submissionContributor **pEl);
/* Free a single dynamically allocated submissionContributor such as created
 * with submissionContributorLoad(). */

void submissionContributorFreeList(struct submissionContributor **pList);
/* Free a list of dynamically allocated submissionContributor's */

void submissionContributorOutput(struct submissionContributor *el, FILE *f, char sep, char lastSep);
/* Print out submissionContributor.  Separate fields with sep. Follow last field with lastSep. */

#define submissionContributorTabOut(el,f) submissionContributorOutput(el,f,'\t','\n');
/* Print out submissionContributor as a line in a tab-separated file. */

#define submissionContributorCommaOut(el,f) submissionContributorOutput(el,f,',',',');
/* Print out submissionContributor as a comma separated list including final comma. */

#define SECTIONSET_NUM_COLS 1

struct sectionSet
/* Info on a bunch of sections through same sample */
    {
    struct sectionSet *next;  /* Next in singly linked list. */
    int id;	/* Section ID */
    };

void sectionSetStaticLoad(char **row, struct sectionSet *ret);
/* Load a row from sectionSet table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct sectionSet *sectionSetLoad(char **row);
/* Load a sectionSet from row fetched with select * from sectionSet
 * from database.  Dispose of this with sectionSetFree(). */

struct sectionSet *sectionSetLoadAll(char *fileName);
/* Load all sectionSet from whitespace-separated file.
 * Dispose of this with sectionSetFreeList(). */

struct sectionSet *sectionSetLoadAllByChar(char *fileName, char chopper);
/* Load all sectionSet from chopper separated file.
 * Dispose of this with sectionSetFreeList(). */

#define sectionSetLoadAllByTab(a) sectionSetLoadAllByChar(a, '\t');
/* Load all sectionSet from tab separated file.
 * Dispose of this with sectionSetFreeList(). */

struct sectionSet *sectionSetCommaIn(char **pS, struct sectionSet *ret);
/* Create a sectionSet out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new sectionSet */

void sectionSetFree(struct sectionSet **pEl);
/* Free a single dynamically allocated sectionSet such as created
 * with sectionSetLoad(). */

void sectionSetFreeList(struct sectionSet **pList);
/* Free a list of dynamically allocated sectionSet's */

void sectionSetOutput(struct sectionSet *el, FILE *f, char sep, char lastSep);
/* Print out sectionSet.  Separate fields with sep. Follow last field with lastSep. */

#define sectionSetTabOut(el,f) sectionSetOutput(el,f,'\t','\n');
/* Print out sectionSet as a line in a tab-separated file. */

#define sectionSetCommaOut(el,f) sectionSetOutput(el,f,',',',');
/* Print out sectionSet as a comma separated list including final comma. */

#define ANTIBODY_NUM_COLS 4

struct antibody
/* Information on an antibody */
    {
    struct antibody *next;  /* Next in singly linked list. */
    int id;	/* Antibody ID */
    char *name;	/* Name of antibody */
    char *description;	/* Description of antibody */
    int taxon;	/* NCBI Taxon of animal antibody is from */
    };

void antibodyStaticLoad(char **row, struct antibody *ret);
/* Load a row from antibody table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct antibody *antibodyLoad(char **row);
/* Load a antibody from row fetched with select * from antibody
 * from database.  Dispose of this with antibodyFree(). */

struct antibody *antibodyLoadAll(char *fileName);
/* Load all antibody from whitespace-separated file.
 * Dispose of this with antibodyFreeList(). */

struct antibody *antibodyLoadAllByChar(char *fileName, char chopper);
/* Load all antibody from chopper separated file.
 * Dispose of this with antibodyFreeList(). */

#define antibodyLoadAllByTab(a) antibodyLoadAllByChar(a, '\t');
/* Load all antibody from tab separated file.
 * Dispose of this with antibodyFreeList(). */

struct antibody *antibodyCommaIn(char **pS, struct antibody *ret);
/* Create a antibody out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new antibody */

void antibodyFree(struct antibody **pEl);
/* Free a single dynamically allocated antibody such as created
 * with antibodyLoad(). */

void antibodyFreeList(struct antibody **pList);
/* Free a list of dynamically allocated antibody's */

void antibodyOutput(struct antibody *el, FILE *f, char sep, char lastSep);
/* Print out antibody.  Separate fields with sep. Follow last field with lastSep. */

#define antibodyTabOut(el,f) antibodyOutput(el,f,'\t','\n');
/* Print out antibody as a line in a tab-separated file. */

#define antibodyCommaOut(el,f) antibodyOutput(el,f,',',',');
/* Print out antibody as a comma separated list including final comma. */

#define BAC_NUM_COLS 2

struct bac
/* Information on a bacterial artificial chromosome */
    {
    struct bac *next;  /* Next in singly linked list. */
    int id;	/* BAD id */
    char *name;	/* Name of BAC, often starts with RP */
    };

void bacStaticLoad(char **row, struct bac *ret);
/* Load a row from bac table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct bac *bacLoad(char **row);
/* Load a bac from row fetched with select * from bac
 * from database.  Dispose of this with bacFree(). */

struct bac *bacLoadAll(char *fileName);
/* Load all bac from whitespace-separated file.
 * Dispose of this with bacFreeList(). */

struct bac *bacLoadAllByChar(char *fileName, char chopper);
/* Load all bac from chopper separated file.
 * Dispose of this with bacFreeList(). */

#define bacLoadAllByTab(a) bacLoadAllByChar(a, '\t');
/* Load all bac from tab separated file.
 * Dispose of this with bacFreeList(). */

struct bac *bacCommaIn(char **pS, struct bac *ret);
/* Create a bac out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bac */

void bacFree(struct bac **pEl);
/* Free a single dynamically allocated bac such as created
 * with bacLoad(). */

void bacFreeList(struct bac **pList);
/* Free a list of dynamically allocated bac's */

void bacOutput(struct bac *el, FILE *f, char sep, char lastSep);
/* Print out bac.  Separate fields with sep. Follow last field with lastSep. */

#define bacTabOut(el,f) bacOutput(el,f,'\t','\n');
/* Print out bac as a line in a tab-separated file. */

#define bacCommaOut(el,f) bacOutput(el,f,',',',');
/* Print out bac as a comma separated list including final comma. */

#define GENE_NUM_COLS 7

struct gene
/* Info on a gene */
    {
    struct gene *next;  /* Next in singly linked list. */
    int id;	/* ID of gene */
    char *name;	/* Gene symbol (HUGO Gene Nomenclature Committee, if available) */
    char *locusLink;	/* NCBI LocusLink ID, or blank if none */
    char *refSeq;	/* RefSeq ID, or blank if none */
    char *genbank;	/* GenBank/EMBL accession, or blank if none */
    char *uniProt;	/* SwissProt/Uniprot accession, or blank if none */
    int taxon;	/* NCBI taxon ID of organism */
    };

void geneStaticLoad(char **row, struct gene *ret);
/* Load a row from gene table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct gene *geneLoad(char **row);
/* Load a gene from row fetched with select * from gene
 * from database.  Dispose of this with geneFree(). */

struct gene *geneLoadAll(char *fileName);
/* Load all gene from whitespace-separated file.
 * Dispose of this with geneFreeList(). */

struct gene *geneLoadAllByChar(char *fileName, char chopper);
/* Load all gene from chopper separated file.
 * Dispose of this with geneFreeList(). */

#define geneLoadAllByTab(a) geneLoadAllByChar(a, '\t');
/* Load all gene from tab separated file.
 * Dispose of this with geneFreeList(). */

struct gene *geneCommaIn(char **pS, struct gene *ret);
/* Create a gene out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gene */

void geneFree(struct gene **pEl);
/* Free a single dynamically allocated gene such as created
 * with geneLoad(). */

void geneFreeList(struct gene **pList);
/* Free a list of dynamically allocated gene's */

void geneOutput(struct gene *el, FILE *f, char sep, char lastSep);
/* Print out gene.  Separate fields with sep. Follow last field with lastSep. */

#define geneTabOut(el,f) geneOutput(el,f,'\t','\n');
/* Print out gene as a line in a tab-separated file. */

#define geneCommaOut(el,f) geneOutput(el,f,',',',');
/* Print out gene as a comma separated list including final comma. */

#define GENESYNONYM_NUM_COLS 2

struct geneSynonym
/* A synonym for a gene */
    {
    struct geneSynonym *next;  /* Next in singly linked list. */
    int gene;	/* ID in gene table */
    char *name;	/* Synonymous name for gene */
    };

void geneSynonymStaticLoad(char **row, struct geneSynonym *ret);
/* Load a row from geneSynonym table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct geneSynonym *geneSynonymLoad(char **row);
/* Load a geneSynonym from row fetched with select * from geneSynonym
 * from database.  Dispose of this with geneSynonymFree(). */

struct geneSynonym *geneSynonymLoadAll(char *fileName);
/* Load all geneSynonym from whitespace-separated file.
 * Dispose of this with geneSynonymFreeList(). */

struct geneSynonym *geneSynonymLoadAllByChar(char *fileName, char chopper);
/* Load all geneSynonym from chopper separated file.
 * Dispose of this with geneSynonymFreeList(). */

#define geneSynonymLoadAllByTab(a) geneSynonymLoadAllByChar(a, '\t');
/* Load all geneSynonym from tab separated file.
 * Dispose of this with geneSynonymFreeList(). */

struct geneSynonym *geneSynonymCommaIn(char **pS, struct geneSynonym *ret);
/* Create a geneSynonym out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new geneSynonym */

void geneSynonymFree(struct geneSynonym **pEl);
/* Free a single dynamically allocated geneSynonym such as created
 * with geneSynonymLoad(). */

void geneSynonymFreeList(struct geneSynonym **pList);
/* Free a list of dynamically allocated geneSynonym's */

void geneSynonymOutput(struct geneSynonym *el, FILE *f, char sep, char lastSep);
/* Print out geneSynonym.  Separate fields with sep. Follow last field with lastSep. */

#define geneSynonymTabOut(el,f) geneSynonymOutput(el,f,'\t','\n');
/* Print out geneSynonym as a line in a tab-separated file. */

#define geneSynonymCommaOut(el,f) geneSynonymOutput(el,f,',',',');
/* Print out geneSynonym as a comma separated list including final comma. */

#define ALLELE_NUM_COLS 3

struct allele
/* Name of a gene allele */
    {
    struct allele *next;  /* Next in singly linked list. */
    int id;	/* ID of allele */
    int gene;	/* ID of gene */
    char *name;	/* Allele name, + for wild type */
    };

void alleleStaticLoad(char **row, struct allele *ret);
/* Load a row from allele table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct allele *alleleLoad(char **row);
/* Load a allele from row fetched with select * from allele
 * from database.  Dispose of this with alleleFree(). */

struct allele *alleleLoadAll(char *fileName);
/* Load all allele from whitespace-separated file.
 * Dispose of this with alleleFreeList(). */

struct allele *alleleLoadAllByChar(char *fileName, char chopper);
/* Load all allele from chopper separated file.
 * Dispose of this with alleleFreeList(). */

#define alleleLoadAllByTab(a) alleleLoadAllByChar(a, '\t');
/* Load all allele from tab separated file.
 * Dispose of this with alleleFreeList(). */

struct allele *alleleCommaIn(char **pS, struct allele *ret);
/* Create a allele out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new allele */

void alleleFree(struct allele **pEl);
/* Free a single dynamically allocated allele such as created
 * with alleleLoad(). */

void alleleFreeList(struct allele **pList);
/* Free a list of dynamically allocated allele's */

void alleleOutput(struct allele *el, FILE *f, char sep, char lastSep);
/* Print out allele.  Separate fields with sep. Follow last field with lastSep. */

#define alleleTabOut(el,f) alleleOutput(el,f,'\t','\n');
/* Print out allele as a line in a tab-separated file. */

#define alleleCommaOut(el,f) alleleOutput(el,f,',',',');
/* Print out allele as a comma separated list including final comma. */

#define GENOTYPE_NUM_COLS 4

struct genotype
/* How different from wild type.  Associated with genotypeAllele table */
    {
    struct genotype *next;  /* Next in singly linked list. */
    int id;	/* Genotype ID */
    int taxon;	/* NCBI Taxon of organism */
    int strain;	/* Strain of organism */
    char *alleles;	/* Comma-separated list of gene:allele in alphabetical order */
    };

void genotypeStaticLoad(char **row, struct genotype *ret);
/* Load a row from genotype table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct genotype *genotypeLoad(char **row);
/* Load a genotype from row fetched with select * from genotype
 * from database.  Dispose of this with genotypeFree(). */

struct genotype *genotypeLoadAll(char *fileName);
/* Load all genotype from whitespace-separated file.
 * Dispose of this with genotypeFreeList(). */

struct genotype *genotypeLoadAllByChar(char *fileName, char chopper);
/* Load all genotype from chopper separated file.
 * Dispose of this with genotypeFreeList(). */

#define genotypeLoadAllByTab(a) genotypeLoadAllByChar(a, '\t');
/* Load all genotype from tab separated file.
 * Dispose of this with genotypeFreeList(). */

struct genotype *genotypeCommaIn(char **pS, struct genotype *ret);
/* Create a genotype out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new genotype */

void genotypeFree(struct genotype **pEl);
/* Free a single dynamically allocated genotype such as created
 * with genotypeLoad(). */

void genotypeFreeList(struct genotype **pList);
/* Free a list of dynamically allocated genotype's */

void genotypeOutput(struct genotype *el, FILE *f, char sep, char lastSep);
/* Print out genotype.  Separate fields with sep. Follow last field with lastSep. */

#define genotypeTabOut(el,f) genotypeOutput(el,f,'\t','\n');
/* Print out genotype as a line in a tab-separated file. */

#define genotypeCommaOut(el,f) genotypeOutput(el,f,',',',');
/* Print out genotype as a comma separated list including final comma. */

#define GENOTYPEALLELE_NUM_COLS 2

struct genotypeAllele
/* Association between genotype and alleles */
    {
    struct genotypeAllele *next;  /* Next in singly linked list. */
    int genotype;	/* Associated genotype */
    int allele;	/* Associated allele */
    };

void genotypeAlleleStaticLoad(char **row, struct genotypeAllele *ret);
/* Load a row from genotypeAllele table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct genotypeAllele *genotypeAlleleLoad(char **row);
/* Load a genotypeAllele from row fetched with select * from genotypeAllele
 * from database.  Dispose of this with genotypeAlleleFree(). */

struct genotypeAllele *genotypeAlleleLoadAll(char *fileName);
/* Load all genotypeAllele from whitespace-separated file.
 * Dispose of this with genotypeAlleleFreeList(). */

struct genotypeAllele *genotypeAlleleLoadAllByChar(char *fileName, char chopper);
/* Load all genotypeAllele from chopper separated file.
 * Dispose of this with genotypeAlleleFreeList(). */

#define genotypeAlleleLoadAllByTab(a) genotypeAlleleLoadAllByChar(a, '\t');
/* Load all genotypeAllele from tab separated file.
 * Dispose of this with genotypeAlleleFreeList(). */

struct genotypeAllele *genotypeAlleleCommaIn(char **pS, struct genotypeAllele *ret);
/* Create a genotypeAllele out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new genotypeAllele */

void genotypeAlleleFree(struct genotypeAllele **pEl);
/* Free a single dynamically allocated genotypeAllele such as created
 * with genotypeAlleleLoad(). */

void genotypeAlleleFreeList(struct genotypeAllele **pList);
/* Free a list of dynamically allocated genotypeAllele's */

void genotypeAlleleOutput(struct genotypeAllele *el, FILE *f, char sep, char lastSep);
/* Print out genotypeAllele.  Separate fields with sep. Follow last field with lastSep. */

#define genotypeAlleleTabOut(el,f) genotypeAlleleOutput(el,f,'\t','\n');
/* Print out genotypeAllele as a line in a tab-separated file. */

#define genotypeAlleleCommaOut(el,f) genotypeAlleleOutput(el,f,',',',');
/* Print out genotypeAllele as a comma separated list including final comma. */

#define SEX_NUM_COLS 2

struct sex
/* Sex of a specimen */
    {
    struct sex *next;  /* Next in singly linked list. */
    int id;	/* Sex ID */
    char *name;	/* Name of sex - male, female, hermaphrodite, mixed */
    };

void sexStaticLoad(char **row, struct sex *ret);
/* Load a row from sex table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct sex *sexLoad(char **row);
/* Load a sex from row fetched with select * from sex
 * from database.  Dispose of this with sexFree(). */

struct sex *sexLoadAll(char *fileName);
/* Load all sex from whitespace-separated file.
 * Dispose of this with sexFreeList(). */

struct sex *sexLoadAllByChar(char *fileName, char chopper);
/* Load all sex from chopper separated file.
 * Dispose of this with sexFreeList(). */

#define sexLoadAllByTab(a) sexLoadAllByChar(a, '\t');
/* Load all sex from tab separated file.
 * Dispose of this with sexFreeList(). */

struct sex *sexCommaIn(char **pS, struct sex *ret);
/* Create a sex out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new sex */

void sexFree(struct sex **pEl);
/* Free a single dynamically allocated sex such as created
 * with sexLoad(). */

void sexFreeList(struct sex **pList);
/* Free a list of dynamically allocated sex's */

void sexOutput(struct sex *el, FILE *f, char sep, char lastSep);
/* Print out sex.  Separate fields with sep. Follow last field with lastSep. */

#define sexTabOut(el,f) sexOutput(el,f,'\t','\n');
/* Print out sex as a line in a tab-separated file. */

#define sexCommaOut(el,f) sexOutput(el,f,',',',');
/* Print out sex as a comma separated list including final comma. */

#define SPECIMEN_NUM_COLS 10

struct specimen
/* A biological specimen - something mounted, possibly sliced up */
    {
    struct specimen *next;  /* Next in singly linked list. */
    int id;	/* Specimen ID */
    char *name;	/* Name of specimen, frequently blank */
    int taxon;	/* NCBI Taxon of organism */
    int genotype;	/* Genotype of specimen */
    int bodyPart;	/* Body part of specimen */
    int sex;	/* Sex - male, female or hermaphrodite */
    float age;	/* Age in days since conception */
    float minAge;	/* Minimum age */
    float maxAge;	/* Maximum age - may differ from minAge if uncertain of age */
    char *notes;	/* Any notes on specimen */
    };

void specimenStaticLoad(char **row, struct specimen *ret);
/* Load a row from specimen table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct specimen *specimenLoad(char **row);
/* Load a specimen from row fetched with select * from specimen
 * from database.  Dispose of this with specimenFree(). */

struct specimen *specimenLoadAll(char *fileName);
/* Load all specimen from whitespace-separated file.
 * Dispose of this with specimenFreeList(). */

struct specimen *specimenLoadAllByChar(char *fileName, char chopper);
/* Load all specimen from chopper separated file.
 * Dispose of this with specimenFreeList(). */

#define specimenLoadAllByTab(a) specimenLoadAllByChar(a, '\t');
/* Load all specimen from tab separated file.
 * Dispose of this with specimenFreeList(). */

struct specimen *specimenCommaIn(char **pS, struct specimen *ret);
/* Create a specimen out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new specimen */

void specimenFree(struct specimen **pEl);
/* Free a single dynamically allocated specimen such as created
 * with specimenLoad(). */

void specimenFreeList(struct specimen **pList);
/* Free a list of dynamically allocated specimen's */

void specimenOutput(struct specimen *el, FILE *f, char sep, char lastSep);
/* Print out specimen.  Separate fields with sep. Follow last field with lastSep. */

#define specimenTabOut(el,f) specimenOutput(el,f,'\t','\n');
/* Print out specimen as a line in a tab-separated file. */

#define specimenCommaOut(el,f) specimenOutput(el,f,',',',');
/* Print out specimen as a comma separated list including final comma. */

#define PREPARATION_NUM_COLS 6

struct preparation
/* How a specimen is prepared */
    {
    struct preparation *next;  /* Next in singly linked list. */
    int id;	/* Preparation ID */
    int fixation;	/* How fixed */
    int embedding;	/* How embedded */
    int permeablization;	/* How permeablized */
    int sliceType;	/* How it was sliced */
    char *notes;	/* Any other notes on preparation */
    };

void preparationStaticLoad(char **row, struct preparation *ret);
/* Load a row from preparation table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct preparation *preparationLoad(char **row);
/* Load a preparation from row fetched with select * from preparation
 * from database.  Dispose of this with preparationFree(). */

struct preparation *preparationLoadAll(char *fileName);
/* Load all preparation from whitespace-separated file.
 * Dispose of this with preparationFreeList(). */

struct preparation *preparationLoadAllByChar(char *fileName, char chopper);
/* Load all preparation from chopper separated file.
 * Dispose of this with preparationFreeList(). */

#define preparationLoadAllByTab(a) preparationLoadAllByChar(a, '\t');
/* Load all preparation from tab separated file.
 * Dispose of this with preparationFreeList(). */

struct preparation *preparationCommaIn(char **pS, struct preparation *ret);
/* Create a preparation out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new preparation */

void preparationFree(struct preparation **pEl);
/* Free a single dynamically allocated preparation such as created
 * with preparationLoad(). */

void preparationFreeList(struct preparation **pList);
/* Free a list of dynamically allocated preparation's */

void preparationOutput(struct preparation *el, FILE *f, char sep, char lastSep);
/* Print out preparation.  Separate fields with sep. Follow last field with lastSep. */

#define preparationTabOut(el,f) preparationOutput(el,f,'\t','\n');
/* Print out preparation as a line in a tab-separated file. */

#define preparationCommaOut(el,f) preparationOutput(el,f,',',',');
/* Print out preparation as a comma separated list including final comma. */

#define PROBETYPE_NUM_COLS 2

struct probeType
/* Type of probe - RNA, antibody, etc. */
    {
    struct probeType *next;  /* Next in singly linked list. */
    int id;	/* ID of probe type */
    char *name;	/* Name of probe type */
    };

void probeTypeStaticLoad(char **row, struct probeType *ret);
/* Load a row from probeType table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct probeType *probeTypeLoad(char **row);
/* Load a probeType from row fetched with select * from probeType
 * from database.  Dispose of this with probeTypeFree(). */

struct probeType *probeTypeLoadAll(char *fileName);
/* Load all probeType from whitespace-separated file.
 * Dispose of this with probeTypeFreeList(). */

struct probeType *probeTypeLoadAllByChar(char *fileName, char chopper);
/* Load all probeType from chopper separated file.
 * Dispose of this with probeTypeFreeList(). */

#define probeTypeLoadAllByTab(a) probeTypeLoadAllByChar(a, '\t');
/* Load all probeType from tab separated file.
 * Dispose of this with probeTypeFreeList(). */

struct probeType *probeTypeCommaIn(char **pS, struct probeType *ret);
/* Create a probeType out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new probeType */

void probeTypeFree(struct probeType **pEl);
/* Free a single dynamically allocated probeType such as created
 * with probeTypeLoad(). */

void probeTypeFreeList(struct probeType **pList);
/* Free a list of dynamically allocated probeType's */

void probeTypeOutput(struct probeType *el, FILE *f, char sep, char lastSep);
/* Print out probeType.  Separate fields with sep. Follow last field with lastSep. */

#define probeTypeTabOut(el,f) probeTypeOutput(el,f,'\t','\n');
/* Print out probeType as a line in a tab-separated file. */

#define probeTypeCommaOut(el,f) probeTypeOutput(el,f,',',',');
/* Print out probeType as a comma separated list including final comma. */

#define PROBE_NUM_COLS 8

struct probe
/* Info on a probe */
    {
    struct probe *next;  /* Next in singly linked list. */
    int id;	/* ID of probe */
    int gene;	/* Associated gene, if any */
    int antibody;	/* Associated antibody, if any */
    int probeType;	/* Type of probe - antibody, RNA, etc. */
    char *fPrimer;	/* Forward PCR primer, if any */
    char *rPrimer;	/* Reverse PCR primer, if any */
    char *seq;	/* Associated sequence, if any */
    int bac;	/* Associated BAC if any */
    };

void probeStaticLoad(char **row, struct probe *ret);
/* Load a row from probe table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct probe *probeLoad(char **row);
/* Load a probe from row fetched with select * from probe
 * from database.  Dispose of this with probeFree(). */

struct probe *probeLoadAll(char *fileName);
/* Load all probe from whitespace-separated file.
 * Dispose of this with probeFreeList(). */

struct probe *probeLoadAllByChar(char *fileName, char chopper);
/* Load all probe from chopper separated file.
 * Dispose of this with probeFreeList(). */

#define probeLoadAllByTab(a) probeLoadAllByChar(a, '\t');
/* Load all probe from tab separated file.
 * Dispose of this with probeFreeList(). */

struct probe *probeCommaIn(char **pS, struct probe *ret);
/* Create a probe out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new probe */

void probeFree(struct probe **pEl);
/* Free a single dynamically allocated probe such as created
 * with probeLoad(). */

void probeFreeList(struct probe **pList);
/* Free a list of dynamically allocated probe's */

void probeOutput(struct probe *el, FILE *f, char sep, char lastSep);
/* Print out probe.  Separate fields with sep. Follow last field with lastSep. */

#define probeTabOut(el,f) probeOutput(el,f,'\t','\n');
/* Print out probe as a line in a tab-separated file. */

#define probeCommaOut(el,f) probeOutput(el,f,',',',');
/* Print out probe as a comma separated list including final comma. */

#define PROBECOLOR_NUM_COLS 2

struct probeColor
/* Color - what color probe is in */
    {
    struct probeColor *next;  /* Next in singly linked list. */
    int id;	/* ID of color */
    char *name;	/* Color name */
    };

void probeColorStaticLoad(char **row, struct probeColor *ret);
/* Load a row from probeColor table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct probeColor *probeColorLoad(char **row);
/* Load a probeColor from row fetched with select * from probeColor
 * from database.  Dispose of this with probeColorFree(). */

struct probeColor *probeColorLoadAll(char *fileName);
/* Load all probeColor from whitespace-separated file.
 * Dispose of this with probeColorFreeList(). */

struct probeColor *probeColorLoadAllByChar(char *fileName, char chopper);
/* Load all probeColor from chopper separated file.
 * Dispose of this with probeColorFreeList(). */

#define probeColorLoadAllByTab(a) probeColorLoadAllByChar(a, '\t');
/* Load all probeColor from tab separated file.
 * Dispose of this with probeColorFreeList(). */

struct probeColor *probeColorCommaIn(char **pS, struct probeColor *ret);
/* Create a probeColor out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new probeColor */

void probeColorFree(struct probeColor **pEl);
/* Free a single dynamically allocated probeColor such as created
 * with probeColorLoad(). */

void probeColorFreeList(struct probeColor **pList);
/* Free a list of dynamically allocated probeColor's */

void probeColorOutput(struct probeColor *el, FILE *f, char sep, char lastSep);
/* Print out probeColor.  Separate fields with sep. Follow last field with lastSep. */

#define probeColorTabOut(el,f) probeColorOutput(el,f,'\t','\n');
/* Print out probeColor as a line in a tab-separated file. */

#define probeColorCommaOut(el,f) probeColorOutput(el,f,',',',');
/* Print out probeColor as a comma separated list including final comma. */

#define CAPTION_NUM_COLS 2

struct caption
/* An image caption.  Does not contain tabs or newlines, may have html tags */
    {
    struct caption *next;  /* Next in singly linked list. */
    int id;	/* Caption ID */
    char *caption;	/* Caption text */
    };

void captionStaticLoad(char **row, struct caption *ret);
/* Load a row from caption table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct caption *captionLoad(char **row);
/* Load a caption from row fetched with select * from caption
 * from database.  Dispose of this with captionFree(). */

struct caption *captionLoadAll(char *fileName);
/* Load all caption from whitespace-separated file.
 * Dispose of this with captionFreeList(). */

struct caption *captionLoadAllByChar(char *fileName, char chopper);
/* Load all caption from chopper separated file.
 * Dispose of this with captionFreeList(). */

#define captionLoadAllByTab(a) captionLoadAllByChar(a, '\t');
/* Load all caption from tab separated file.
 * Dispose of this with captionFreeList(). */

struct caption *captionCommaIn(char **pS, struct caption *ret);
/* Create a caption out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new caption */

void captionFree(struct caption **pEl);
/* Free a single dynamically allocated caption such as created
 * with captionLoad(). */

void captionFreeList(struct caption **pList);
/* Free a list of dynamically allocated caption's */

void captionOutput(struct caption *el, FILE *f, char sep, char lastSep);
/* Print out caption.  Separate fields with sep. Follow last field with lastSep. */

#define captionTabOut(el,f) captionOutput(el,f,'\t','\n');
/* Print out caption as a line in a tab-separated file. */

#define captionCommaOut(el,f) captionOutput(el,f,',',',');
/* Print out caption as a comma separated list including final comma. */

#define IMAGEFILE_NUM_COLS 10

struct imageFile
/* A biological image file */
    {
    struct imageFile *next;  /* Next in singly linked list. */
    int id;	/* ID of imageFile */
    char *fileName;	/* Image file name, not including directory */
    float priority;	/* Lower priorities are displayed first */
    int imageWidth;	/* Width of image in pixels */
    int imageHeight;	/* Height of image in pixels */
    int fullLocation;	/* Location of full-sized image */
    int thumbLocation;	/* Location of thumbnail-sized image */
    int submissionSet;	/* Submission set this is part of */
    char *submitId;	/* ID within submission set */
    int caption;	/* Pointer to caption, or 0 for none */
    };

void imageFileStaticLoad(char **row, struct imageFile *ret);
/* Load a row from imageFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct imageFile *imageFileLoad(char **row);
/* Load a imageFile from row fetched with select * from imageFile
 * from database.  Dispose of this with imageFileFree(). */

struct imageFile *imageFileLoadAll(char *fileName);
/* Load all imageFile from whitespace-separated file.
 * Dispose of this with imageFileFreeList(). */

struct imageFile *imageFileLoadAllByChar(char *fileName, char chopper);
/* Load all imageFile from chopper separated file.
 * Dispose of this with imageFileFreeList(). */

#define imageFileLoadAllByTab(a) imageFileLoadAllByChar(a, '\t');
/* Load all imageFile from tab separated file.
 * Dispose of this with imageFileFreeList(). */

struct imageFile *imageFileCommaIn(char **pS, struct imageFile *ret);
/* Create a imageFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new imageFile */

void imageFileFree(struct imageFile **pEl);
/* Free a single dynamically allocated imageFile such as created
 * with imageFileLoad(). */

void imageFileFreeList(struct imageFile **pList);
/* Free a list of dynamically allocated imageFile's */

void imageFileOutput(struct imageFile *el, FILE *f, char sep, char lastSep);
/* Print out imageFile.  Separate fields with sep. Follow last field with lastSep. */

#define imageFileTabOut(el,f) imageFileOutput(el,f,'\t','\n');
/* Print out imageFile as a line in a tab-separated file. */

#define imageFileCommaOut(el,f) imageFileOutput(el,f,',',',');
/* Print out imageFile as a comma separated list including final comma. */

#define IMAGE_NUM_COLS 9

struct image
/* An image.  There may be multiple images within an imageFile */
    {
    struct image *next;  /* Next in singly linked list. */
    int id;	/* ID of image */
    int submissionSet;	/* Submission set this is part of */
    int imageFile;	/* ID of image file */
    int imagePos;	/* Position in image file, starting with 0 */
    char *paneLabel;	/* Label of this pane in image file */
    int sectionSet;	/* Set of sections this is part of, or 0 if none */
    int sectionIx;	/* Position (0-based) within set of sections */
    int specimen;	/* Pointer to info on specimen */
    int preparation;	/* Pointer to info on how specimen prepared */
    };

void imageStaticLoad(char **row, struct image *ret);
/* Load a row from image table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct image *imageLoad(char **row);
/* Load a image from row fetched with select * from image
 * from database.  Dispose of this with imageFree(). */

struct image *imageLoadAll(char *fileName);
/* Load all image from whitespace-separated file.
 * Dispose of this with imageFreeList(). */

struct image *imageLoadAllByChar(char *fileName, char chopper);
/* Load all image from chopper separated file.
 * Dispose of this with imageFreeList(). */

#define imageLoadAllByTab(a) imageLoadAllByChar(a, '\t');
/* Load all image from tab separated file.
 * Dispose of this with imageFreeList(). */

struct image *imageCommaIn(char **pS, struct image *ret);
/* Create a image out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new image */

void imageFree(struct image **pEl);
/* Free a single dynamically allocated image such as created
 * with imageLoad(). */

void imageFreeList(struct image **pList);
/* Free a list of dynamically allocated image's */

void imageOutput(struct image *el, FILE *f, char sep, char lastSep);
/* Print out image.  Separate fields with sep. Follow last field with lastSep. */

#define imageTabOut(el,f) imageOutput(el,f,'\t','\n');
/* Print out image as a line in a tab-separated file. */

#define imageCommaOut(el,f) imageOutput(el,f,',',',');
/* Print out image as a comma separated list including final comma. */

#define IMAGEPROBE_NUM_COLS 4

struct imageProbe
/* Associate probe and image */
    {
    struct imageProbe *next;  /* Next in singly linked list. */
    int id;	/* ID of imageProbe combination */
    int image;	/* ID of image */
    int probe;	/* ID of probe */
    int probeColor;	/* ID of probeColor */
    };

void imageProbeStaticLoad(char **row, struct imageProbe *ret);
/* Load a row from imageProbe table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct imageProbe *imageProbeLoad(char **row);
/* Load a imageProbe from row fetched with select * from imageProbe
 * from database.  Dispose of this with imageProbeFree(). */

struct imageProbe *imageProbeLoadAll(char *fileName);
/* Load all imageProbe from whitespace-separated file.
 * Dispose of this with imageProbeFreeList(). */

struct imageProbe *imageProbeLoadAllByChar(char *fileName, char chopper);
/* Load all imageProbe from chopper separated file.
 * Dispose of this with imageProbeFreeList(). */

#define imageProbeLoadAllByTab(a) imageProbeLoadAllByChar(a, '\t');
/* Load all imageProbe from tab separated file.
 * Dispose of this with imageProbeFreeList(). */

struct imageProbe *imageProbeCommaIn(char **pS, struct imageProbe *ret);
/* Create a imageProbe out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new imageProbe */

void imageProbeFree(struct imageProbe **pEl);
/* Free a single dynamically allocated imageProbe such as created
 * with imageProbeLoad(). */

void imageProbeFreeList(struct imageProbe **pList);
/* Free a list of dynamically allocated imageProbe's */

void imageProbeOutput(struct imageProbe *el, FILE *f, char sep, char lastSep);
/* Print out imageProbe.  Separate fields with sep. Follow last field with lastSep. */

#define imageProbeTabOut(el,f) imageProbeOutput(el,f,'\t','\n');
/* Print out imageProbe as a line in a tab-separated file. */

#define imageProbeCommaOut(el,f) imageProbeOutput(el,f,',',',');
/* Print out imageProbe as a comma separated list including final comma. */

#define EXPRESSIONPATTERN_NUM_COLS 2

struct expressionPattern
/* Things like 'scattered' 'regional' 'widely expressed' */
    {
    struct expressionPattern *next;  /* Next in singly linked list. */
    int id;	/* ID of expression pattern */
    char *description;	/* Short description of pattern */
    };

void expressionPatternStaticLoad(char **row, struct expressionPattern *ret);
/* Load a row from expressionPattern table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct expressionPattern *expressionPatternLoad(char **row);
/* Load a expressionPattern from row fetched with select * from expressionPattern
 * from database.  Dispose of this with expressionPatternFree(). */

struct expressionPattern *expressionPatternLoadAll(char *fileName);
/* Load all expressionPattern from whitespace-separated file.
 * Dispose of this with expressionPatternFreeList(). */

struct expressionPattern *expressionPatternLoadAllByChar(char *fileName, char chopper);
/* Load all expressionPattern from chopper separated file.
 * Dispose of this with expressionPatternFreeList(). */

#define expressionPatternLoadAllByTab(a) expressionPatternLoadAllByChar(a, '\t');
/* Load all expressionPattern from tab separated file.
 * Dispose of this with expressionPatternFreeList(). */

struct expressionPattern *expressionPatternCommaIn(char **pS, struct expressionPattern *ret);
/* Create a expressionPattern out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new expressionPattern */

void expressionPatternFree(struct expressionPattern **pEl);
/* Free a single dynamically allocated expressionPattern such as created
 * with expressionPatternLoad(). */

void expressionPatternFreeList(struct expressionPattern **pList);
/* Free a list of dynamically allocated expressionPattern's */

void expressionPatternOutput(struct expressionPattern *el, FILE *f, char sep, char lastSep);
/* Print out expressionPattern.  Separate fields with sep. Follow last field with lastSep. */

#define expressionPatternTabOut(el,f) expressionPatternOutput(el,f,'\t','\n');
/* Print out expressionPattern as a line in a tab-separated file. */

#define expressionPatternCommaOut(el,f) expressionPatternOutput(el,f,',',',');
/* Print out expressionPattern as a comma separated list including final comma. */

#define EXPRESSIONLEVEL_NUM_COLS 6

struct expressionLevel
/* Annotated expression level if any */
    {
    struct expressionLevel *next;  /* Next in singly linked list. */
    int imageProbe;	/* Image and probe */
    int bodyPart;	/* Location of expression */
    float level;	/* Expression level (0.0 to 1.0) */
    int cellType;	/* Cell type expression seen in */
    int cellSubtype;	/* Cell subtype expression seen in */
    int expressionPattern;	/* Things like scattered, regional, etc. */
    };

void expressionLevelStaticLoad(char **row, struct expressionLevel *ret);
/* Load a row from expressionLevel table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct expressionLevel *expressionLevelLoad(char **row);
/* Load a expressionLevel from row fetched with select * from expressionLevel
 * from database.  Dispose of this with expressionLevelFree(). */

struct expressionLevel *expressionLevelLoadAll(char *fileName);
/* Load all expressionLevel from whitespace-separated file.
 * Dispose of this with expressionLevelFreeList(). */

struct expressionLevel *expressionLevelLoadAllByChar(char *fileName, char chopper);
/* Load all expressionLevel from chopper separated file.
 * Dispose of this with expressionLevelFreeList(). */

#define expressionLevelLoadAllByTab(a) expressionLevelLoadAllByChar(a, '\t');
/* Load all expressionLevel from tab separated file.
 * Dispose of this with expressionLevelFreeList(). */

struct expressionLevel *expressionLevelCommaIn(char **pS, struct expressionLevel *ret);
/* Create a expressionLevel out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new expressionLevel */

void expressionLevelFree(struct expressionLevel **pEl);
/* Free a single dynamically allocated expressionLevel such as created
 * with expressionLevelLoad(). */

void expressionLevelFreeList(struct expressionLevel **pList);
/* Free a list of dynamically allocated expressionLevel's */

void expressionLevelOutput(struct expressionLevel *el, FILE *f, char sep, char lastSep);
/* Print out expressionLevel.  Separate fields with sep. Follow last field with lastSep. */

#define expressionLevelTabOut(el,f) expressionLevelOutput(el,f,'\t','\n');
/* Print out expressionLevel as a line in a tab-separated file. */

#define expressionLevelCommaOut(el,f) expressionLevelOutput(el,f,',',',');
/* Print out expressionLevel as a comma separated list including final comma. */

#define LIFETIME_NUM_COLS 4

struct lifeTime
/* Information of ages critical points in life cycle */
    {
    struct lifeTime *next;  /* Next in singly linked list. */
    int taxon;	/* NCBI taxon */
    float birth;	/* Typical number of days from conception to birth/hatching */
    float adult;	/* Typical number of days from conception to adulthood */
    float death;	/* Typical number of days from conception to death */
    };

void lifeTimeStaticLoad(char **row, struct lifeTime *ret);
/* Load a row from lifeTime table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct lifeTime *lifeTimeLoad(char **row);
/* Load a lifeTime from row fetched with select * from lifeTime
 * from database.  Dispose of this with lifeTimeFree(). */

struct lifeTime *lifeTimeLoadAll(char *fileName);
/* Load all lifeTime from whitespace-separated file.
 * Dispose of this with lifeTimeFreeList(). */

struct lifeTime *lifeTimeLoadAllByChar(char *fileName, char chopper);
/* Load all lifeTime from chopper separated file.
 * Dispose of this with lifeTimeFreeList(). */

#define lifeTimeLoadAllByTab(a) lifeTimeLoadAllByChar(a, '\t');
/* Load all lifeTime from tab separated file.
 * Dispose of this with lifeTimeFreeList(). */

struct lifeTime *lifeTimeCommaIn(char **pS, struct lifeTime *ret);
/* Create a lifeTime out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new lifeTime */

void lifeTimeFree(struct lifeTime **pEl);
/* Free a single dynamically allocated lifeTime such as created
 * with lifeTimeLoad(). */

void lifeTimeFreeList(struct lifeTime **pList);
/* Free a list of dynamically allocated lifeTime's */

void lifeTimeOutput(struct lifeTime *el, FILE *f, char sep, char lastSep);
/* Print out lifeTime.  Separate fields with sep. Follow last field with lastSep. */

#define lifeTimeTabOut(el,f) lifeTimeOutput(el,f,'\t','\n');
/* Print out lifeTime as a line in a tab-separated file. */

#define lifeTimeCommaOut(el,f) lifeTimeOutput(el,f,',',',');
/* Print out lifeTime as a comma separated list including final comma. */

#define LIFESTAGESCHEME_NUM_COLS 3

struct lifeStageScheme
/* List of schemes for developmental stages */
    {
    struct lifeStageScheme *next;  /* Next in singly linked list. */
    int id;	/* ID of scheme */
    int taxon;	/* NCBI taxon */
    char *name;	/* Theiler, or whatever */
    };

void lifeStageSchemeStaticLoad(char **row, struct lifeStageScheme *ret);
/* Load a row from lifeStageScheme table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct lifeStageScheme *lifeStageSchemeLoad(char **row);
/* Load a lifeStageScheme from row fetched with select * from lifeStageScheme
 * from database.  Dispose of this with lifeStageSchemeFree(). */

struct lifeStageScheme *lifeStageSchemeLoadAll(char *fileName);
/* Load all lifeStageScheme from whitespace-separated file.
 * Dispose of this with lifeStageSchemeFreeList(). */

struct lifeStageScheme *lifeStageSchemeLoadAllByChar(char *fileName, char chopper);
/* Load all lifeStageScheme from chopper separated file.
 * Dispose of this with lifeStageSchemeFreeList(). */

#define lifeStageSchemeLoadAllByTab(a) lifeStageSchemeLoadAllByChar(a, '\t');
/* Load all lifeStageScheme from tab separated file.
 * Dispose of this with lifeStageSchemeFreeList(). */

struct lifeStageScheme *lifeStageSchemeCommaIn(char **pS, struct lifeStageScheme *ret);
/* Create a lifeStageScheme out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new lifeStageScheme */

void lifeStageSchemeFree(struct lifeStageScheme **pEl);
/* Free a single dynamically allocated lifeStageScheme such as created
 * with lifeStageSchemeLoad(). */

void lifeStageSchemeFreeList(struct lifeStageScheme **pList);
/* Free a list of dynamically allocated lifeStageScheme's */

void lifeStageSchemeOutput(struct lifeStageScheme *el, FILE *f, char sep, char lastSep);
/* Print out lifeStageScheme.  Separate fields with sep. Follow last field with lastSep. */

#define lifeStageSchemeTabOut(el,f) lifeStageSchemeOutput(el,f,'\t','\n');
/* Print out lifeStageScheme as a line in a tab-separated file. */

#define lifeStageSchemeCommaOut(el,f) lifeStageSchemeOutput(el,f,',',',');
/* Print out lifeStageScheme as a comma separated list including final comma. */

#define LIFESTAGE_NUM_COLS 4

struct lifeStage
/* List of life stages according to a particular scheme */
    {
    struct lifeStage *next;  /* Next in singly linked list. */
    int lifeStageScheme;	/* Which staging scheme this is */
    char *name;	/* Name of this stage */
    float age;	/* Start age of this stage measured in days since conception */
    char *description;	/* Description of stage */
    };

void lifeStageStaticLoad(char **row, struct lifeStage *ret);
/* Load a row from lifeStage table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct lifeStage *lifeStageLoad(char **row);
/* Load a lifeStage from row fetched with select * from lifeStage
 * from database.  Dispose of this with lifeStageFree(). */

struct lifeStage *lifeStageLoadAll(char *fileName);
/* Load all lifeStage from whitespace-separated file.
 * Dispose of this with lifeStageFreeList(). */

struct lifeStage *lifeStageLoadAllByChar(char *fileName, char chopper);
/* Load all lifeStage from chopper separated file.
 * Dispose of this with lifeStageFreeList(). */

#define lifeStageLoadAllByTab(a) lifeStageLoadAllByChar(a, '\t');
/* Load all lifeStage from tab separated file.
 * Dispose of this with lifeStageFreeList(). */

struct lifeStage *lifeStageCommaIn(char **pS, struct lifeStage *ret);
/* Create a lifeStage out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new lifeStage */

void lifeStageFree(struct lifeStage **pEl);
/* Free a single dynamically allocated lifeStage such as created
 * with lifeStageLoad(). */

void lifeStageFreeList(struct lifeStage **pList);
/* Free a list of dynamically allocated lifeStage's */

void lifeStageOutput(struct lifeStage *el, FILE *f, char sep, char lastSep);
/* Print out lifeStage.  Separate fields with sep. Follow last field with lastSep. */

#define lifeStageTabOut(el,f) lifeStageOutput(el,f,'\t','\n');
/* Print out lifeStage as a line in a tab-separated file. */

#define lifeStageCommaOut(el,f) lifeStageOutput(el,f,',',',');
/* Print out lifeStage as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* VISIGENE_H */

