/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.internal.share.email;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IMeta;
import org.xmind.core.ISerializer;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.GEF;
import org.xmind.internal.share.Info;
import org.xmind.internal.share.dialogs.Messages;
import org.xmind.internal.share.email.EmailCreator;
import org.xmind.internal.share.email.FileValidationException;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.mindmap.MindMapExtractor;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.util.TextFormatter;

public class EmailSender {
    private Info info = new Info();

    public void send(Shell parentShell, IMindMapViewer sourceViewer) throws IOException {
        if (parentShell == null || sourceViewer == null) {
            return;
        }
        File attachment = this.generateTempFile(parentShell, sourceViewer);
        if (Util.isWindows()) {
            ArrayList<File> attachments = new ArrayList<File>();
            attachments.add(attachment);
            String emlFilePath = Core.getWorkspace().getTempFile("email/" + FileUtils.getNoExtensionFileName((String)((File)attachments.get(0)).getAbsolutePath()) + ".eml");
            EmailCreator.createEmlFile(null, null, null, null, attachments, emlFilePath);
            Program.launch((String)emlFilePath);
        } else {
            String path = attachment.getAbsolutePath();
            Program program = Program.findProgram((String)".eml");
            if (program == null) {
                MessageDialog.openWarning((Shell)parentShell, (String)Messages.EmailSender_noClient_dialog_title, (String)Messages.EmailSender_noClient_dialog_message);
            } else {
                program.execute(path);
            }
        }
    }

    private File generateTempFile(Shell parentShell, IMindMapViewer sourceViewer) throws IOException {
        MindMapExtractor extractor = new MindMapExtractor(sourceViewer);
        IWorkbook workbook = extractor.extract();
        this.generatePreview(workbook, !Util.isLinux() ? parentShell.getDisplay() : Display.getDefault());
        this.info.setProperty("Workbook", workbook);
        this.info.setProperty("Title", this.getDefaultMapTitle(workbook));
        this.info.setProperty("Thumbnail/BackgroundColor", this.getBackgroundColor(sourceViewer));
        int x = this.info.getInt("Thumbnail/X", 0);
        int y = this.info.getInt("Thumbnail/Y", 0);
        double scale = this.info.getDouble("Thumbnail/Scale", 1.0);
        IMeta meta = workbook.getMeta();
        meta.setValue("Thumbnail/X", String.valueOf(x));
        meta.setValue("Thumbnail/Y", String.valueOf(y));
        meta.setValue("Thumbnail/Scale", String.valueOf(scale /= 2.0));
        meta.setValue("Thumbnail/Origin/X", String.valueOf(this.info.getInt("Thumbnail/Origin/X", 0)));
        meta.setValue("Thumbnail/Origin/Y", String.valueOf(this.info.getInt("Thumbnail/Origin/Y", 0)));
        meta.setValue("Thumbnail/BackgroundColor", this.info.getString("Thumbnail/BackgroundColor"));
        String title = (String)this.info.getProperty("Title");
        String tempFile = Core.getWorkspace().getTempFile("email/" + MindMapUtils.trimFileName((String)title) + ".xmind");
        File file = new File(tempFile);
        if (file.exists()) {
            file.delete();
        }
        try {
            ISerializer serializer = Core.getWorkbookBuilder().newSerializer();
            serializer.setWorkbook(workbook);
            FileOutputStream output = new FileOutputStream(file);
            try {
                serializer.setOutputStream((OutputStream)output);
                serializer.serialize(null);
            }
            finally {
                ((OutputStream)output).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        String path = file.getAbsolutePath();
        EmailSender.validateFile(path);
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        return file;
    }

    private void generatePreview(IWorkbook workbook, Display display) {
        MindMapImageExporter exporter = new MindMapImageExporter(display);
        exporter.setSource((Object)new MindMap(workbook.getPrimarySheet()), null, null);
        exporter.setTargetWorkbook(workbook);
        Image previewImage = exporter.createImage();
        exporter.export(previewImage);
        Point origin = exporter.calcRelativeOrigin();
        if (previewImage == null || origin == null) {
            throw new RuntimeException("Failed to generate thumbnail.");
        }
        this.info.setProperty("FullImage", previewImage);
        this.info.setInt("Thumbnail/Origin/X", origin.x);
        this.info.setInt("Thumbnail/Origin/Y", origin.y);
    }

    private String getDefaultMapTitle(IWorkbook workbook) {
        if (workbook != null) {
            return TextFormatter.removeNewLineCharacter((String)(workbook.getPrimarySheet().getRootTopic() != null ? workbook.getPrimarySheet().getRootTopic().getTitleText() : ""));
        }
        return null;
    }

    private String getBackgroundColor(IMindMapViewer sourceViewer) {
        Color color;
        Layer layer = sourceViewer.getLayer(GEF.LAYER_BACKGROUND);
        if (layer != null && (color = layer.getBackgroundColor()) != null) {
            return ColorUtils.toString((Color)color);
        }
        return "#ffffff";
    }

    private static void validateFile(String path) {
        HashSet<String> entries = new HashSet<String>();
        try {
            ZipInputStream zin = new ZipInputStream(new FileInputStream(path));
            try {
                ZipEntry e;
                while ((e = zin.getNextEntry()) != null) {
                    String name = e.getName();
                    entries.add(name);
                }
            }
            finally {
                zin.close();
            }
        }
        catch (Throwable e) {
            throw new FileValidationException("File Validation Failed: " + e.getLocalizedMessage(), e);
        }
        if (!entries.contains("Thumbnails/thumbnail.png")) {
            throw new FileValidationException("File Validation Failed: missing entry 'Thumbnails/thumbnail.png'");
        }
    }
}

