/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.core.internal;

import org.json.JSONObject;
import org.xmind.core.net.http.HttpException;
import org.xmind.core.net.http.HttpRequest;

public class API {
    public static final int DEFAULT_PORT = -1;
    public static final int DEFAULT_TOKEN_LIFE_TIME = 604800;
    public static final String KEY_INTERNAL_CODE = "_code";
    public static final String HEADER_AUTH_TOKEN = "AuthToken";
    public static final String PARAM_USER = "user";
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_PWD = "pwd";

    public static Result toResult(HttpRequest request) {
        int statusCode;
        int code = statusCode = request.getStatusCode();
        JSONObject data = request.getResponseAsJSON();
        if (statusCode == 200 && data != null && data.has(KEY_INTERNAL_CODE)) {
            code = data.getInt(KEY_INTERNAL_CODE);
            data.remove(KEY_INTERNAL_CODE);
        }
        if (data == null) {
            data = new JSONObject();
        }
        return new Result(code, data);
    }

    public static Result toCheckedResult(HttpRequest request) throws HttpException {
        Result result = API.toResult(request);
        if (result.getCode() != 200) {
            throw new HttpException(request, result.getCode(), "Unexpected Error", null);
        }
        return result;
    }

    static class Result {
        private int code;
        private JSONObject data;

        private Result(int code, JSONObject data) {
            this.code = code;
            this.data = data;
        }

        public int getCode() {
            return this.code;
        }

        public JSONObject getData() {
            return this.data;
        }
    }
}

