/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.audio.mp3player;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import org.xmind.core.audio.AudioValues;
import org.xmind.core.audio.IAudioDevice;
import org.xmind.core.audio.IAudioSource;
import org.xmind.core.audio.IAudioTarget;
import org.xmind.core.audio.device.AudioChannelBase;
import org.xmind.core.audio.internal.device.AudioUtils;
import org.xmind.core.audio.mp3player.Mp3PlayerPlugin;

public class JLayerMp3PlaybackChannel
extends AudioChannelBase {
    private static final boolean DEBUG = false;
    public static final int BITS_PER_SAMPLE = 16;
    private volatile Bitstream input;
    private int sourceSize;
    private long duration;
    private volatile long currentCount;
    private volatile Decoder decoder;
    private Header firstFrame = null;
    private SourceDataLine output = null;
    private Thread playbackThread = null;
    private Thread monitorThread = null;
    private boolean finished = false;
    private byte[] buffer = new byte[4096];
    private long startTime = 0L;
    private AudioFormat format;
    private float msPerFrame;

    public JLayerMp3PlaybackChannel(IAudioDevice device, IAudioSource source, IAudioTarget target) throws Exception {
        super(device, source, target);
        this.open();
    }

    private void open() throws JavaLayerException, IOException, LineUnavailableException, UnsupportedAudioFileException {
        this.sourceSize = (int)this.getSource().getSize();
        this.input = new Bitstream(this.getSource().openInputStream());
        this.decoder = new Decoder();
        int headerPos = this.input.header_pos();
        this.firstFrame = this.input.readFrame();
        if (this.firstFrame == null) {
            throw new IllegalArgumentException("Empty MP3 file.");
        }
        int sampleRate = this.firstFrame.frequency();
        int mode = this.firstFrame.mode();
        int channels = mode == 3 ? 1 : 2;
        int contentLength = headerPos > 0 && headerPos < this.sourceSize ? this.sourceSize - headerPos : this.sourceSize;
        this.msPerFrame = this.firstFrame.ms_per_frame();
        this.duration = Math.round(this.firstFrame.total_ms(contentLength));
        this.format = new AudioFormat(sampleRate, 16, channels, true, true);
        this.openOutput();
        this.startTime = System.currentTimeMillis();
        this.startPlay();
    }

    private void openOutput() throws LineUnavailableException {
        this.output = AudioSystem.getSourceDataLine(this.format);
        try {
            this.output.open(this.format);
        }
        catch (LineUnavailableException e) {
            try {
                this.output.close();
            }
            catch (Throwable throwable) {}
            throw e;
        }
        this.output.start();
    }

    private void startPlay() {
        String threadName = "MP3 Playback" + System.currentTimeMillis();
        this.playbackThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (JLayerMp3PlaybackChannel.this.input == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
                Class<?> clazz = JLayerMp3PlaybackChannel.this.input.getClass();
                synchronized (clazz) {
                    JLayerMp3PlaybackChannel.this.runPlayback(JLayerMp3PlaybackChannel.this.input);
                }
            }
        }, threadName);
        this.playbackThread.setDaemon(true);
        this.playbackThread.start();
        this.monitorThread = new Thread(new Runnable(){

            public void run() {
                JLayerMp3PlaybackChannel.this.runMonitor();
            }
        }, "MP3 Playback Monitor");
        this.monitorThread.setDaemon(true);
        this.monitorThread.start();
    }

    public boolean isRunning() {
        return super.isRunning() && !this.finished;
    }

    private void runPlayback(Bitstream input) {
        SourceDataLine line;
        try {
            while (this.isRunning()) {
                this.playNextFrame(input);
                Thread.sleep(0L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable e) {
            Mp3PlayerPlugin.log(e, "Failed to play mp3 file.");
        }
        if (this.isRunning() && !this.isJumping() && (line = this.output) != null && line.isOpen()) {
            line.drain();
            if (this.isRunning() && !this.isJumping() && line.isOpen()) {
                line.stop();
            }
        }
        if (this.isRunning() && !this.isJumping()) {
            try {
                this.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void playNextFrame(Bitstream input) throws Exception {
        if (!this.isRunning()) {
            return;
        }
        Header frame = this.readNextFrame(input);
        if (frame == null) {
            throw new InterruptedException("Stream has ended.");
        }
        if (!this.isRunning()) {
            return;
        }
        SampleBuffer buffer = (SampleBuffer)this.decoder.decodeFrame(frame, input);
        if (!this.isRunning()) {
            return;
        }
        this.write(buffer.getBuffer(), 0, buffer.getBufferLength());
        if (!this.isRunning()) {
            return;
        }
        input.closeFrame();
    }

    private Header readNextFrame(Bitstream input) throws BitstreamException {
        Header frame = null;
        if (this.firstFrame != null) {
            frame = this.firstFrame;
            this.firstFrame = null;
        }
        frame = input.readFrame();
        ++this.currentCount;
        return frame;
    }

    private void write(short[] samples, int offset, int length) {
        byte[] data = this.toBytes(samples, offset, length);
        if (!this.isRunning()) {
            return;
        }
        SourceDataLine line = this.output;
        if (line != null && line.isOpen()) {
            line.write(data, offset, length + length);
        }
    }

    private void runMonitor() {
        try {
            while (this.isRunning()) {
                AudioValues values = this.createAudioValues();
                if (values != null) {
                    this.fireValueChanged(values);
                    Thread.sleep(50L);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException values) {
        }
        catch (Throwable e) {
            Mp3PlayerPlugin.log(e, "Failed to monitor mp3 playback.");
        }
    }

    private AudioValues createAudioValues() {
        float level;
        long position;
        boolean running;
        SourceDataLine line = this.output;
        boolean bl = running = line != null && line.isOpen() && line.isRunning();
        if (!running && System.currentTimeMillis() - this.startTime > this.duration) {
            return null;
        }
        if (running) {
            position = (long)((float)this.currentCount * this.msPerFrame);
            level = line.getLevel();
        } else {
            position = 0L;
            level = 0.0f;
        }
        AudioValues values = new AudioValues();
        values.time = position;
        values.level = AudioUtils.ampToLevel((double)(level * 32767.0f));
        values.duration = this.duration;
        values.fileSize = this.sourceSize;
        return values;
    }

    private byte[] toBytes(short[] samples, int offset, int length) {
        byte[] b = this.getByteArray(length + length);
        int idx = 0;
        while (length-- > 0) {
            short s = samples[offset++];
            b[idx++] = (byte)(s >>> 8);
            b[idx++] = (byte)s;
        }
        return b;
    }

    private byte[] getByteArray(int length) {
        if (this.buffer.length < length) {
            this.buffer = new byte[length + 1024];
        }
        return this.buffer;
    }

    public void close() throws Exception {
        if (this.isJumping()) {
            return;
        }
        boolean shouldFireStop = !this.finished;
        Thread playback = this.playbackThread;
        Thread monitor = this.monitorThread;
        SourceDataLine line = this.output;
        Bitstream bitstream = this.input;
        this.finished = true;
        this.playbackThread = null;
        this.monitorThread = null;
        this.output = null;
        this.input = null;
        if (line != null && line.isOpen()) {
            try {
                line.close();
            }
            catch (Throwable e) {
                Mp3PlayerPlugin.log(e, "Failed to close SourceDataLine used for mp3 playback.");
            }
        }
        if (bitstream != null) {
            try {
                bitstream.close();
            }
            catch (Throwable e) {
                Mp3PlayerPlugin.log(e, "Failed to close mp3 bitstream.");
            }
        }
        if (playback != null) {
            playback.interrupt();
        }
        if (monitor != null) {
            monitor.interrupt();
        }
        super.close();
        if (shouldFireStop) {
            this.fireStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jumpTo(double rate) {
        try {
            if (rate >= 0.99) {
                this.close();
                return;
            }
        }
        catch (JavaLayerException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setJumping();
        long time = (long)((double)this.duration * rate);
        Bitstream jumpInput = null;
        try {
            jumpInput = new Bitstream(this.getSource().openInputStream());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (jumpInput == null) {
            return;
        }
        Decoder jumpDecoder = new Decoder();
        Header header = null;
        try {
            header = jumpInput.readFrame();
        }
        catch (BitstreamException e1) {
            e1.printStackTrace();
        }
        if (header == null) {
            return;
        }
        long count = (long)((float)time / header.ms_per_frame());
        int i = 0;
        while ((long)i < count - 1L) {
            try {
                jumpInput.closeFrame();
                header = jumpInput.readFrame();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        try {
            if (this.input != null) {
                try {
                    this.input.close();
                }
                catch (Throwable e) {
                    Mp3PlayerPlugin.log(e, "Failed to close mp3 bitstream.");
                }
            }
            if (this.playbackThread != null) {
                this.playbackThread.interrupt();
            }
            if (this.output != null) {
                this.output.flush();
            }
            if (this.monitorThread != null) {
                this.monitorThread.interrupt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.finished = false;
        Class<?> e = this.input.getClass();
        synchronized (e) {
            this.input = jumpInput;
            this.decoder = jumpDecoder;
            this.currentCount = count;
        }
        this.startPlay();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        AudioValues values = this.createAudioValues();
        this.fireValueChanged(values);
        this.jumpFinished();
    }
}

