/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.css;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionSupport<T> {
    private Class<?> type;

    public ReflectionSupport(Class<T> type) {
        this.type = type;
    }

    public Object getFieldValue(Field field, T instance) {
        Object value = null;
        if (field != null) {
            boolean accessible = field.isAccessible();
            try {
                try {
                    field.setAccessible(true);
                    value = field.get(instance);
                }
                catch (Exception exception) {
                    field.setAccessible(accessible);
                }
            }
            finally {
                field.setAccessible(accessible);
            }
        }
        return value;
    }

    public Object getFieldValue(String name, T instance) {
        Field field = this.getField(name);
        return this.getFieldValue(field, instance);
    }

    public Field getField(String name) {
        while (!this.type.equals(Object.class)) {
            try {
                return this.type.getDeclaredField(name);
            }
            catch (Exception exception) {
                this.type = this.type.getSuperclass();
            }
        }
        return null;
    }

    public Object set(Object obj, String name, Object value) {
        try {
            Field field = this.getField(name);
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            field.set(obj, value);
            field.setAccessible(accessible);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object executeMethod(Method method, T instance, Object ... params) {
        Object value = null;
        if (method != null) {
            boolean accessible = method.isAccessible();
            try {
                try {
                    method.setAccessible(true);
                    value = method.invoke(instance, params);
                }
                catch (Exception exception) {
                    method.setAccessible(accessible);
                }
            }
            finally {
                method.setAccessible(accessible);
            }
        }
        return value;
    }

    public Method getMethod(String name, Class<?> ... params) {
        while (!this.type.equals(Object.class)) {
            try {
                return this.type.getDeclaredMethod(name, params);
            }
            catch (Exception exception) {
                this.type = this.type.getSuperclass();
            }
        }
        return null;
    }
}

