/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.xpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmind.core.internal.xpath.IAxisProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Evaluator {
    private static final List<Object> EMPTY_SEQUENCE = Collections.emptyList();
    private static final String AXIS_ATTRIBUTE = "attribute";
    private static final String AXIS_CHILD = "child";
    private static final String AXIS_SELF = "self";
    private static final String AXIS_PARENT = "parent";
    private static final String KIND_TEXT = "text";
    private static final String KIND_NODE = "node";
    private static final Set<String> KINDS = new HashSet<String>(Arrays.asList("text", "node"));
    private static final String TOKEN_SINGLE_SLASH = "/";
    private static final String TOKEN_PREDICATE_START = "[";
    private static final String TOKEN_PREDICATE_END = "]";
    private static final String TOKEN_SELF = ".";
    private static final String TOKEN_PARENT = "..";
    private static final String TOKEN_PAREN_START = "(";
    private static final String TOKEN_PAREN_END = ")";
    private static final String TOKEN_ARGUMENT_SEPARATOR = ",";
    private static final String TOKEN_AXIS_SEPARATOR = "::";
    private static final String TOKEN_AXIS_ATTRIBUTE = "@";
    private static final Pattern RE_LEXER = Pattern.compile("\\$?(?:(?![0-9-])(?:[\\w-]+|\\*):)?(?![0-9-])(?:[\\w-]+|\\*)|\\(:|:\\)|\\/\\/|\\.\\.|::|\\d+(?:\\.\\d*)?(?:[eE][+-]?\\d+)?|\\.\\d+(?:[eE][+-]?\\d+)?|\"[^\"]*(?:\"\"[^\"]*)*\"|'[^']*(?:''[^']*)*'|<<|>>|[!<>]=|(?![0-9-])[\\w-]+:\\*|\\s+|.");
    private static final Pattern RE_SPACE = Pattern.compile("^\\s+$");
    private static final Pattern RE_NAME = Pattern.compile("^(?:(?![0-9-])([\\w-]+|\\*)\\:)?(?![0-9-])([\\w-]+|\\*)$");
    private static final Pattern RE_INTEGER = Pattern.compile("^\\d+$");
    private static final Pattern RE_DOUBLE = Pattern.compile("^\\d*\\.\\d+$");
    private static final Pattern RE_STRING = Pattern.compile("^'([^']*(?:''[^']*)*)'|\"([^\"]*(?:\"\"[^\"]*)*)\"$");
    private static final Expression NULL = new Expression(){

        @Override
        public List<Object> evaluate(EvaluationContext context) {
            return EMPTY_SEQUENCE;
        }

        public String toString() {
            return "null";
        }
    };
    private static final FunctionArgument NULL_ARGUMENT = new FunctionArgument(EMPTY_SEQUENCE);
    private static Map<String, Function> FUNCTIONS = new HashMap<String, Function>();
    private static final Map<String, String> OPERATORS;
    private String expressionText;
    private Expression expression;
    private IAxisProvider axisProvider;

    static {
        FUNCTIONS.put("true", new Function(){

            public Object call(EvaluationContext context, FunctionArgumentList args) {
                return Boolean.TRUE;
            }
        });
        FUNCTIONS.put("false", new Function(){

            public Object call(EvaluationContext context, FunctionArgumentList args) {
                return Boolean.FALSE;
            }
        });
        FUNCTIONS.put("position", new Function(){

            public Object call(EvaluationContext context, FunctionArgumentList args) {
                return context.position;
            }
        });
        FUNCTIONS.put("count", new Function(){

            public Object call(EvaluationContext context, FunctionArgumentList args) {
                return args.sequenceAt(0).size();
            }
        });
        FUNCTIONS.put("matches", new Function(){

            public Object call(EvaluationContext context, FunctionArgumentList args) {
                Object text = args.itemAt(0);
                Object regex = args.itemAt(1);
                if (text == null || !(text instanceof String) || regex == null || !(regex instanceof String)) {
                    return Boolean.FALSE;
                }
                return Pattern.matches((String)regex, (String)text);
            }
        });
        FUNCTIONS.put("eq", new Function(){

            public Object call(EvaluationContext context, FunctionArgumentList args) {
                Object op2;
                Object op1 = args.itemAt(0);
                if (!(op1 == (op2 = args.itemAt(1)) || op1 != null && op1.equals(op2))) {
                    return false;
                }
                return true;
            }
        });
        FUNCTIONS.put("ne", new Function(){

            public Object call(EvaluationContext context, FunctionArgumentList args) {
                Object op2;
                Object op1 = args.itemAt(0);
                if (!(op1 == (op2 = args.itemAt(1)) || op1 != null && op1.equals(op2))) {
                    return true;
                }
                return false;
            }
        });
        FUNCTIONS.put("lt", new Function(){

            public Object call(EvaluationContext context, FunctionArgumentList args) {
                Object op1 = args.itemAt(0);
                Object op2 = args.itemAt(1);
                if (!(op1 instanceof Integer) && !(op1 instanceof Double) || !(op2 instanceof Integer) && !(op2 instanceof Double)) {
                    return false;
                }
                Number n1 = (Number)op1;
                Number n2 = (Number)op2;
                if (op1 instanceof Double || op2 instanceof Double) {
                    if (n1.doubleValue() < n2.doubleValue()) {
                        return true;
                    }
                    return false;
                }
                if (n1.intValue() < n2.intValue()) {
                    return true;
                }
                return false;
            }
        });
        FUNCTIONS.put("gt", new Function(){

            public Object call(EvaluationContext context, FunctionArgumentList args) {
                Object op1 = args.itemAt(0);
                Object op2 = args.itemAt(1);
                if (!(op1 instanceof Integer) && !(op1 instanceof Double) || !(op2 instanceof Integer) && !(op2 instanceof Double)) {
                    return false;
                }
                Number n1 = (Number)op1;
                Number n2 = (Number)op2;
                if (op1 instanceof Double || op2 instanceof Double) {
                    if (n1.doubleValue() > n2.doubleValue()) {
                        return true;
                    }
                    return false;
                }
                if (n1.intValue() > n2.intValue()) {
                    return true;
                }
                return false;
            }
        });
        FUNCTIONS.put("lte", new Function(){

            public Object call(EvaluationContext context, FunctionArgumentList args) {
                Object op1 = args.itemAt(0);
                Object op2 = args.itemAt(1);
                if (!(op1 instanceof Integer) && !(op1 instanceof Double) || !(op2 instanceof Integer) && !(op2 instanceof Double)) {
                    return false;
                }
                Number n1 = (Number)op1;
                Number n2 = (Number)op2;
                if (op1 instanceof Double || op2 instanceof Double) {
                    if (n1.doubleValue() <= n2.doubleValue()) {
                        return true;
                    }
                    return false;
                }
                if (n1.intValue() <= n2.intValue()) {
                    return true;
                }
                return false;
            }
        });
        FUNCTIONS.put("gte", new Function(){

            public Object call(EvaluationContext context, FunctionArgumentList args) {
                Object op1 = args.itemAt(0);
                Object op2 = args.itemAt(1);
                if (!(op1 instanceof Integer) && !(op1 instanceof Double) || !(op2 instanceof Integer) && !(op2 instanceof Double)) {
                    return false;
                }
                Number n1 = (Number)op1;
                Number n2 = (Number)op2;
                if (op1 instanceof Double || op2 instanceof Double) {
                    if (n1.doubleValue() >= n2.doubleValue()) {
                        return true;
                    }
                    return false;
                }
                if (n1.intValue() >= n2.intValue()) {
                    return true;
                }
                return false;
            }
        });
        OPERATORS = new HashMap<String, String>();
        OPERATORS.put("=", "eq");
        OPERATORS.put("!=", "ne");
        OPERATORS.put("<", "lt");
        OPERATORS.put(">", "gt");
        OPERATORS.put("<=", "lte");
        OPERATORS.put(">=", "gte");
    }

    public Evaluator(String expression) {
        this(expression, null);
    }

    public Evaluator(String expression, IAxisProvider axisProvider) {
        this.expressionText = expression;
        this.axisProvider = axisProvider;
        this.expression = null;
    }

    public IAxisProvider getAxisProvider() {
        return this.axisProvider;
    }

    public void setAxisProvider(IAxisProvider axisProvider) {
        this.axisProvider = axisProvider;
    }

    public String toString() {
        return this.expression.toString();
    }

    public List<Object> evaluate(Object context) {
        if (this.expression == null) {
            this.expression = new ExpressionParser(this.expressionText).parse();
        }
        EvaluationContext ctx = new EvaluationContext(this, context);
        return this.expression.evaluate(ctx);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AxisExpression
    extends Expression {
        public String axis;
        public String nameToTest;
        public String kindToTest;

        public AxisExpression(String axis, String nameToTest, String kindToTest) {
            this.axis = axis;
            this.nameToTest = nameToTest;
            this.kindToTest = kindToTest;
        }

        @Override
        public List<Object> evaluate(EvaluationContext context) {
            ArrayList<Object> sequence = new ArrayList<Object>();
            IAxisProvider axisProvider = context.staticContext.getAxisProvider();
            if (axisProvider == null) {
                return sequence;
            }
            Object item = context.item;
            if (Evaluator.AXIS_ATTRIBUTE.equals(this.axis)) {
                if (this.nameToTest != null) {
                    sequence.add(axisProvider.getAttribute(item, this.nameToTest));
                }
            } else if (Evaluator.AXIS_CHILD.equals(this.axis)) {
                if (this.nameToTest != null) {
                    sequence.addAll(axisProvider.getChildNodes(item, this.nameToTest));
                }
            } else if (Evaluator.AXIS_PARENT.equals(this.axis)) {
                if (Evaluator.KIND_NODE.equals(this.kindToTest)) {
                    sequence.add(axisProvider.getParentNode(item));
                }
            } else if (Evaluator.AXIS_SELF.equals(this.axis)) {
                if (Evaluator.KIND_TEXT.equals(this.kindToTest)) {
                    sequence.add(axisProvider.getTextContent(item));
                } else if (Evaluator.KIND_NODE.equals(this.kindToTest)) {
                    sequence.add(item);
                }
            }
            return sequence;
        }

        public String toString() {
            return String.format("%s::%s", this.axis, this.nameToTest != null ? this.nameToTest : String.valueOf(this.kindToTest) + "()");
        }
    }

    private static class EvaluationContext {
        public Evaluator staticContext;
        public Object item;
        public int position;
        public int size;

        public EvaluationContext(Evaluator staticContext, Object item) {
            this.staticContext = staticContext;
            this.item = item;
            this.position = 0;
            this.size = 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Expression {
        private List<Expression> arguments = new ArrayList<Expression>();

        protected Expression() {
        }

        protected void addArgument(Expression argument) {
            this.arguments.add(argument);
        }

        protected Expression getArgument(int index, Expression defaultArg) {
            return index < this.arguments.size() ? this.arguments.get(index) : defaultArg;
        }

        protected List<Expression> getArguments() {
            return this.arguments;
        }

        public abstract List<Object> evaluate(EvaluationContext var1);
    }

    private static class ExpressionParser {
        private String[] tokens;
        private int tokenIndex;

        public ExpressionParser(String expression) {
            ArrayList<String> tokens = new ArrayList<String>();
            Matcher matcher = RE_LEXER.matcher(expression);
            while (matcher.find()) {
                String token = matcher.group();
                if (RE_SPACE.matcher(token).matches()) continue;
                tokens.add(token);
            }
            this.tokens = tokens.toArray(new String[tokens.size()]);
            this.tokenIndex = 0;
        }

        public Expression parse() {
            return this.parseExpression();
        }

        private String token() {
            return this.token(0);
        }

        private String token(int offset) {
            int index = this.tokenIndex + offset;
            return index < this.tokens.length ? this.tokens[index] : null;
        }

        private boolean nextToken() {
            return this.nextToken(1);
        }

        private boolean nextToken(int offset) {
            this.tokenIndex += Math.max(offset, 1);
            return this.tokenIndex < this.tokens.length;
        }

        private boolean hasToken() {
            return this.tokenIndex < this.tokens.length;
        }

        private Expression parseExpression() {
            return this.parseSingleExpression();
        }

        private Expression parseSingleExpression() {
            return this.parseOrExpression();
        }

        private Expression parseOrExpression() {
            return this.parseAndExpression();
        }

        private Expression parseAndExpression() {
            return this.parseComparisonExpression();
        }

        private Expression parseComparisonExpression() {
            if (!this.hasToken()) {
                return NULL;
            }
            Expression arg1 = null;
            if (this.hasToken()) {
                arg1 = this.parseRangeExpression();
            }
            if (!this.hasToken()) {
                return arg1;
            }
            String funcName = (String)OPERATORS.get(this.token());
            if (funcName == null) {
                return arg1;
            }
            this.nextToken();
            Expression arg2 = this.parseRangeExpression();
            FunctionCall func = new FunctionCall(funcName);
            func.addArgument(arg1);
            func.addArgument(arg2);
            return func;
        }

        private Expression parseRangeExpression() {
            return this.parseAdditiveExpression();
        }

        private Expression parseAdditiveExpression() {
            return this.parseMultiplicativeExpression();
        }

        private Expression parseMultiplicativeExpression() {
            return this.parseUnionExpression();
        }

        private Expression parseUnionExpression() {
            return this.parseIntersectExceptExpression();
        }

        private Expression parseIntersectExceptExpression() {
            return this.parseInstanceofExpression();
        }

        private Expression parseInstanceofExpression() {
            return this.parseTreatExpression();
        }

        private Expression parseTreatExpression() {
            return this.parseCastableExpression();
        }

        private Expression parseCastableExpression() {
            return this.parseCastExpression();
        }

        private Expression parseCastExpression() {
            return this.parseUnaryExpression();
        }

        private Expression parseUnaryExpression() {
            return this.parseValueExpression();
        }

        private Expression parseValueExpression() {
            return this.parsePathExpression();
        }

        private Expression parsePathExpression() {
            Expression step;
            if (!this.hasToken()) {
                return NULL;
            }
            PathExpression path = new PathExpression();
            if (Evaluator.TOKEN_SINGLE_SLASH.equals(this.token())) {
                this.nextToken();
            }
            while ((step = this.parseStepExpression()) != NULL) {
                path.addArgument(step);
                if (!Evaluator.TOKEN_SINGLE_SLASH.equals(this.token())) break;
                this.nextToken();
            }
            if (path.getArguments().size() == 1) {
                return path.getArgument(0, NULL);
            }
            return path;
        }

        private Expression parseStepExpression() {
            return this.parseFilterExpression();
        }

        private Expression parseFilterExpression() {
            if (!this.hasToken()) {
                return NULL;
            }
            Expression exp = this.parsePrimaryExpression();
            if (exp == NULL) {
                return NULL;
            }
            FilterExpression filter = new FilterExpression(exp);
            while (Evaluator.TOKEN_PREDICATE_START.equals(this.token())) {
                this.nextToken();
                Expression predicate = this.parseExpression();
                if (predicate != NULL) {
                    filter.addArgument(predicate);
                }
                if (!Evaluator.TOKEN_PREDICATE_END.equals(this.token())) continue;
                this.nextToken();
            }
            if (filter.getArguments().isEmpty()) {
                return exp;
            }
            return filter;
        }

        private Expression parsePrimaryExpression() {
            if (!this.hasToken()) {
                return NULL;
            }
            String token = this.token();
            if (Evaluator.TOKEN_PARENT.equals(token)) {
                this.nextToken();
                return new AxisExpression(Evaluator.AXIS_PARENT, null, Evaluator.KIND_NODE);
            }
            if (Evaluator.TOKEN_SELF.equals(token)) {
                this.nextToken();
                return new AxisExpression(Evaluator.AXIS_SELF, null, Evaluator.KIND_NODE);
            }
            Expression exp = this.parseParenthesizedExpression();
            if (exp != NULL) {
                return exp;
            }
            exp = this.parseFunctionCall();
            if (exp != NULL) {
                return exp;
            }
            exp = this.parseVarRef();
            if (exp != NULL) {
                return exp;
            }
            exp = this.parseLiteral();
            if (exp != NULL) {
                return exp;
            }
            exp = this.parseAxisExpression();
            if (exp != NULL) {
                return exp;
            }
            return NULL;
        }

        private Expression parseParenthesizedExpression() {
            Expression exp = NULL;
            if (Evaluator.TOKEN_PAREN_START.equals(this.token())) {
                this.nextToken();
                if (!Evaluator.TOKEN_PAREN_END.equals(this.token())) {
                    exp = this.parseExpression();
                }
                if (Evaluator.TOKEN_PAREN_END.equals(this.token())) {
                    this.nextToken();
                }
            }
            return exp;
        }

        private Expression parseFunctionCall() {
            if (!this.hasToken()) {
                return NULL;
            }
            Matcher nameMatch = RE_NAME.matcher(this.token());
            if (nameMatch.matches() && Evaluator.TOKEN_PAREN_START.equals(this.token(1))) {
                String namespace = nameMatch.group(1);
                String funcName = nameMatch.group(2);
                if (namespace == null && KINDS.contains(funcName)) {
                    return this.parseAxisExpression();
                }
                FunctionCall functionCall = new FunctionCall(funcName);
                this.nextToken(2);
                if (!Evaluator.TOKEN_PAREN_END.equals(this.token())) {
                    do {
                        Expression exp = this.parseSingleExpression();
                        functionCall.addArgument(exp);
                    } while (Evaluator.TOKEN_ARGUMENT_SEPARATOR.equals(this.token()) && this.nextToken());
                }
                if (Evaluator.TOKEN_PAREN_END.equals(this.token())) {
                    this.nextToken();
                }
                return functionCall;
            }
            return NULL;
        }

        private Expression parseVarRef() {
            return NULL;
        }

        private Expression parseLiteral() {
            if (!this.hasToken()) {
                return NULL;
            }
            String token = this.token();
            if (RE_INTEGER.matcher(token).matches()) {
                this.nextToken();
                return new Literal(Integer.parseInt(token, 10));
            }
            if (RE_DOUBLE.matcher(token).matches()) {
                this.nextToken();
                return new Literal(Double.parseDouble(token));
            }
            Matcher m = RE_STRING.matcher(token);
            if (m.matches()) {
                this.nextToken();
                String string = m.group(1) != null ? m.group(1).replace("''", "'") : (m.group(2) != null ? m.group(2).replace("\"\"", "\"") : "");
                return new Literal(string);
            }
            return NULL;
        }

        private Expression parseAxisExpression() {
            if (!this.hasToken()) {
                return NULL;
            }
            String axis = this.token();
            if (Evaluator.TOKEN_AXIS_SEPARATOR.equals(this.token(1))) {
                this.nextToken(2);
                String toTest = this.token();
                if (toTest != null && RE_NAME.matcher(toTest).matches()) {
                    this.nextToken();
                    if (Evaluator.TOKEN_PAREN_START.equals(this.token(1)) && Evaluator.TOKEN_PAREN_END.equals(this.token(2))) {
                        this.nextToken(2);
                        return new AxisExpression(axis, null, toTest);
                    }
                    return new AxisExpression(axis, toTest, null);
                }
                return new AxisExpression(axis, null, Evaluator.KIND_NODE);
            }
            if (Evaluator.TOKEN_AXIS_ATTRIBUTE.equals(axis)) {
                this.nextToken();
                String name = this.token();
                if (RE_NAME.matcher(name).matches()) {
                    this.nextToken();
                    return new AxisExpression(Evaluator.AXIS_ATTRIBUTE, name, null);
                }
            } else {
                String name = this.token();
                if (RE_NAME.matcher(name).matches()) {
                    this.nextToken();
                    return new AxisExpression(Evaluator.AXIS_CHILD, name, null);
                }
            }
            return NULL;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilterExpression
    extends Expression {
        private Expression primary;

        public FilterExpression(Expression primary) {
            this.primary = primary;
        }

        @Override
        public List<Object> evaluate(EvaluationContext context) {
            List<Object> sequence = this.primary.evaluate(context);
            sequence = this.applyPredicates(context, sequence);
            return sequence;
        }

        private List<Object> applyPredicates(EvaluationContext context, List<Object> sequence) {
            if (sequence.isEmpty() || this.getArguments().isEmpty()) {
                return sequence;
            }
            Object oldItem = context.item;
            int oldPosition = context.position;
            int oldSize = context.size;
            for (Expression predicate : this.getArguments()) {
                List<Object> inputSequence = sequence;
                int sequenceSize = inputSequence.size();
                sequence = new ArrayList<Object>();
                if (predicate instanceof Literal && ((Literal)predicate).getValue() instanceof Integer) {
                    int targetIndex = (Integer)((Literal)predicate).getValue() - 1;
                    if (targetIndex < 0 || targetIndex >= sequenceSize) continue;
                    sequence.add(inputSequence.get(targetIndex));
                    continue;
                }
                int index = 0;
                while (index < sequenceSize) {
                    Object item;
                    context.item = item = inputSequence.get(index);
                    context.position = index + 1;
                    context.size = sequenceSize;
                    List<Object> results = predicate.evaluate(context);
                    if (this.test(results, context, index + 1, predicate)) {
                        sequence.add(item);
                    }
                    ++index;
                }
            }
            context.item = oldItem;
            context.position = oldPosition;
            context.size = oldSize;
            return sequence;
        }

        private boolean test(List<Object> conditions, EvaluationContext context, int position, Expression predicate) {
            if (conditions.size() != 1) {
                return false;
            }
            Object condition = conditions.get(0);
            if (condition instanceof Boolean) {
                return (Boolean)condition;
            }
            if (condition instanceof String) {
                return !"".equals(condition);
            }
            if (condition instanceof Integer) {
                return (Integer)condition != 0;
            }
            if (condition instanceof Double) {
                return (Double)condition != 0.0;
            }
            return condition != null;
        }
    }

    private static interface Function {
        public Object call(EvaluationContext var1, FunctionArgumentList var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionArgument {
        private List<Object> sequence;

        public FunctionArgument(List<Object> sequence) {
            this.sequence = sequence;
        }

        public Object anyItem() {
            return this.anyItem(null);
        }

        public Object anyItem(Object defaultItem) {
            return this.sequence.isEmpty() ? defaultItem : this.sequence.get(0);
        }

        public List<Object> sequence() {
            return this.sequence;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionArgumentList {
        private List<FunctionArgument> arguments = new ArrayList<FunctionArgument>();

        public void add(FunctionArgument arg) {
            this.arguments.add(arg);
        }

        public FunctionArgument argumentAt(int index) {
            return index >= 0 && index < this.arguments.size() ? this.arguments.get(index) : NULL_ARGUMENT;
        }

        public List<Object> sequenceAt(int index) {
            return this.argumentAt(index).sequence();
        }

        public Object itemAt(int index) {
            return this.argumentAt(index).anyItem();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionCall
    extends Expression {
        private String name;

        public FunctionCall(String name) {
            this.name = name;
        }

        @Override
        public List<Object> evaluate(EvaluationContext context) {
            Function f = (Function)FUNCTIONS.get(this.name);
            if (f == null) {
                return EMPTY_SEQUENCE;
            }
            FunctionArgumentList args = new FunctionArgumentList();
            for (Expression arg : this.getArguments()) {
                List<Object> sequence = arg.evaluate(context);
                args.add(new FunctionArgument(sequence));
            }
            Object result = f.call(context, args);
            if (result instanceof List) {
                return (List)result;
            }
            return Arrays.asList(result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Literal
    extends Expression {
        private Object value;

        public Literal(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public List<Object> evaluate(EvaluationContext context) {
            return Arrays.asList(this.value);
        }

        public String toString() {
            return this.value == null ? "null" : this.value.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathExpression
    extends Expression {
        private PathExpression() {
        }

        @Override
        public List<Object> evaluate(EvaluationContext context) {
            Object oldItem = context.item;
            List<Object> sequence = Arrays.asList(oldItem);
            for (Expression arg : this.getArguments()) {
                List<Object> inputSequence = sequence;
                sequence = new ArrayList<Object>();
                Iterator<Object> iterator = inputSequence.iterator();
                while (iterator.hasNext()) {
                    Object item;
                    context.item = item = iterator.next();
                    List<Object> results = arg.evaluate(context);
                    for (Object obj : results) {
                        if (sequence.contains(obj)) continue;
                        sequence.add(obj);
                    }
                }
            }
            context.item = oldItem;
            return sequence;
        }
    }
}

