/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.brainstorm.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.xmind.core.ITopic;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.ui.actions.ISelectionAction;
import org.xmind.ui.internal.brainstorm.BrainstormMessages;
import org.xmind.ui.util.MindMapUtils;

public class AlignmentMenu
extends MenuManager
implements ISelectionAction {
    private IGraphicalViewer viewer;

    public AlignmentMenu(IGraphicalViewer viewer) {
        super(BrainstormMessages.AlignmentMenu_Menu_Align_Floating_Topic, "org.xmind.ui.brainstorm.alignment");
        this.viewer = viewer;
        this.setRemoveAllWhenShown(true);
        this.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AlignmentMenu.this.fillMenu();
            }
        });
    }

    private void fillMenu() {
        this.add((IAction)new AlignmentAction(1));
        this.add((IAction)new AlignmentAction(2));
        this.add((IAction)new AlignmentAction(4));
        this.add((IContributionItem)new Separator());
        this.add((IAction)new AlignmentAction(8));
        this.add((IAction)new AlignmentAction(16));
        this.add((IAction)new AlignmentAction(32));
    }

    public void setSelection(ISelection selection) {
        List topics;
        if (MindMapUtils.isAllSuchElements((ISelection)selection, (String)"org.xmind.ui.topic") && (topics = MindMapUtils.getAllSuchElements((ISelection)selection, (String)"org.xmind.ui.topic")).size() >= 2) {
            boolean hasFloatingTopic = false;
            for (Object topic : topics) {
                if (!"detached".equals(((ITopic)topic).getType())) continue;
                hasFloatingTopic = true;
                break;
            }
            this.setVisible(hasFloatingTopic);
            return;
        }
        this.setVisible(false);
    }

    private class AlignmentAction
    extends Action {
        private int alignment;

        public AlignmentAction(int alignment) {
            this.alignment = alignment;
            switch (alignment) {
                case 1: {
                    this.setId("org.xmind.ui.align_left");
                    this.setText(BrainstormMessages.AlignLeft_text);
                    break;
                }
                case 2: {
                    this.setId("org.xmind.ui.align_center");
                    this.setText(BrainstormMessages.AlignCenter_text);
                    break;
                }
                case 4: {
                    this.setId("org.xmind.ui.align_right");
                    this.setText(BrainstormMessages.AlignRight_text);
                    break;
                }
                case 8: {
                    this.setId("org.xmind.ui.align_top");
                    this.setText(BrainstormMessages.AlignTop_text);
                    break;
                }
                case 16: {
                    this.setId("org.xmind.ui.align_middle");
                    this.setText(BrainstormMessages.AlignMiddle_text);
                    break;
                }
                case 32: {
                    this.setId("org.xmind.ui.align_bottom");
                    this.setText(BrainstormMessages.AlignBottom_text);
                }
            }
        }

        public void run() {
            if (AlignmentMenu.this.viewer == null) {
                return;
            }
            Request request = new Request("align").setViewer((IViewer)AlignmentMenu.this.viewer);
            request.setParameter("alignment", (Object)this.alignment);
            EditDomain domain = AlignmentMenu.this.viewer.getEditDomain();
            if (domain == null) {
                return;
            }
            domain.handleRequest(request);
        }
    }
}

