/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.brainstorm.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MarkerImageDescriptor;

public class MarkersMenu
extends MenuManager {
    private IGraphicalViewer viewer;

    public MarkersMenu(IGraphicalViewer viewer) {
        super(MindMapMessages.Markers_text, "org.xmind.ui.brainstorm.markerMenu");
        this.viewer = viewer;
        this.setRemoveAllWhenShown(true);
        this.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MarkersMenu.this.fillMenu(manager);
            }
        });
    }

    private void fillMenu(IMenuManager manager) {
        IMarkerSheet markerSheet = MindMapUI.getResourceManager().getSystemMarkerSheet();
        List groups = markerSheet.getMarkerGroups();
        for (IMarkerGroup group : groups) {
            if (group.isHidden()) continue;
            MenuManager groupMenu = new MenuManager(group.getName(), "#" + group.getId());
            this.fillGroup(group, groupMenu);
            manager.add((IContributionItem)groupMenu);
        }
    }

    private void fillGroup(IMarkerGroup group, MenuManager groupMenu) {
        for (IMarker marker : group.getMarkers()) {
            if (marker.isHidden()) continue;
            groupMenu.add((IAction)new MarkerAction(marker));
        }
    }

    private class MarkerAction
    extends Action {
        private IMarker marker;

        public MarkerAction(IMarker marker) {
            this.marker = marker;
            this.setId("#" + marker.getId());
            this.setText(marker.getName());
            this.setImageDescriptor(MarkerImageDescriptor.createFromMarker((IMarker)marker, (int)16, (int)16));
        }

        public void run() {
            if (MarkersMenu.this.viewer == null) {
                return;
            }
            EditDomain domain = MarkersMenu.this.viewer.getEditDomain();
            if (domain == null) {
                return;
            }
            Request request = new Request("add_marker").setViewer((IViewer)MarkersMenu.this.viewer);
            request.setParameter("markerId", (Object)this.marker.getId());
            domain.handleRequest(request);
        }
    }
}

