/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.brainstorm;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.ZoomManager;
import org.xmind.gef.ZoomObject;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.service.GraphicalViewerService;
import org.xmind.gef.service.IViewerService;
import org.xmind.gef.service.StyleOverrideService;
import org.xmind.ui.brainstorm.Activator;
import org.xmind.ui.internal.brainstorm.BrainstormMessages;
import org.xmind.ui.internal.brainstorm.BrainstormViewer;
import org.xmind.ui.internal.brainstorm.Button;
import org.xmind.ui.internal.brainstorm.ControlPanel;
import org.xmind.ui.internal.brainstorm.ControlPanelFactory;
import org.xmind.ui.internal.brainstorm.IdeaFactoryWrapper;
import org.xmind.ui.internal.brainstorm.ModeService;
import org.xmind.ui.internal.brainstorm.Slider;
import org.xmind.ui.internal.brainstorm.TimerSettingsDialog;
import org.xmind.ui.internal.layers.BaseLayer;

public class BrainstormMenuService
extends GraphicalViewerService {
    private Window window;
    private ModeService modeService;
    private IdeaFactoryWrapper ideaFactoryWrapper = new IdeaFactoryWrapper(this.getViewer().getCanvas().getParent(), this.getViewer().getProperties());
    private ControlPanel controlPanel;
    private SizeableImageFigure modeFigure;
    private SizeableImageFigure ideaFactoryFigure;
    private SizeableImageFigure timerSettingFigure;
    private SizeableImageFigure quitFigure;
    private Button sliderWay;
    private Button zoomFigure;
    private Slider slider;
    private IFigure mouseTarget = null;
    private Map<String, Image> menuImages = null;
    private boolean hovered = false;
    private String hoveredFigure = null;
    private Button currentTargetButton = null;
    private Button sourceButton = null;
    private boolean modifyingZoom = false;
    private static final String IMAGE_SUFFIX = ".png";
    private static final String DAY = "day-";
    private static final String NIGHT = "night-";
    private static final String NORMAL_STATE = "-normal";
    private static final String HOVER_STATE = "-hover";
    private static final String HOVER_PANEL_STATE = "-hover-panel";
    private static final String QUIT = "quit";
    private static final String TIMER = "timer";
    private static final String IDEA_FACTORY = "idea-factory";
    private static final String MODE = "mode";
    private static final String ZOOM_BUTTON = "zoom-button";
    private static final String SLIDER_WAY = "zoom";
    private static final String CONTROL_PANEL = "panel";

    public BrainstormMenuService(Window window, IGraphicalViewer viewer) {
        super(viewer);
        this.window = window;
    }

    protected void activate() {
        Layer layer = this.getViewer().getLayer(BrainstormViewer.LAYER_MENU);
        if (layer == null) {
            this.getViewer().getLayerManager().insertLayer(BrainstormViewer.LAYER_MENU, (Layer)new BaseLayer(), null, false);
            layer = this.getViewer().getLayer(BrainstormViewer.LAYER_MENU);
        }
        if (layer != null) {
            this.controlPanel = ControlPanelFactory.getInstance().createControlPanel();
            this.modeFigure = this.controlPanel.getButton(2);
            this.ideaFactoryFigure = this.controlPanel.getButton(1);
            this.timerSettingFigure = this.controlPanel.getButton(0);
            this.quitFigure = this.controlPanel.getButton(5);
            this.slider = this.controlPanel.getSlider(3);
            this.zoomFigure = this.controlPanel.getButton(3);
            this.sliderWay = this.slider.getSliderWay();
            layer.add((IFigure)this.controlPanel);
        }
        ((BrainstormViewer)this.getViewer()).refresh();
        ZoomManager zm = this.getViewer().getZoomManager();
        this.scaleChanged((ZoomObject)zm, 0.0, zm.getScale());
    }

    private Image getImage(String name) {
        Image image;
        String mode = this.modeService != null && !this.modeService.getMode() ? NIGHT : DAY;
        String imageName = String.valueOf(mode) + name;
        imageName = CONTROL_PANEL.equals(name) ? String.valueOf(imageName) + (this.hovered ? HOVER_STATE : NORMAL_STATE) : (ZOOM_BUTTON.equals(name) ? (this.hovered && !SLIDER_WAY.equals(this.hoveredFigure) ? String.valueOf(imageName) + HOVER_PANEL_STATE : (this.hovered && SLIDER_WAY.equals(this.hoveredFigure) ? String.valueOf(imageName) + HOVER_STATE : String.valueOf(imageName) + NORMAL_STATE)) : (this.hoveredFigure != null && this.hoveredFigure.equals(name) ? String.valueOf(imageName) + HOVER_STATE : String.valueOf(imageName) + NORMAL_STATE));
        imageName = String.valueOf(imageName) + IMAGE_SUFFIX;
        if (this.menuImages == null) {
            this.menuImages = new HashMap<String, Image>();
        }
        if ((image = this.menuImages.get(imageName)) == null && this.isActive()) {
            image = Activator.getImageDescriptor(imageName).createImage();
            this.menuImages.put(imageName, image);
        }
        return image;
    }

    protected void deactivate() {
        if (this.controlPanel != null) {
            if (this.controlPanel.getParent() != null) {
                this.controlPanel.getParent().remove((IFigure)this.controlPanel);
            }
            this.controlPanel = null;
        }
        if (this.menuImages != null && !this.menuImages.isEmpty()) {
            for (Image image : this.menuImages.values()) {
                image.dispose();
            }
            this.menuImages = null;
        }
    }

    private void updateIcons() {
        if (this.controlPanel != null) {
            this.controlPanel.setImage(this.getImage(CONTROL_PANEL));
        }
        if (this.modeFigure != null) {
            this.modeFigure.setImage(this.getImage(MODE));
        }
        if (this.ideaFactoryFigure != null) {
            this.ideaFactoryFigure.setImage(this.getImage(IDEA_FACTORY));
        }
        if (this.timerSettingFigure != null) {
            this.timerSettingFigure.setImage(this.getImage(TIMER));
        }
        if (this.quitFigure != null) {
            this.quitFigure.setImage(this.getImage(QUIT));
        }
        if (this.sliderWay != null) {
            this.sliderWay.setImage(this.getImage(SLIDER_WAY));
        }
        if (this.zoomFigure != null) {
            this.zoomFigure.setImage(this.getImage(ZOOM_BUTTON));
        }
    }

    public boolean handleMouseMove(MouseEvent me) {
        Point p = this.getViewer().getZoomManager().getScaled(me.cursorLocation);
        IFigure oldTarget = this.mouseTarget;
        if (this.controlPanel != null && this.controlPanel.containsPoint(p)) {
            this.hovered = true;
            Button bt = this.controlPanel.findButton(p);
            if (bt != null) {
                this.mouseTarget = bt;
                switch (bt.getId()) {
                    case 2: {
                        this.hoveredFigure = MODE;
                        break;
                    }
                    case 1: {
                        this.hoveredFigure = IDEA_FACTORY;
                        break;
                    }
                    case 0: {
                        this.hoveredFigure = TIMER;
                        break;
                    }
                    case 5: {
                        this.hoveredFigure = QUIT;
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.hoveredFigure = SLIDER_WAY;
                        break;
                    }
                    default: {
                        this.hoveredFigure = null;
                        break;
                    }
                }
            } else {
                this.mouseTarget = null;
                this.hoveredFigure = null;
            }
        } else {
            this.hovered = false;
            this.hoveredFigure = null;
            this.mouseTarget = null;
        }
        this.checkControlPanel(me);
        this.updateIcons();
        if (oldTarget != this.mouseTarget) {
            this.getViewer().updateToolTip();
        }
        return true;
    }

    public boolean handleMouseDown(MouseEvent me) {
        Point p = this.getViewer().getZoomManager().getScaled(me.cursorLocation);
        this.sourceButton = this.controlPanel.findButton(p);
        if (this.modeFigure != null && this.modeFigure.containsPoint(p)) {
            if (this.modeService == null) {
                this.modeService = new ModeService(this.getViewer());
                ((BrainstormViewer)this.getViewer()).installService(StyleOverrideService.class, (IViewerService)this.modeService);
                this.modeService.setActive(true);
            }
            this.modeService.setMode(!this.modeService.getMode());
            if (this.modeService.getMode()) {
                this.modeFigure.setToolTip((IFigure)new Label(BrainstormMessages.Brainstorming_Toolbar_DayMode_tooltip));
            } else {
                this.modeFigure.setToolTip((IFigure)new Label(BrainstormMessages.Brainstorming_Toolbar_NightMode_tooltip));
            }
            this.updateIcons();
            ((BrainstormViewer)this.getViewer()).refresh();
        } else if (this.ideaFactoryFigure != null && this.ideaFactoryFigure.containsPoint(p)) {
            if (this.ideaFactoryWrapper == null) {
                this.ideaFactoryWrapper = new IdeaFactoryWrapper(this.getViewer().getCanvas().getParent(), this.getViewer().getProperties());
            }
            this.ideaFactoryWrapper.setVisible(!this.ideaFactoryWrapper.isVisible());
        } else if (this.timerSettingFigure != null && this.timerSettingFigure.containsPoint(p)) {
            TimerSettingsDialog timerSettingsDialog = new TimerSettingsDialog(this.getViewer(), this.window.getShell());
            timerSettingsDialog.open();
        } else if (this.slider != null && this.zoomFigure != null && this.zoomFigure.containsPoint(p)) {
            int id = this.slider.getId();
            this.controlPanel.setSliderValue(id, p);
            this.handleButtonDragged(id);
        } else if (this.quitFigure != null && this.quitFigure.containsPoint(p) && this.window.close()) {
            return true;
        }
        return false;
    }

    public boolean handleMouseDrag(MouseEvent me) {
        Point p = this.getViewer().getZoomManager().getScaled(me.cursorLocation);
        if (this.sourceButton != null) {
            int id = this.sourceButton.getId();
            if (this.controlPanel.getSlider(id) != null) {
                this.controlPanel.setSliderValue(id, p);
                this.handleButtonDragged(id);
            }
            return true;
        }
        return false;
    }

    public boolean handleMouseUp(MouseEvent me) {
        if (this.sourceButton != null) {
            this.sourceButton = null;
            return true;
        }
        return false;
    }

    private void handleButtonDragged(int id) {
        float value = this.controlPanel.getSliderValue(id);
        if (id == 3) {
            ZoomManager zm = this.getViewer().getZoomManager();
            double newScale = zm.getMin() + (zm.getMax() - zm.getMin()) * (double)value;
            this.modifyingZoom = true;
            this.getViewer().getEditDomain().handleRequest(new Request(SLIDER_WAY).setViewer((IViewer)this.getViewer()).setParameter("zoomScale", (Object)newScale));
            this.modifyingZoom = false;
        }
    }

    public boolean handleMouseDoubleClick(MouseEvent me) {
        Point p = this.getViewer().getZoomManager().getScaled(me.cursorLocation);
        if (this.controlPanel.containsPoint(p)) {
            me.consume();
            return true;
        }
        return false;
    }

    public IFigure getToolTip(Point p) {
        Button bt;
        if (this.controlPanel != null && this.controlPanel.containsPoint(p) && (bt = this.controlPanel.findButton(p)) != null) {
            return bt.getToolTip();
        }
        return null;
    }

    private void checkControlPanel(MouseEvent me) {
        Point p = this.getViewer().getZoomManager().getScaled(me.cursorLocation);
        this.currentTargetButton = this.controlPanel == null ? null : this.controlPanel.findButton(p);
    }

    public Button getCurrentButton(Point p) {
        return this.currentTargetButton;
    }

    public void scaleChanged(ZoomObject source, double oldValue, double newValue) {
        if (this.modifyingZoom) {
            return;
        }
        ZoomManager zm = (ZoomManager)source;
        this.setZoomSliderValue(zm, newValue);
    }

    private void setZoomSliderValue(ZoomManager zm, double newValue) {
        if (this.controlPanel == null) {
            return;
        }
        double value = (newValue - zm.getMin()) / (zm.getMax() - zm.getMin());
        this.controlPanel.setSliderValue(3, (float)value);
        Button button = this.controlPanel.getButton(3);
        if (button != null) {
            String percentage = String.format("%.0f%%", newValue * 100.0);
            button.setToolTip((IFigure)new Label(NLS.bind((String)BrainstormMessages.Zoom_toolTip, (Object)percentage)));
        }
    }
}

