/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xmind.core.ITopic;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.command.ModifyCommand;
import org.xmind.ui.internal.ModelCacheManager;

public class ModifyFoldedCommand
extends ModifyCommand {
    public ModifyFoldedCommand(ITopic source, boolean newFolded) {
        super((Object)source, (Object)newFolded);
    }

    public ModifyFoldedCommand(Collection<? extends ITopic> sources, boolean newFolded) {
        super(sources, (Object)newFolded);
    }

    public ModifyFoldedCommand(ISourceProvider sourceProvider, boolean newFolded) {
        super(sourceProvider, (Object)newFolded);
    }

    protected Object getValue(Object source) {
        if (source instanceof ITopic) {
            return ((ITopic)source).isFolded();
        }
        return null;
    }

    protected void setValue(Object source, Object value) {
        if (source instanceof ITopic && value instanceof Boolean) {
            ((ITopic)source).setFolded(((Boolean)value).booleanValue());
        }
    }

    protected void setNewValues() {
        List<Object> sourcesToChange = this.filterSameValueSources(this.getSources(), false);
        List<Object> rootParents = this.filterRootParents(sourcesToChange);
        for (Object source : this.getSources()) {
            if (rootParents.contains(source)) continue;
            ModelCacheManager.getInstance().setCache(source, "org.xmind.ui.delayLayout", Boolean.TRUE);
            this.setValue(source, this.getNewValue());
            ModelCacheManager.getInstance().flush(source, "org.xmind.ui.delayLayout");
        }
        for (Object rootParent : rootParents) {
            this.setValue(rootParent, this.getNewValue());
        }
    }

    protected void setOldValues() {
        List<Object> sourcesToChange = this.filterSameValueSources(this.getSources(), true);
        List<Object> rootParents = this.filterRootParents(sourcesToChange);
        for (Object source : this.getSources()) {
            if (rootParents.contains(source)) continue;
            ModelCacheManager.getInstance().setCache(source, "org.xmind.ui.delayLayout", Boolean.TRUE);
            this.setValue(source, this.getOldValue(source));
            ModelCacheManager.getInstance().flush(source, "org.xmind.ui.delayLayout");
        }
        for (Object rootParent : rootParents) {
            this.setValue(rootParent, this.getOldValue(rootParent));
        }
    }

    private List<Object> filterSameValueSources(List<Object> sources, boolean oldValueOrNewValue) {
        ArrayList<Object> result = new ArrayList<Object>(sources.size());
        for (Object topic : sources) {
            if (!(topic instanceof ITopic)) continue;
            Object value = oldValueOrNewValue ? this.getOldValue(topic) : this.getNewValue();
            boolean folded = ((ITopic)topic).isFolded();
            if (!(value instanceof Boolean) || value.toString().equals(Boolean.valueOf(folded).toString())) continue;
            result.add(topic);
        }
        return result;
    }

    private List<Object> filterRootParents(List<Object> topics) {
        ArrayList<Object> result = new ArrayList<Object>(topics.size());
        for (Object topic : topics) {
            if (!(topic instanceof ITopic) || this.branchContains((ITopic)topic, topics)) continue;
            result.add(topic);
        }
        return result;
    }

    private boolean branchContains(ITopic topic, List<Object> topics) {
        boolean contains = false;
        ITopic parent = topic.getParent();
        if (parent != null && !(contains = topics.contains(parent))) {
            contains = this.branchContains(parent, topics);
        }
        return contains;
    }
}

