/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.editor.WorkbookHistory;
import org.xmind.ui.internal.editor.WorkbookHistoryItem;
import org.xmind.ui.util.Logger;

public class ReopenWorkbookMenu
extends Action
implements ActionFactory.IWorkbenchAction {
    private static final String MODIFIED_TIME_KEY = "org.xmind.ui.workbookHistory.lastModifiedTime";
    private IWorkbenchWindow window;

    public ReopenWorkbookMenu(IWorkbenchWindow window) {
        this(window, "org.xmind.ui.reopenWorkbook");
    }

    public ReopenWorkbookMenu(IWorkbenchWindow window, String id) {
        super(MindMapMessages.ReopenWorkbookMenu_text);
        this.window = window;
        this.setId(id);
        this.setToolTipText(MindMapMessages.ReopenWorkbookMenu_toolTip);
        this.setMenuCreator(new WorkbookHistoryMenuCreator());
    }

    public void dispose() {
        this.window = null;
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof ToolItem) {
            this.showDropDownMenu((ToolItem)event.widget, event);
        }
    }

    private void showDropDownMenu(ToolItem ti, Event e) {
        IMenuCreator mc = this.getMenuCreator();
        if (mc == null) {
            return;
        }
        Menu m = mc.getMenu((Control)ti.getParent());
        if (m != null) {
            Rectangle r = ti.getBounds();
            Point point = ti.getParent().toDisplay(new Point(r.x, r.y + r.height));
            m.setLocation(point.x, point.y);
            m.setVisible(true);
            return;
        }
    }

    private void refreshMenu(Menu menu) {
        long lastModifiedTime = WorkbookHistory.getInstance().getLastModifiedTime();
        Object cachedLastModifiedTime = menu.getData(MODIFIED_TIME_KEY);
        if (cachedLastModifiedTime instanceof Long && (Long)cachedLastModifiedTime >= lastModifiedTime) {
            return;
        }
        this.rebuildMenu(menu);
        menu.setData(MODIFIED_TIME_KEY, (Object)lastModifiedTime);
    }

    private void rebuildMenu(Menu menu) {
        this.removeAll(menu);
        this.fillMenu(menu);
        if (menu.getItemCount() == 0) {
            MenuItem placeholder = new MenuItem(menu, 8, 0);
            placeholder.setText(MindMapMessages.ReopenWorkbookMenu_NoItemsPlaceholder_text);
            placeholder.setEnabled(false);
        }
    }

    private void removeAll(Menu menu) {
        int total;
        int i = total = menu.getItemCount();
        while (i > 0) {
            menu.getItem(i - 1).dispose();
            --i;
        }
    }

    private void fillMenu(Menu menu) {
        if (this.window == null || this.window.getActivePage() == null) {
            return;
        }
        int itemsToShow = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("RECENT_FILES");
        if (itemsToShow <= 0) {
            return;
        }
        WorkbookHistoryItem[] items = WorkbookHistory.getInstance().getTopItems(itemsToShow);
        if (items.length == 0) {
            return;
        }
        int index = this.fillWithItems(menu, 0, items);
        if (menu.getItemCount() > 0) {
            new MenuItem(menu, 2, index);
            this.fillClearItem(menu, ++index);
        }
    }

    private int fillWithItems(Menu menu, int index, WorkbookHistoryItem[] items) {
        Object[] paths = this.getDisambiguatedPaths(items);
        int i = 0;
        while (i < items.length) {
            WorkbookHistoryItem item = items[i];
            this.fillWithItem(menu, index, item, i, paths[i].toString());
            ++index;
            ++i;
        }
        return index;
    }

    private void fillWithItem(Menu menu, int menuItemIndex, final WorkbookHistoryItem item, int itemIndex, String path) {
        MenuItem mi = new MenuItem(menu, 8, menuItemIndex);
        mi.setText(path);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReopenWorkbookMenu.this.reopen(item);
            }
        });
    }

    private int fillClearItem(Menu menu, int index) {
        MenuItem mi = new MenuItem(menu, 8, index);
        mi.setText(MindMapMessages.ReopenWorkbookMenu_ClearListAction_text);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReopenWorkbookMenu.this.clear();
            }
        });
        return ++index;
    }

    private Object[] getDisambiguatedPaths(WorkbookHistoryItem[] items) {
        Object[] paths = new Object[items.length];
        ArrayList<FileDissection> files = new ArrayList<FileDissection>(items.length);
        int i = 0;
        while (i < items.length) {
            String path;
            WorkbookHistoryItem item = items[i];
            String uri = item.getURI();
            if (uri.equals(path = item.getPath())) {
                paths[i] = uri;
            } else {
                FileDissection file = new FileDissection(new File(path));
                paths[i] = file;
                files.add(file);
            }
            ++i;
        }
        i = 1;
        while (i < files.size()) {
            FileDissection file1 = (FileDissection)files.get(i);
            int j = 0;
            while (j < i) {
                FileDissection file2 = (FileDissection)files.get(j);
                while (file1.canDisambiguateWith(file2)) {
                    file1.increaseNeck();
                    file2.increaseNeck();
                }
                ++j;
            }
            ++i;
        }
        return paths;
    }

    private void reopen(WorkbookHistoryItem item) {
        IEditorPart editor;
        if (this.window == null) {
            return;
        }
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            return;
        }
        if (item.getExistingEditorInput() != null && (editor = page.findEditor(item.getExistingEditorInput())) != null) {
            page.activate((IWorkbenchPart)editor);
            return;
        }
        try {
            item.reopen(page);
        }
        catch (CoreException e) {
            Logger.log(e);
        }
    }

    private void clear() {
        if (this.window == null) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.window.getShell(), (String)DialogMessages.ConfirmClearRecentFileListDialog_title, (String)DialogMessages.ConfirmClearRecentFileListDialog_message)) {
            return;
        }
        WorkbookHistory.getInstance().clear();
    }

    private static class FileDissection {
        String head;
        String neck;
        File body;

        public FileDissection(File file) {
            this.head = file.getName();
            this.neck = null;
            this.body = file.getParentFile();
        }

        public void increaseNeck() {
            if (this.body == null) {
                return;
            }
            String name = this.body.getName();
            this.body = this.body.getParentFile();
            this.neck = this.neck == null ? name : String.valueOf(name) + File.separator + this.neck;
        }

        public boolean canDisambiguateWith(FileDissection that) {
            return that != null && this.head.equals(that.head) && (this.neck == null || this.neck == that.neck || this.neck != null && this.neck.equals(that.neck)) && (this.body != null || that.body != null);
        }

        public String toString() {
            return this.neck == null ? this.head : String.format("%2$s - %3$s", File.separator, this.head, this.neck);
        }
    }

    private class WorkbookHistoryMenuCreator
    implements IMenuCreator,
    MenuListener {
        private Menu menu;

        private WorkbookHistoryMenuCreator() {
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
                this.menu = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null && !this.menu.isDisposed()) {
                return this.menu;
            }
            this.menu = new Menu(parent);
            this.menu.addMenuListener((MenuListener)this);
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            if (this.menu != null && !this.menu.isDisposed()) {
                return this.menu;
            }
            this.menu = new Menu(parent);
            this.menu.addMenuListener((MenuListener)this);
            return this.menu;
        }

        public void menuHidden(MenuEvent e) {
        }

        public void menuShown(MenuEvent e) {
            ReopenWorkbookMenu.this.refreshMenu((Menu)e.widget);
        }
    }
}

