/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.xmind.core.ITopic;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.branch.IBranchPolicyDescriptor;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyTopicStructureCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class StructureMenu
extends MenuManager {
    private IGraphicalEditorPage page;

    public StructureMenu() {
        super(MindMapMessages.Structure_text, "org.xmind.ui.structureMenu");
        this.setRemoveAllWhenShown(true);
        this.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                StructureMenu.this.fillMenu();
            }
        });
    }

    public void setActivePage(IGraphicalEditorPage page) {
        this.page = page;
    }

    private void fillMenu() {
        List<IBranchPolicyDescriptor> descriptors = this.getCurrentStructures();
        if (descriptors == null) {
            return;
        }
        for (IBranchPolicyDescriptor descriptor : descriptors) {
            this.addStructureAction(descriptor);
        }
    }

    private void addStructureAction(IBranchPolicyDescriptor descriptor) {
        this.add((IAction)new StructureAction(descriptor));
    }

    private List<IBranchPolicyDescriptor> getCurrentStructures() {
        ISelection selection;
        if (this.page == null) {
            return null;
        }
        ArrayList<IBranchPolicyDescriptor> list = null;
        IGraphicalViewer viewer = this.page.getViewer();
        if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBranchPart branch;
                Object o = objectArray[n2];
                if (o instanceof ITopic && (branch = MindMapUtils.findBranch(viewer.findPart(o))) != null) {
                    List<IBranchPolicyDescriptor> applicables = MindMapUI.getBranchPolicyManager().getApplicableBranchPolicyDescriptors(branch);
                    if (applicables.isEmpty()) {
                        return null;
                    }
                    if (list == null) {
                        list = new ArrayList<IBranchPolicyDescriptor>(applicables);
                    } else {
                        list.retainAll(applicables);
                    }
                    if (list.isEmpty()) {
                        return null;
                    }
                }
                ++n2;
            }
        }
        return list;
    }

    private class StructureAction
    extends Action {
        private IBranchPolicyDescriptor descriptor;

        public StructureAction(IBranchPolicyDescriptor descriptor) {
            this.descriptor = descriptor;
            this.setId("#" + descriptor.getId());
            this.setText(descriptor.getName());
            this.setImageDescriptor(descriptor.getIcon());
        }

        public void run() {
            if (StructureMenu.this.page == null) {
                return;
            }
            this.changeStructureClass(this.descriptor.getId());
        }

        private void changeStructureClass(String newStructureClass) {
            EditDomain domain = StructureMenu.this.page.getEditDomain();
            if (domain == null) {
                return;
            }
            ICommandStack commandStack = domain.getCommandStack();
            if (commandStack == null) {
                return;
            }
            List<ITopic> topics = this.getTopics();
            if (topics != null && !topics.isEmpty()) {
                ModifyTopicStructureCommand command = new ModifyTopicStructureCommand(topics, newStructureClass);
                command.setLabel(CommandMessages.Command_ModifyTopicStructure);
                commandStack.execute((Command)command);
            }
        }

        private List<ITopic> getTopics() {
            ISelection selection = StructureMenu.this.page.getViewer().getSelection();
            if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                return null;
            }
            Object[] elements = ((IStructuredSelection)selection).toArray();
            ArrayList<ITopic> list = new ArrayList<ITopic>(elements.length);
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof ITopic && !list.contains(o)) {
                    list.add((ITopic)o);
                }
                ++n2;
            }
            return list;
        }
    }
}

