/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.AbstractBranchStructure;
import org.xmind.ui.internal.branch.BaseRadialStructure;
import org.xmind.ui.internal.branch.RadialData;
import org.xmind.ui.internal.branch.RadialUtils;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.tools.ParentSearchKey;
import org.xmind.ui.util.MindMapUtils;

public class AntiClockwiseRadialStructure
extends BaseRadialStructure {
    @Override
    public boolean isChildLeft(IBranchPart branch, IBranchPart child) {
        Point pos;
        if (branch.isCentral() && (pos = (Point)MindMapUtils.getCache((IPart)child, "org.xmind.ui.cache.preferredPosition")) != null) {
            return RadialUtils.isLeft(0, pos.x);
        }
        if (this.calculatingBranches.contains(branch)) {
            return false;
        }
        this.calculatingBranches.add(branch);
        int index = branch.getSubBranches().indexOf(child);
        boolean left = index >= 0 ? index < this.getRadialData(branch).getNumRight() : (branch.getSummaryBranches().contains(child) ? !this.isSummaryChildLeft(branch, child) : (branch.getCalloutBranches().contains(child) ? this.isChildLeft(branch.getParentBranch(), branch) : RadialUtils.isLeft(this.getReference((IBranchPart)branch).x, this.getReference((IBranchPart)child).x)));
        this.calculatingBranches.remove(branch);
        return left;
    }

    @Override
    protected void doFillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, AbstractBranchStructure.LayoutInfo info) {
        RadialData cache = this.getRadialData(branch);
        int numRight = cache.getNumRight();
        int[] childrenSpacings = cache.getChildrenSpacings();
        int num = subBranches.size();
        boolean right = false;
        BaseRadialStructure.RadiationInsertion insertion = this.getCurrentInsertion(branch);
        int insHeight = insertion == null ? 0 : insertion.getSize().height;
        int y = -cache.getRightSumSpacing() / 2;
        if (insertion != null && !insertion.right) {
            y -= insHeight / 2;
        }
        Point ref = info.getReference();
        int i = 0;
        while (i < num) {
            Rectangle r;
            if (i == numRight) {
                y = cache.getLeftSumSpacing() / 2;
                if (insertion != null && insertion.right) {
                    y += insHeight / 2;
                }
                right = true;
            }
            if (insertion != null && i == insertion.getIndex() && (i != numRight || insertion.right)) {
                Point p = ref.getTranslated(cache.getX(y, right), y);
                Rectangle insBounds = RadialUtils.getPrefBounds(insertion.getSize(), p, right);
                info.add(insBounds);
                y = insertion.right ? (y -= insHeight) : (y += insHeight);
            }
            IBranchPart subBranch = subBranches.get(i);
            Dimension offset = this.getOffset(subBranch);
            IFigure subFigure = subBranch.getFigure();
            if (offset != null && subFigure instanceof IReferencedFigure) {
                Point subRef = ref.getTranslated(offset);
                r = ((IReferencedFigure)subFigure).getPreferredBounds(subRef);
            } else {
                int x = cache.getX(y, right);
                Point subRef = ref.getTranslated(x, y);
                r = RadialUtils.getPrefBounds(subBranch, subRef, right);
            }
            info.put(subFigure, r);
            y = i < numRight ? (y += childrenSpacings[i]) : (y -= childrenSpacings[i]);
            if (insertion != null && (i == numRight - 1 && insertion.getIndex() == numRight && !insertion.right || i == num)) {
                Point p = ref.getTranslated(cache.getX(y, right), y);
                Rectangle insBounds = RadialUtils.getPrefBounds(insertion.getSize(), p, right);
                info.add(insBounds);
                y += insHeight;
            }
            ++i;
        }
    }

    @Override
    protected int calcInsIndex(IBranchPart branch, ParentSearchKey key, boolean withDisabled) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        if (subBranches.isEmpty()) {
            return withDisabled ? 0 : -1;
        }
        if (branch.isFolded()) {
            return withDisabled ? 0 : -1;
        }
        ITopicPart topic = branch.getTopicPart();
        if (topic == null) {
            return withDisabled ? 0 : -1;
        }
        Point childRef = key.getFigure().getReference();
        Point ref = ((IReferencedFigure)topic.getFigure()).getReference();
        RadialData cache = this.getRadialData(branch);
        int numRight = cache.getNumRight();
        int[] childrenSpacings = cache.getChildrenSpacings();
        int num = subBranches.size();
        boolean right = true;
        Dimension insSize = this.calcInsSize(branch, key);
        int insHeight = insSize.height;
        boolean insRight = this.calcInsSide(branch, ref, key);
        int startY = ref.y;
        int y = startY - cache.getRightSumSpacing() / 2;
        if (!insRight) {
            y -= insHeight / 2;
        }
        int ret = 0;
        int i = 0;
        while (i < num) {
            if (i == numRight) {
                y = startY + cache.getLeftSumSpacing() / 2;
                if (insRight) {
                    y += insHeight / 2;
                }
                right = false;
            }
            IBranchPart subbranch = subBranches.get(i);
            IFigure subFigure = subbranch.getFigure();
            Insets refIns = RadialUtils.getRefInsets(subFigure, right);
            int hint = i < numRight ? y - refIns.top + (refIns.getHeight() + insHeight) / 2 : y + refIns.top - (refIns.getHeight() + insHeight) / 2;
            if (i < numRight) {
                if (!insRight && childRef.y <= hint) {
                    return ret;
                }
                if (withDisabled || subFigure.isEnabled()) {
                    ++ret;
                }
                if (i == numRight - 1 && childRef.x < ref.x && childRef.y >= hint) {
                    return ret;
                }
            } else {
                if (insRight && childRef.y > hint) {
                    return ret;
                }
                if (withDisabled || subFigure.isEnabled()) {
                    ++ret;
                }
            }
            y = i < numRight ? (y += childrenSpacings[i]) : (y -= childrenSpacings[i]);
            ++i;
        }
        return withDisabled ? num : -1;
    }

    @Override
    public IPart calcChildNavigation(IBranchPart branch, IBranchPart sourceChild, String navReqType, boolean sequential) {
        int numRight = this.getRadialData(branch).getNumRight();
        int numLeft = this.getRadialData(branch).getNumLeft();
        int index = sourceChild.getBranchIndex();
        int num = branch.getSubBranches().size();
        if ("navigate_up".equals(navReqType)) {
            if (index == 0) {
                return this.getSubTopicPart(branch, num - 1);
            }
            if (index == numRight - 1) {
                return this.getSubTopicPart(branch, index - 1);
            }
            if (index == numRight) {
                return this.getSubTopicPart(branch, index + 1);
            }
            if (index > numRight) {
                if (index == num - 1) {
                    return this.getSubTopicPart(branch, 0);
                }
                return this.getSubTopicPart(branch, index + 1);
            }
            return this.getSubTopicPart(branch, index - 1);
        }
        if ("navigate_down".equals(navReqType)) {
            if (index == 0) {
                return this.getSubTopicPart(branch, index + 1);
            }
            if (index == numRight - 1) {
                return this.getSubTopicPart(branch, index + 1);
            }
            if (index == numRight) {
                return this.getSubTopicPart(branch, index - 1);
            }
            if (index > numRight) {
                return this.getSubTopicPart(branch, index - 1);
            }
            return this.getSubTopicPart(branch, index + 1);
        }
        if ("navigate_left".equals(navReqType)) {
            if (index < numRight) {
                return null;
            }
            return branch.getTopicPart();
        }
        if ("navigate_right".equals(navReqType)) {
            if (index >= numLeft) {
                return null;
            }
            return branch.getTopicPart();
        }
        if (!sequential) {
            if ("navigate_right".equals(navReqType)) {
                int numFirst = this.getRadialData(branch).getNumRight();
                if (sourceChild.getBranchIndex() >= numFirst) {
                    return branch.getTopicPart();
                }
            } else if ("navigate_left".equals(navReqType)) {
                int numFirst = this.getRadialData(branch).getNumRight();
                if (sourceChild.getBranchIndex() < numFirst) {
                    return branch.getTopicPart();
                }
            }
        }
        return super.calcChildNavigation(branch, sourceChild, navReqType, sequential);
    }

    @Override
    public IPart calcNavigation(IBranchPart branch, String navReqType) {
        int num = branch.getSubBranches().size();
        if ("navigate_left".equals(navReqType)) {
            if (!branch.getSubBranches().isEmpty()) {
                return this.getSubTopicPart(branch, 0);
            }
        } else if ("navigate_right".equals(navReqType)) {
            return this.getSubTopicPart(branch, num - 1);
        }
        return super.calcNavigation(branch, navReqType);
    }

    public Dimension calcInsSize(IBranchPart branch, ParentSearchKey key) {
        return key.getFigure().getSize();
    }

    public boolean calcInsSide(IBranchPart branch, Point branchRef, ParentSearchKey key) {
        Point childRef = key.getFigure().getReference();
        return childRef.x > branchRef.x;
    }

    @Override
    public int getSummaryDirection(IBranchPart branch, ISummaryPart summary) {
        IBranchPart subBranch;
        int index;
        List<IBranchPart> enclosingBranches = summary.getEnclosingBranches();
        if (!enclosingBranches.isEmpty() && (index = (subBranch = enclosingBranches.get(0)).getBranchIndex()) >= 0 && index >= this.getRadialData(branch).getNumRight()) {
            return 16;
        }
        return 8;
    }

    @Override
    protected Point calcInsertPosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        Point firstLoc = this.calcFirstChildPosition(branch, key);
        if (subBranches.isEmpty()) {
            return firstLoc;
        }
        int index = this.calcInsIndex(branch, key, true);
        RadialData cache = this.getRadialData(branch);
        int subSize = subBranches.size();
        int left = cache.getNumRight();
        int right = subSize - left;
        Dimension insSize = key.getFigure().getSize();
        Dimension inventSize = key.getInvent().getSize();
        IBranchPart first = subBranches.get(0);
        Rectangle fBounds = first.getFigure().getBounds();
        if (index == 0) {
            int x = fBounds.right() - inventSize.width / 2;
            int y = fBounds.y - (insSize.height + inventSize.height) / 2;
            return new Point(x, y);
        }
        if (index == subSize || index == -1) {
            if (subSize == 1 && this.isWithinThreshold(first)) {
                if (fBounds.bottom() > 0) {
                    int x = fBounds.right() - inventSize.width / 2;
                    int y = fBounds.bottom() + (insSize.height + inventSize.height) / 2;
                    return new Point(x, y);
                }
                return new Point(firstLoc.x, -firstLoc.y);
            }
            if (right == 0) {
                return firstLoc.getNegated();
            }
            IBranchPart sub = subBranches.get(subSize - 1);
            Rectangle bounds = sub.getFigure().getBounds();
            if (right == 1 && bounds.y > 0) {
                return new Point(-firstLoc.x, firstLoc.y);
            }
            int x = bounds.x + inventSize.width / 2;
            int y = bounds.y - (insSize.height + inventSize.height) / 2;
            return new Point(x, y);
        }
        if (index == left) {
            boolean isLeft = left == 1 && right == 1 || this.isRight(subBranches, child, left);
            IBranchPart sub = isLeft ? subBranches.get(index - 1) : subBranches.get(index);
            Rectangle bounds = sub.getFigure().getBounds();
            int x = isLeft ? bounds.right() - inventSize.width / 2 : bounds.x + inventSize.width / 2;
            int y = bounds.bottom() + (insSize.height + inventSize.height) / 2;
            return new Point(x, y);
        }
        boolean isLeft = index < left;
        return this.calcInventPosition(subBranches.get(isLeft ? index - 1 : index), subBranches.get(isLeft ? index : index - 1), key, !isLeft);
    }

    @Override
    protected Point calcMovePosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        List<Integer> disables = this.getDisableBranches(branch);
        int index = this.calcInsIndex(branch, key, true);
        int oldIndex = this.getOldIndex(branch, child);
        if (disables != null) {
            if (disables.contains(index - 1)) {
                oldIndex = --index;
            } else if (disables.contains(index)) {
                oldIndex = index;
            }
        }
        RadialData cache = this.getRadialData(branch);
        int left = cache.getNumRight();
        Dimension inventSize = key.getInvent().getSize();
        if (index == oldIndex) {
            if (index == left - 1 && key.getCursorPos().x > 0 && !subBranches.get(left).getFigure().isEnabled()) {
                ++index;
            }
            int delta = this.getTopicSize((IBranchPart)subBranches.get((int)index)).width / 2 - inventSize.width / 2;
            int deltaX = index < left ? delta : -delta;
            return this.getReference(subBranches.get(index)).getTranslated(deltaX, 0);
        }
        return this.calcInsertPosition(branch, child, key);
    }

    @Override
    protected Point calcFirstChildPosition(IBranchPart branch, ParentSearchKey key) {
        int y = -(this.getMinorSpacing(branch) * 3 / 4 + 8) * 4;
        int x = this.getRadialData(branch).getX(y, true);
        return this.getReference(branch).getTranslated(-x, y).getTranslated(-key.getInvent().getSize().width / 2, 0);
    }
}

