/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.xmind.core.IImage;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.mindmap.IImagePart;

public class ImageDecorator
extends Decorator {
    private static final ImageDecorator instance = new ImageDecorator();

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
        if (part instanceof IImagePart) {
            IImagePart imagePart = (IImagePart)part;
            if (figure instanceof SizeableImageFigure) {
                SizeableImageFigure imageFigure = (SizeableImageFigure)figure;
                this.decorateImageFigure(imagePart, imageFigure);
            }
        }
    }

    private void decorateImageFigure(IImagePart imagePart, SizeableImageFigure imageFigure) {
        imageFigure.setStretched(true);
        imageFigure.setConstrained(false);
        imageFigure.setImage(imagePart.getImage());
        IImage imageModel = imagePart.getImageModel();
        int width = imageModel.getWidth();
        int height = imageModel.getHeight();
        if (width >= 0 && height >= 0) {
            imageFigure.setPreferredSize(width, height);
        } else {
            Dimension originalSize = imageFigure.getImageSize();
            if (width >= 0) {
                imageFigure.setPreferredSize(width, originalSize.width == 0 ? 0 : width * originalSize.height / originalSize.width);
            } else if (height >= 0) {
                imageFigure.setPreferredSize(originalSize.height == 0 ? 0 : height * originalSize.width / originalSize.height, height);
            } else {
                double scale2;
                width = Math.min(400, originalSize.width);
                double scale1 = (double)width * 1.0 / (double)originalSize.width;
                if (scale1 < (scale2 = (double)(height = Math.min(400, originalSize.height)) * 1.0 / (double)originalSize.height)) {
                    height = (int)((double)originalSize.height * scale1);
                } else {
                    width = (int)((double)originalSize.width * scale2);
                }
                imageFigure.setPreferredSize(width, height);
            }
        }
    }

    public static ImageDecorator getInstance() {
        return instance;
    }
}

