/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.core.IImage;
import org.xmind.core.INumbering;
import org.xmind.core.IRelationship;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.gef.IDecorator;
import org.xmind.gef.IViewer;
import org.xmind.gef.acc.IAccessible;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.IAnchorListener;
import org.xmind.gef.draw2d.ITitledFigure;
import org.xmind.gef.draw2d.decoration.IConnectionDecoration;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.graphicalpolicy.IGraphicalPolicy;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.gef.ui.actions.ActionRegistry;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.ui.internal.IconTipContributorManager;
import org.xmind.ui.internal.InfoItemContributorManager;
import org.xmind.ui.internal.TopicInfoItemManager;
import org.xmind.ui.internal.decorators.TopicDecorator;
import org.xmind.ui.internal.figures.TopicFigure;
import org.xmind.ui.internal.graphicalpolicies.TopicGraphicalPolicy;
import org.xmind.ui.internal.layouts.TopicLayout;
import org.xmind.ui.internal.mindmap.BranchPart;
import org.xmind.ui.internal.mindmap.ChildSorter;
import org.xmind.ui.internal.mindmap.DecoratedAnchor;
import org.xmind.ui.internal.mindmap.DefaultSelectionFeedbackHelper;
import org.xmind.ui.internal.mindmap.ImagePart;
import org.xmind.ui.internal.mindmap.MarkerPart;
import org.xmind.ui.internal.mindmap.NodePart;
import org.xmind.ui.internal.mindmap.NumberingPart;
import org.xmind.ui.internal.mindmap.TitleTextPart;
import org.xmind.ui.internal.mindmap.TopicAccessible;
import org.xmind.ui.internal.mindmap.TopicTitleTextPart;
import org.xmind.ui.internal.mindmap.ViewerModel;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IConnectionPart;
import org.xmind.ui.mindmap.IIconTipContributor;
import org.xmind.ui.mindmap.IIconTipPart;
import org.xmind.ui.mindmap.IImagePart;
import org.xmind.ui.mindmap.IInfoItemContributor;
import org.xmind.ui.mindmap.IMarkerPart;
import org.xmind.ui.mindmap.INumberingPart;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.mindmap.ISelectionFeedbackHelper;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ITitleTextPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class TopicPart
extends NodePart
implements ITopicPart {
    private static Comparator<IMarkerRef> MARKER_REF_COMPARATOR = new Comparator<IMarkerRef>(){

        @Override
        public int compare(IMarkerRef p, IMarkerRef q) {
            IMarker pMarker = p.getMarker();
            IMarker qMarker = q.getMarker();
            if (pMarker == null && qMarker == null) {
                return 0;
            }
            if (qMarker == null && pMarker != null) {
                IMarkerSheet pSheet = pMarker.getOwnedSheet();
                List grouplist = pSheet.getMarkerGroups();
                IMarkerGroup pMarkerGroup = pMarker.getParent();
                return pMarkerGroup == null ? 0 : -12000 + grouplist.indexOf(pMarkerGroup) * 100 + pMarkerGroup.getMarkers().indexOf(pMarker);
            }
            if (pMarker == null && qMarker != null) {
                IMarkerSheet qSheet = qMarker.getOwnedSheet();
                List grouplist = qSheet.getMarkerGroups();
                IMarkerGroup qMarkerGroup = qMarker.getParent();
                return qMarkerGroup == null ? 0 : 12000 - grouplist.indexOf(qMarkerGroup) * 100 - qMarkerGroup.getMarkers().indexOf(qMarker);
            }
            IMarkerSheet pSheet = pMarker.getOwnedSheet();
            IMarkerSheet qSheet = qMarker.getOwnedSheet();
            List grouplist = pSheet.getMarkerGroups();
            IMarkerGroup pMarkerGroup = pMarker.getParent();
            IMarkerGroup qMarkerGroup = qMarker.getParent();
            if (pMarkerGroup == null || qMarkerGroup == null) {
                return 0;
            }
            if (pSheet.equals(qSheet)) {
                if (pMarkerGroup.equals(qMarkerGroup)) {
                    List nosingle = pMarkerGroup.getMarkers();
                    return nosingle.indexOf(pMarker) - nosingle.indexOf(qMarker);
                }
                return (grouplist.indexOf(pMarkerGroup) - grouplist.indexOf(qMarkerGroup)) * 100 + pMarkerGroup.getMarkers().indexOf(pMarker) - qMarkerGroup.getMarkers().indexOf(qMarker);
            }
            if (MindMapUI.getResourceManager().getSystemMarkerSheet().equals(pSheet)) {
                return -2000 + (grouplist.indexOf(pMarkerGroup) - qSheet.getMarkerGroups().indexOf(qMarkerGroup)) * 100 + pMarkerGroup.getMarkers().indexOf(pMarker) - qMarkerGroup.getMarkers().indexOf(qMarker);
            }
            return 2000 + (grouplist.indexOf(pMarkerGroup) - qSheet.getMarkerGroups().indexOf(qMarkerGroup)) * 100 + pMarkerGroup.getMarkers().indexOf(pMarker) - qMarkerGroup.getMarkers().indexOf(qMarker);
        }
    };
    private ITitleTextPart title = null;
    private List<IMarkerPart> markers = null;
    private List<IIconTipPart> iconTips = null;
    private IImagePart image = null;
    private INumberingPart numbering = null;
    private final ChildSorter sorter = new ChildSorter((IPart)this);
    private IActionRegistry actionRegistry = null;
    private IAnchor anchor = null;
    private IAnchorListener anchorListener = null;
    private TopicInfoItemManager topicInfoItemManager = new TopicInfoItemManager(this);

    public TopicPart() {
        this.setDecorator((IDecorator)TopicDecorator.getInstance());
        this.setGraphicalPolicy((IGraphicalPolicy)TopicGraphicalPolicy.getInstance());
    }

    @Override
    public ITopic getTopic() {
        return (ITopic)this.getRealModel();
    }

    @Override
    public IBranchPart getOwnerBranch() {
        if (this.getParent() instanceof IBranchPart) {
            return (IBranchPart)this.getParent();
        }
        return null;
    }

    public void setParent(IPart parent) {
        BranchPart branch;
        if (this.getParent() instanceof BranchPart && (branch = (BranchPart)this.getParent()).getTopicPart() == this) {
            branch.setTopicPart(null);
        }
        super.setParent(parent);
        if (this.getParent() instanceof BranchPart) {
            branch = (BranchPart)this.getParent();
            branch.setTopicPart(this);
        }
    }

    protected LayoutManager createLayoutManager() {
        return new TopicLayout(this);
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("selectable role", (IEditPolicy)NullEditPolicy.getInstance());
        reqHandler.installEditPolicy("navigable role", "org.xmind.ui.editPolicy.topicNavigable");
        reqHandler.installEditPolicy("editable role", "org.xmind.ui.editPolicy.editable");
        reqHandler.installEditPolicy("modifiable role", "org.xmind.ui.editPolicy.modifiable");
        reqHandler.installEditPolicy("traversable role", "org.xmind.ui.editPolicy.topicTraversable");
        reqHandler.installEditPolicy("drop target role", "org.xmind.ui.editPolicy.dropTarget");
        reqHandler.installEditPolicy("sortable role", "org.xmind.ui.editPolicy.topicSortable");
        if (!this.isCentral() && !"summary".equals(this.getTopic().getType())) {
            reqHandler.installEditPolicy("movable role", "org.xmind.ui.editPolicy.topicMovable");
        }
        if (this.isCentral()) {
            reqHandler.installEditPolicy("map movable role", "org.xmind.ui.editPolicy.mapMovable");
        }
    }

    private boolean isCentral() {
        IBranchPart branch = this.getOwnerBranch();
        return branch != null && branch.isCentral();
    }

    public boolean containsPoint(Point position) {
        return super.containsPoint(position);
    }

    @Override
    public ITitleTextPart getTitle() {
        return this.title;
    }

    public void setTitle(ITitleTextPart title) {
        this.title = title;
    }

    @Override
    public List<IMarkerPart> getMarkers() {
        if (this.markers == null) {
            this.markers = new ArrayList<IMarkerPart>();
        }
        return this.markers;
    }

    public void addMarker(IMarkerPart marker) {
        this.getMarkers().add(marker);
        this.sorter.sort(this.getMarkers());
    }

    public void removeMarker(IMarkerPart marker) {
        this.getMarkers().remove(marker);
    }

    @Override
    public List<IIconTipPart> getIconTips() {
        if (this.iconTips == null) {
            this.iconTips = new ArrayList<IIconTipPart>();
        }
        return this.iconTips;
    }

    public void addIconTip(IIconTipPart iconTip) {
        this.getIconTips().add(iconTip);
        this.sorter.sort(this.getIconTips());
    }

    public void removeIconTip(IIconTipPart iconTip) {
        this.getIconTips().remove(iconTip);
    }

    @Override
    public IImagePart getImagePart() {
        return this.image;
    }

    public void setImagePart(IImagePart image) {
        this.image = image;
    }

    @Override
    public INumberingPart getNumberingPart() {
        return this.numbering;
    }

    public void setNumberingPart(INumberingPart numbering) {
        this.numbering = numbering;
    }

    protected IFigure createFigure() {
        return new TopicFigure();
    }

    @Override
    protected ISelectionFeedbackHelper createSelectionFeedbackHelper() {
        return new DefaultSelectionFeedbackHelper();
    }

    protected void register() {
        this.registerModel(this.getTopic());
        super.register();
    }

    protected void unregister() {
        super.unregister();
        this.unregisterModel(this.getTopic());
    }

    protected Object[] getModelChildren(Object model) {
        ArrayList<Object> list = new ArrayList<Object>();
        ITopic topic = this.getTopic();
        list.add(new ViewerModel(TopicTitleTextPart.class, topic));
        if (this.getNumberingText() != null) {
            list.add(new ViewerModel(NumberingPart.class, topic));
        }
        this.addIconTips(topic, list);
        this.addMarkers(topic, list);
        if (topic.getImage().getSource() != null) {
            list.add(new ViewerModel(ImagePart.class, topic.getImage()));
        }
        return list.toArray();
    }

    private void addMarkers(ITopic topic, List<Object> list) {
        Set markerRefs = topic.getMarkerRefs();
        if (markerRefs.isEmpty()) {
            return;
        }
        ArrayList markerRefsToSort = new ArrayList(markerRefs);
        Collections.sort(markerRefsToSort, MARKER_REF_COMPARATOR);
        for (IMarkerRef ref : markerRefsToSort) {
            list.add(new ViewerModel(MarkerPart.class, ref));
        }
    }

    private void addIconTips(ITopic topic, List<Object> list) {
        list.addAll(this.topicInfoItemManager.getIconTips());
    }

    public IPart findAt(Point position) {
        IPart ret = super.findAt(position);
        if (ret != null && (ret == this.title || ret == this.numbering)) {
            if (this.containsPoint(position)) {
                return this;
            }
            ret = null;
        }
        return ret;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(ITopic.class)) {
            return adapter.cast(this.getTopic());
        }
        if (adapter == TitleTextPart.class || adapter == ITitleTextPart.class) {
            return adapter.cast(this.getTitle());
        }
        if (adapter == IBranchPart.class) {
            return adapter.cast(this.getOwnerBranch());
        }
        if (adapter == IActionRegistry.class) {
            return adapter.cast(this.getActionRegistry());
        }
        return super.getAdapter(adapter);
    }

    public IActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
            IViewer viewer = this.getSite().getViewer();
            if (viewer != null) {
                this.actionRegistry.setParent((IActionRegistry)viewer.getProperties().get("actions"));
            }
        }
        return this.actionRegistry;
    }

    @Override
    protected void registerCoreEvents(Object source, ICoreEventRegister register) {
        ITopic parent;
        super.registerCoreEvents(source, register);
        register.register("markerRefAdd");
        register.register("markerRefRemove");
        if (source instanceof ITopic && (parent = ((ITopic)source).getParent()) != null) {
            register.setNextSourceFrom((Object)parent);
            register.register("topicAdd");
            register.register("topicRemove");
            INumbering parentNumbering = parent.getNumbering();
            register.setNextSourceFrom((Object)parentNumbering);
            register.register("numberingFormat");
            register.register("numberingPrefix");
            register.register("numberingSuffix");
            register.register("parentNumberingPrepending");
            register.register("numberingSeparator");
            register.register("numberingDepth");
        }
        IImage imageModel = this.getTopic().getImage();
        register.setNextSourceFrom((Object)imageModel);
        register.register("imageSource");
    }

    @Override
    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("markerRefAdd".equals(type) || "markerRefRemove".equals(type)) {
            this.refresh();
        } else if ("imageSource".equals(type)) {
            boolean hadNoImage;
            boolean hasNoImage = event.getNewValue() == null;
            boolean bl = hadNoImage = event.getOldValue() == null;
            if (hasNoImage && !hadNoImage || hadNoImage && !hasNoImage) {
                this.refresh();
            }
        } else if ("topicAdd".equals(type) || "topicRemove".equals(type)) {
            if ("attached".equals(event.getData())) {
                this.treeRefresh();
            }
        } else if ("numberingFormat".equals(type) || "numberingPrefix".equals(type) || "numberingSuffix".equals(type) || "parentNumberingPrepending".equals(type) || "numberingSeparator".equals(type) || "numberingDepth".equals(type)) {
            this.treeRefresh();
        } else {
            super.handleCoreEvent(event);
        }
    }

    protected void treeRefresh() {
        this.refresh();
        IBranchPart branch = this.getOwnerBranch();
        if (branch != null) {
            ITopicPart child;
            for (IBranchPart sub : branch.getSubBranches()) {
                child = sub.getTopicPart();
                if (!(child instanceof TopicPart)) continue;
                ((TopicPart)child).treeRefresh();
            }
            for (IBranchPart sub : branch.getCalloutBranches()) {
                child = sub.getTopicPart();
                if (!(child instanceof TopicPart)) continue;
                ((TopicPart)child).treeRefresh();
            }
        }
    }

    @Override
    protected void onActivated() {
        super.onActivated();
        for (IIconTipContributor iconTipCont : IconTipContributorManager.getInstance().getContributors()) {
            iconTipCont.topicActivated(this);
        }
        for (IInfoItemContributor infoItemCont : InfoItemContributorManager.getInstance().getContributors()) {
            infoItemCont.topicActivated(this);
        }
        for (IInfoItemContributor infoItemCont : InfoItemContributorManager.getInstance().getBothContributors()) {
            infoItemCont.topicActivated(this);
        }
    }

    @Override
    protected void onDeactivated() {
        for (IInfoItemContributor infoItemCont : InfoItemContributorManager.getInstance().getContributors()) {
            infoItemCont.topicDeactivated(this);
        }
        for (IInfoItemContributor infoItemCont : InfoItemContributorManager.getInstance().getBothContributors()) {
            infoItemCont.topicDeactivated(this);
        }
        for (IIconTipContributor iconTipCont : IconTipContributorManager.getInstance().getContributors()) {
            iconTipCont.topicDeactivated(this);
        }
        this.topicInfoItemManager.topicDeactivated();
        super.onDeactivated();
    }

    @Override
    public void refresh() {
        BranchPart branch;
        super.refresh();
        for (IIconTipPart iconTip : this.getIconTips()) {
            iconTip.refresh();
        }
        if (this.getParent() instanceof BranchPart && (branch = (BranchPart)this.getParent()).getInfoPart() != null) {
            branch.getInfoPart().refresh();
        }
    }

    @Override
    public void update() {
        BranchPart branch;
        super.update();
        for (IIconTipPart iconTip : this.getIconTips()) {
            iconTip.update();
        }
        if (this.getParent() instanceof BranchPart && (branch = (BranchPart)this.getParent()).getInfoPart() != null) {
            branch.getInfoPart().update();
        }
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.title != null) {
            this.title.update();
        }
        if (this.numbering != null) {
            this.numbering.update();
        }
        if (this.image != null) {
            this.image.update();
        }
    }

    @Override
    protected void fillSourceConnections(List<IConnectionPart> list) {
        ISheetPart sheet;
        IViewer viewer = this.getSite().getViewer();
        if (viewer != null && (sheet = (ISheetPart)viewer.getAdapter(ISheetPart.class)) != null) {
            String id = this.getTopic().getId();
            for (IRelationshipPart rel : sheet.getRelationships()) {
                IRelationship r = rel.getRelationship();
                if (r == null || !id.equals(r.getEnd1Id())) continue;
                list.add(rel);
            }
        }
    }

    @Override
    protected void fillTargetConnections(List<IConnectionPart> list) {
        ISheetPart sheet;
        IViewer viewer = this.getSite().getViewer();
        if (viewer != null && (sheet = (ISheetPart)viewer.getAdapter(ISheetPart.class)) != null) {
            String id = this.getTopic().getId();
            for (IRelationshipPart rel : sheet.getRelationships()) {
                IRelationship r = rel.getRelationship();
                if (r == null || !id.equals(r.getEnd2Id())) continue;
                list.add(rel);
            }
        }
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.setAccessible((IAccessible)new TopicAccessible(this));
    }

    protected void addChild(IPart child, int index) {
        super.addChild(child, index);
        this.update();
    }

    protected void removeChild(IPart child) {
        super.removeChild(child);
        this.update();
    }

    protected void reorderChild(IPart child, int index) {
        super.reorderChild(child, index);
        if (this.getMarkers().contains(child)) {
            this.sorter.sort(this.getMarkers());
        } else if (this.getIconTips().contains(child)) {
            this.sorter.sort(this.getIconTips());
        }
        this.update();
    }

    protected void addChildView(IPart child, int index) {
        super.addChildView(child, index);
        if (this.getFigure() instanceof ITitledFigure && child instanceof ITitleTextPart) {
            ((ITitledFigure)this.getFigure()).setTitle(((ITitleTextPart)child).getTextFigure());
        }
    }

    protected void removeChildView(IPart child) {
        super.removeChildView(child);
        if (this.getFigure() instanceof ITitledFigure && child instanceof ITitleTextPart) {
            ((ITitledFigure)this.getFigure()).setTitle(null);
        }
    }

    @Override
    public IAnchor getSourceAnchor(IGraphicalPart connection) {
        return this.getTopicAnchor();
    }

    @Override
    public IAnchor getTargetAnchor(IGraphicalPart connection) {
        return this.getTopicAnchor();
    }

    protected IAnchor getTopicAnchor() {
        if (this.anchor == null) {
            this.anchor = new DecoratedAnchor(this.getFigure());
            if (this.anchorListener == null) {
                this.anchorListener = new IAnchorListener(){

                    public void anchorMoved(IAnchor anchor) {
                        TopicPart.this.topicAnchorMoved();
                    }
                };
            }
            this.anchor.addAnchorListener(this.anchorListener);
        }
        return this.anchor;
    }

    private void topicAnchorMoved() {
        IBranchPart branch = this.getOwnerBranch();
        if (branch != null) {
            branch.getConnections().rerouteAll(branch.getFigure());
            branch.getCalloutConnections().rerouteAll(branch.getFigure());
            IBranchPart parentBranch = branch.getParentBranch();
            if (parentBranch != null) {
                IDecoration decoration = null;
                decoration = "calloutBranch".equals(branch.getBranchType()) ? parentBranch.getCalloutConnections().getDecoration(branch.getBranchIndex()) : parentBranch.getConnections().getDecoration(branch.getBranchIndex());
                if (decoration instanceof IConnectionDecoration) {
                    ((IConnectionDecoration)decoration).reroute(parentBranch.getFigure());
                }
            }
        }
    }

    @Override
    protected IFigure getShadowSource() {
        return this.getFigure();
    }

    @Override
    public String getNumberingText() {
        return MindMapUtils.getNumberingText(this.getTopic(), null, null);
    }

    @Override
    public String getFullNumberingText() {
        return MindMapUtils.getFullNumberingText(this.getTopic(), null, null);
    }
}

