/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.protocols;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.internal.protocols.FilePathParser;
import org.xmind.ui.mindmap.IHyperlinked;
import org.xmind.ui.mindmap.IProtocol;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class FileProtocol
implements IProtocol {
    @Override
    public IAction createOpenHyperlinkAction(Object context, String uri) {
        IWorkbenchWindow window = FileProtocol.getWindow(context);
        String path = FilePathParser.toPath(uri);
        String absolutePath = FileProtocol.getAbsolutePath(context, path);
        File file = new File(absolutePath);
        ImageDescriptor image = MindMapUI.getImages().getFileIcon(absolutePath, true);
        if (image == null) {
            image = file.isDirectory() ? MindMapUI.getImages().get("fldr_obj.gif", true) : MindMapUI.getImages().get("unknownfile.gif", true);
        }
        String text = file.isDirectory() ? MindMapMessages.FileProtocol_OpenFolder_text : MindMapMessages.FileProtocol_OpenFile_text;
        OpenFileAction action = new OpenFileAction(window, absolutePath);
        action.setText(text);
        action.setImageDescriptor(image);
        action.setToolTipText(absolutePath);
        return action;
    }

    public static String getAbsolutePath(Object context, String path) {
        if (FilePathParser.isPathRelative(path)) {
            IWorkbook workbook = MindMapUtils.findWorkbook(context);
            if (workbook != null) {
                String base = null;
                URI fileURI = FileProtocol.getFileURIFrom(workbook);
                if (fileURI != null && URIUtil.isFileURI((URI)fileURI)) {
                    base = URIUtil.toFile((URI)fileURI).getAbsolutePath();
                }
                if (base != null && (base = new File(base).getParent()) != null) {
                    return FilePathParser.toAbsolutePath(base, path);
                }
            }
            return FilePathParser.toAbsolutePath(FilePathParser.ABSTRACT_FILE_BASE, path);
        }
        return path;
    }

    private static URI getFileURIFrom(IWorkbook workbook) {
        IWorkbenchPage[] pages;
        IWorkbenchWindow[] windows;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null && (windows = workbench.getWorkbenchWindows()) != null && windows.length != 0) {
            window = windows[0];
        }
        if (window == null) {
            return null;
        }
        IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference[] ers;
            IWorkbenchPage wp = iWorkbenchPageArray[n2];
            IEditorReference[] iEditorReferenceArray = ers = wp.getEditorReferences();
            int n3 = ers.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbook w;
                IEditorReference er = iEditorReferenceArray[n4];
                IEditorInput editorInput = null;
                try {
                    editorInput = er.getEditorInput();
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                if (editorInput != null && workbook.equals(w = (IWorkbook)editorInput.getAdapter(IWorkbook.class))) {
                    return (URI)editorInput.getAdapter(URI.class);
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private static IWorkbenchWindow getWindow(Object context) {
        if (context instanceof IAdaptable) {
            Object adapter = ((IAdaptable)context).getAdapter(IWorkbenchWindow.class);
            if (adapter == null) {
                adapter = ((IAdaptable)context).getAdapter(IEditorPart.class);
                if (adapter == null) {
                    adapter = ((IAdaptable)context).getAdapter(IWorkbenchPart.class);
                }
                if (adapter instanceof IWorkbenchPart) {
                    adapter = ((IWorkbenchPart)adapter).getSite().getWorkbenchWindow();
                }
            }
            if (adapter instanceof IWorkbenchWindow) {
                return (IWorkbenchWindow)adapter;
            }
        }
        if (context instanceof IWorkbenchWindow) {
            return (IWorkbenchWindow)context;
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    @Override
    public boolean isHyperlinkModifiable(Object source, String uri) {
        return true;
    }

    private static class OpenFileAction
    extends Action
    implements IHyperlinked {
        private IWorkbenchWindow window;
        private String path;

        public OpenFileAction(IWorkbenchWindow window, String path) {
            this.window = window;
            this.path = path;
        }

        public void run() {
            MME.launch(this.window, this.path, new File(this.path).getName());
        }

        @Override
        public String getHyperlink() {
            return this.path;
        }
    }
}

