/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.internal.legacy;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import net.xmind.signin.XMindNet;
import net.xmind.verify.internal.Messages;
import net.xmind.verify.internal.Validity;
import net.xmind.verify.internal.legacy.LegacyValidity;
import net.xmind.verify.internal.legacy.XMindLicenseVerifier;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.xmind.core.net.util.LinkUtils;
import org.xmind.ui.dialogs.Notification;

public class LegacyLicenseVerifierUtil {
    public static final String PREF_SHOW_LEGACY_TIP = "Legacy";

    private LegacyLicenseVerifierUtil() {
    }

    public static IStatus verifyLicenseKey(String licenseKey) {
        int version;
        if (licenseKey != null && LegacyValidity.LegacyVersion.isLegacyVersion(version = new XMindLicenseVerifier().verifyLicenseKey(licenseKey))) {
            return LegacyLicenseVerifierUtil.createLegacyValidity(version);
        }
        return LegacyLicenseVerifierUtil.createInvalidValidity();
    }

    private static IStatus createInvalidValidity() {
        return new Validity(0, "net.xmind.verify", 8192, null, null, null, null);
    }

    private static IStatus createLegacyValidity(int legacyVersion) {
        return new LegacyValidity(legacyVersion);
    }

    public static void checkLicenseKey() {
        String builtInLicense = System.getProperty("org.xmind.product.license.key");
        String builtInEmail = System.getProperty("org.xmind.product.license.registeredEmail");
        if (builtInLicense != null && builtInEmail != null) {
            return;
        }
        Properties prop = LegacyLicenseVerifierUtil.loadLegacyLocalData();
        if (prop == null || !LegacyLicenseVerifierUtil.showLegacyTip()) {
            return;
        }
        String licenseKey = prop.getProperty("WalkingInTheMorning");
        IStatus validity = LegacyLicenseVerifierUtil.verifyLicenseKey(licenseKey);
        if (LegacyLicenseVerifierUtil.checkValid(validity, 16384) && validity instanceof LegacyValidity) {
            int legacyVersion = ((LegacyValidity)validity).getLegacyVersion();
            LegacyLicenseVerifierUtil.doShowNotification(legacyVersion);
        }
    }

    private static Properties loadLegacyLocalData() {
        File localFileDir = LegacyLicenseVerifierUtil.getLocalFileDir();
        if (localFileDir != null && localFileDir.isDirectory() && localFileDir.exists()) {
            File[] localFiles;
            File currentVersionPoemFile = new File(localFileDir, ".poem37");
            if (currentVersionPoemFile.exists() && currentVersionPoemFile.isFile()) {
                Properties store = new Properties();
                try {
                    BufferedInputStream stream = new BufferedInputStream(new FileInputStream(currentVersionPoemFile), 1024);
                    try {
                        store.load(stream);
                    }
                    finally {
                        ((InputStream)stream).close();
                    }
                    String licenseEmail = store.getProperty("TimeSmilesInMyHand");
                    String licenseKey = store.getProperty("WalkingInTheMorning");
                    if (licenseEmail != null && licenseKey != null || "".equals(licenseEmail) && "".equals(licenseKey)) {
                        return null;
                    }
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            if ((localFiles = localFileDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name != null && name.startsWith(".poem") && !name.equals(".poem37");
                }
            })).length > 0) {
                File stateFile = localFiles[0];
                int i = 1;
                while (i < localFiles.length) {
                    String name = localFiles[i].getName();
                    if (stateFile.getName().compareTo(name) < 0) {
                        stateFile = localFiles[i];
                    }
                    ++i;
                }
                if (stateFile != null && stateFile.exists() && stateFile.isFile()) {
                    Properties store = new Properties();
                    try {
                        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(stateFile), 1024);
                        try {
                            store.load(stream);
                        }
                        finally {
                            ((InputStream)stream).close();
                        }
                        String licenseEmail = store.getProperty("TimeSmilesInMyHand");
                        String licenseKey = store.getProperty("WalkingInTheMorning");
                        LegacyLicenseVerifierUtil.saveState(store, "WalkingInTheMorning", Cryptus.decrypt(licenseKey, licenseEmail));
                        return store;
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    private static boolean showLegacyTip() {
        Properties store = LegacyLicenseVerifierUtil.loadLegacyFile();
        if (store == null) {
            return true;
        }
        return !"false".equals(store.getProperty(PREF_SHOW_LEGACY_TIP));
    }

    private static Properties loadLegacyFile() {
        File stateFile = LegacyLicenseVerifierUtil.getLegacyFile();
        if (stateFile != null && stateFile.exists() && stateFile.isFile()) {
            Properties store = new Properties();
            try {
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(stateFile), 1024);
                try {
                    store.load(stream);
                }
                finally {
                    ((InputStream)stream).close();
                }
                return store;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static File getLegacyFile() {
        return LegacyLicenseVerifierUtil.getLocalFile(".legacy");
    }

    private static File getLocalFileDir() {
        Bundle bundle = Platform.getBundle((String)"net.xmind.verify");
        if (bundle != null) {
            File root = Platform.getStateLocation((Bundle)bundle).toFile();
            return root;
        }
        return null;
    }

    private static File getLocalFile(String name) {
        Bundle bundle = Platform.getBundle((String)"net.xmind.verify");
        if (bundle != null) {
            File root = Platform.getStateLocation((Bundle)bundle).toFile();
            return new File(root, name);
        }
        return null;
    }

    private static void saveState(Properties store, String name, String value) {
        if (value != null && !"".equals(value)) {
            store.setProperty(name, value);
        } else {
            store.remove(name);
        }
    }

    private static void saveLegacyState(boolean showLegacyTip) {
        File stateFile = LegacyLicenseVerifierUtil.getLegacyFile();
        if (stateFile == null) {
            return;
        }
        Properties store = new Properties();
        LegacyLicenseVerifierUtil.saveState(store, PREF_SHOW_LEGACY_TIP, showLegacyTip ? "true" : "false");
        try {
            FileOutputStream stream = new FileOutputStream(stateFile);
            try {
                store.store(stream, "Awakening Gatha, Deena Metzger");
            }
            finally {
                stream.close();
            }
        }
        catch (IOException iOException) {}
    }

    private static boolean checkValid(IStatus status, int requiredStatus) {
        return status != null && LegacyLicenseVerifierUtil.hasValidity(status, requiredStatus);
    }

    private static boolean hasValidity(IStatus status, int code) {
        return (status.getCode() & code) != 0;
    }

    private static void doShowNotification(final int legacyVersion) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final IWorkbench wb = workbench;
        Display display = wb.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                Shell shell = window.getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                Action okAction = new Action(){

                    public void run() {
                        LegacyLicenseVerifierUtil.saveLegacyState(false);
                        XMindNet.gotoURL((boolean)true, (String)LinkUtils.getLinkByLanguage((boolean)true, (boolean)true, (String)"/xmind/buy/pricing/"), (Object[])new Object[0]);
                    }
                };
                okAction.setText(Messages.LegacyNotification_OK_text);
                String text = LegacyLicenseVerifierUtil.getNotificationText(legacyVersion);
                if (text == null) {
                    return;
                }
                Notification popup = new Notification(window.getShell(), text, (IAction)okAction, null, true, true, true, null);
                popup.setDuration(-1);
                popup.open();
                popup.setCloseButtonListener(4, new Listener(){

                    public void handleEvent(Event event) {
                        LegacyLicenseVerifierUtil.saveLegacyState(false);
                    }
                });
            }
        });
    }

    private static String getNotificationText(int legacyVersion) {
        if (LegacyValidity.LegacyVersion.XMIND_2012.getValue() == legacyVersion) {
            return NLS.bind((String)Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage, (Object)"XMind 2012");
        }
        if (LegacyValidity.LegacyVersion.XMIND_2013_PRO.getValue() == legacyVersion) {
            return NLS.bind((String)Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage, (Object)"XMind 2013 Pro");
        }
        if (LegacyValidity.LegacyVersion.XMIND_2013_PLUS.getValue() == legacyVersion) {
            return NLS.bind((String)Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage, (Object)"XMind 2013 Plus");
        }
        if (LegacyValidity.LegacyVersion.XMIND_6_PRO.getValue() == legacyVersion) {
            return NLS.bind((String)Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage, (Object)"XMind 6 Pro");
        }
        if (LegacyValidity.LegacyVersion.XMIND_6_PLUS.getValue() == legacyVersion) {
            return NLS.bind((String)Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage, (Object)"XMind 6 Plus");
        }
        if (LegacyValidity.LegacyVersion.XMIND_7_PRO.getValue() == legacyVersion) {
            return NLS.bind((String)Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage, (Object)"XMind 7 Pro");
        }
        if (LegacyValidity.LegacyVersion.XMIND_7_PLUS.getValue() == legacyVersion) {
            return NLS.bind((String)Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage, (Object)"XMind 7 Plus");
        }
        return null;
    }

    private static class Cryptus {
        private Cryptus() {
        }

        protected static String decrypt(String dest, String key) {
            if (dest == null || "".equals(dest) || key == null || "".equals(key)) {
                return dest;
            }
            try {
                byte[] keyBytes = key.getBytes();
                byte[] destBytes = Hex.decodeHex((char[])dest.toCharArray());
                byte[] srcBytes = Cryptus.encdec(keyBytes, destBytes, 2);
                return new String(srcBytes);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private static byte[] encdec(byte[] key, byte[] data, int cipherMode) throws GeneralSecurityException {
            MessageDigest hash = MessageDigest.getInstance("MD5");
            byte[] keyDigest = hash.digest(key);
            DESKeySpec keySpec = new DESKeySpec(keyDigest, keyDigest.length - 8);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(keySpec);
            IvParameterSpec ivParam = new IvParameterSpec(keyDigest, 0, 8);
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            cipher.init(cipherMode, (Key)secretKey, ivParam);
            return cipher.doFinal(data);
        }
    }
}

