/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.org.freehep.graphics2d.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.xmind.org.freehep.graphics2d.font.CharTable;
import org.xmind.org.freehep.graphics2d.font.FontEncoder;
import org.xmind.org.freehep.graphics2d.font.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontUtilities {
    private static final Properties windowsFonts = new Properties();
    private static final CharTable[] STANDARD_CHAR_TABLES;
    private static final Font[] STANDARD_FONT;

    static {
        String arial = "Arial";
        windowsFonts.setProperty("Dialog", arial);
        windowsFonts.setProperty("DialogInput", "Courier New");
        windowsFonts.setProperty("Serif", "Times New Roman");
        windowsFonts.setProperty("SansSerif", arial);
        windowsFonts.setProperty("Monospaced", "Courier New");
        windowsFonts.setProperty("Courier", "Courier New");
        windowsFonts.setProperty("Helvetica", arial);
        windowsFonts.setProperty("Times-Roman", "Times New Roman");
        windowsFonts.setProperty("TimesRoman", "Times New Roman");
        windowsFonts.setProperty("Times", "Times New Roman");
        windowsFonts.setProperty("Symbol", "Arial Unicode MS");
        windowsFonts.setProperty("ZapfDingbats", "Arial Unicode MS");
        CharTable[] charTableArray = new CharTable[3];
        charTableArray[1] = Lookup.getInstance().getTable("Symbol");
        charTableArray[2] = Lookup.getInstance().getTable("Zapfdingbats");
        STANDARD_CHAR_TABLES = charTableArray;
        Font[] fontArray = new Font[3];
        fontArray[1] = new Font("Symbol", 0, 10);
        fontArray[2] = new Font("ZapfDingbats", 0, 10);
        STANDARD_FONT = fontArray;
    }

    private FontUtilities() {
    }

    public static List<String> getAllAvailableFonts() {
        return Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
    }

    public static String getWindowsFontName(String fontName) {
        return windowsFonts.getProperty(fontName, fontName);
    }

    public static String getEncodedString(String string, String tableName) {
        return FontEncoder.getEncodedString(string, tableName);
    }

    public static String getEncodedString(String string, CharTable charTable) {
        return FontEncoder.getEncodedString(string, charTable);
    }

    public static void showString(Font font, String string, CharTable latinTable, ShowString device) throws IOException {
        if (latinTable == null) {
            throw new RuntimeException("FontUtilities.showString(...): latinTable cannot be 'null'");
        }
        FontUtilities.STANDARD_FONT[0] = font;
        FontUtilities.STANDARD_FONT[1] = new Font("Symbol", 0, font.getSize());
        FontUtilities.STANDARD_FONT[2] = new Font("ZapfDingbats", 0, font.getSize());
        FontUtilities.STANDARD_CHAR_TABLES[0] = latinTable;
        char[] chars = string.toCharArray();
        String out = "";
        int lastTable = 0;
        int i = 0;
        while (i < chars.length) {
            int table = lastTable;
            char encoding = (char)STANDARD_CHAR_TABLES[table].toEncoding(chars[i]);
            if (encoding == '\u0000') {
                table = -1;
                do {
                    if (++table == lastTable) continue;
                    encoding = (char)STANDARD_CHAR_TABLES[table].toEncoding(chars[i]);
                } while (encoding == '\u0000' && table < STANDARD_CHAR_TABLES.length - 1);
            }
            if (encoding == '\u0000') {
                table = lastTable;
            }
            if (table != lastTable && !out.equals("")) {
                device.showString(STANDARD_FONT[lastTable], out);
                out = "";
            }
            out = String.valueOf(out) + encoding;
            lastTable = table;
            ++i;
        }
        device.showString(STANDARD_FONT[lastTable], out);
    }

    public static Hashtable<TextAttribute, Object> getAttributes(Font font) {
        Hashtable<TextAttribute, Object> result = new Hashtable<TextAttribute, Object>(7, 0.9f);
        result.put(TextAttribute.TRANSFORM, font.getTransform());
        result.put(TextAttribute.FAMILY, font.getName());
        result.put(TextAttribute.SIZE, new Float(font.getSize2D()));
        result.put(TextAttribute.WEIGHT, (font.getStyle() & 1) != 0 ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
        result.put(TextAttribute.POSTURE, (font.getStyle() & 2) != 0 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        result.put(TextAttribute.SUPERSCRIPT, new Integer(0));
        result.put(TextAttribute.WIDTH, new Float(1.0f));
        return result;
    }

    public static interface ShowString {
        public void showString(Font var1, String var2) throws IOException;
    }
}

