/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.geometry.Region;
import net.coobird.thumbnailator.resizers.FixedResizerFactory;
import net.coobird.thumbnailator.resizers.Resizer;
import net.coobird.thumbnailator.resizers.ResizerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbnailParameter {
    public static final String ORIGINAL_FORMAT = null;
    public static final String DETERMINE_FORMAT = "\u0000";
    public static final String DEFAULT_FORMAT_TYPE = null;
    public static final float DEFAULT_QUALITY = Float.NaN;
    public static final int ORIGINAL_IMAGE_TYPE = -1;
    public static final int DEFAULT_IMAGE_TYPE = 2;
    private final Dimension thumbnailSize;
    private final double widthScalingFactor;
    private final double heightScalingFactor;
    private final boolean keepAspectRatio;
    private final String outputFormat;
    private final String outputFormatType;
    private final float outputQuality;
    private final int imageType;
    private final List<ImageFilter> filters;
    private final ResizerFactory resizerFactory;
    private final Region sourceRegion;
    private final boolean fitWithinDimensions;
    private final boolean useExifOrientation;

    private ThumbnailParameter(Dimension thumbnailSize, double widthScalingFactor, double heightScalingFactor, Region sourceRegion, boolean keepAspectRatio, String outputFormat, String outputFormatType, float outputQuality, int imageType, List<ImageFilter> filters, ResizerFactory resizerFactory, boolean fitWithinDimensions, boolean useExifOrientation) {
        this.thumbnailSize = thumbnailSize;
        this.widthScalingFactor = widthScalingFactor;
        this.heightScalingFactor = heightScalingFactor;
        this.keepAspectRatio = keepAspectRatio;
        this.sourceRegion = sourceRegion;
        this.outputFormat = outputFormat;
        this.outputFormatType = outputFormatType;
        if ((outputQuality < 0.0f || outputQuality > 1.0f) && !Float.isNaN(outputQuality)) {
            throw new IllegalArgumentException("The output quality must be between 0.0f and 1.0f, or Float.NaN to use the default compression quality of codec being used.");
        }
        this.outputQuality = outputQuality;
        this.imageType = imageType;
        this.filters = filters == null ? new ArrayList<ImageFilter>() : new ArrayList<ImageFilter>(filters);
        if (resizerFactory == null) {
            throw new IllegalArgumentException("Resizer cannot be null");
        }
        this.resizerFactory = resizerFactory;
        this.fitWithinDimensions = fitWithinDimensions;
        this.useExifOrientation = useExifOrientation;
    }

    private void validateThumbnailSize() {
        if (this.thumbnailSize == null) {
            throw new IllegalArgumentException("Thumbnail size cannot be null.");
        }
        if (this.thumbnailSize.width < 0 || this.thumbnailSize.height < 0) {
            throw new IllegalArgumentException("Thumbnail dimensions must be greater than 0.");
        }
    }

    private void validateScalingFactor() {
        if (this.widthScalingFactor <= 0.0 || this.heightScalingFactor <= 0.0) {
            throw new IllegalArgumentException("Scaling factor is less than or equal to 0.");
        }
        if (Double.isNaN(this.widthScalingFactor) || Double.isInfinite(this.widthScalingFactor)) {
            throw new IllegalArgumentException("Scaling factor must be a rational number.");
        }
        if (Double.isNaN(this.heightScalingFactor) || Double.isInfinite(this.heightScalingFactor)) {
            throw new IllegalArgumentException("Scaling factor must be a rational number.");
        }
    }

    public ThumbnailParameter(Dimension thumbnailSize, Region sourceRegion, boolean keepAspectRatio, String outputFormat, String outputFormatType, float outputQuality, int imageType, List<ImageFilter> filters, Resizer resizer, boolean fitWithinDimensions, boolean useExifOrientation) {
        this(thumbnailSize, Double.NaN, Double.NaN, sourceRegion, keepAspectRatio, outputFormat, outputFormatType, outputQuality, imageType, filters, new FixedResizerFactory(resizer), fitWithinDimensions, useExifOrientation);
        this.validateThumbnailSize();
    }

    public ThumbnailParameter(double widthScalingFactor, double heightScalingFactor, Region sourceRegion, boolean keepAspectRatio, String outputFormat, String outputFormatType, float outputQuality, int imageType, List<ImageFilter> filters, Resizer resizer, boolean fitWithinDimensions, boolean useExifOrientation) {
        this(null, widthScalingFactor, heightScalingFactor, sourceRegion, keepAspectRatio, outputFormat, outputFormatType, outputQuality, imageType, filters, new FixedResizerFactory(resizer), fitWithinDimensions, useExifOrientation);
        this.validateScalingFactor();
    }

    public ThumbnailParameter(Dimension thumbnailSize, Region sourceRegion, boolean keepAspectRatio, String outputFormat, String outputFormatType, float outputQuality, int imageType, List<ImageFilter> filters, ResizerFactory resizerFactory, boolean fitWithinDimensions, boolean useExifOrientation) {
        this(thumbnailSize, Double.NaN, Double.NaN, sourceRegion, keepAspectRatio, outputFormat, outputFormatType, outputQuality, imageType, filters, resizerFactory, fitWithinDimensions, useExifOrientation);
        this.validateThumbnailSize();
    }

    public ThumbnailParameter(double widthScalingFactor, double heightScalingFactor, Region sourceRegion, boolean keepAspectRatio, String outputFormat, String outputFormatType, float outputQuality, int imageType, List<ImageFilter> filters, ResizerFactory resizerFactory, boolean fitWithinDimensions, boolean useExifOrientation) {
        this(null, widthScalingFactor, heightScalingFactor, sourceRegion, keepAspectRatio, outputFormat, outputFormatType, outputQuality, imageType, filters, resizerFactory, fitWithinDimensions, useExifOrientation);
        this.validateScalingFactor();
    }

    public Dimension getSize() {
        if (this.thumbnailSize != null) {
            return (Dimension)this.thumbnailSize.clone();
        }
        return null;
    }

    public double getWidthScalingFactor() {
        return this.widthScalingFactor;
    }

    public double getHeightScalingFactor() {
        return this.heightScalingFactor;
    }

    public int getType() {
        return this.imageType;
    }

    public boolean isKeepAspectRatio() {
        return this.keepAspectRatio;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String getOutputFormatType() {
        return this.outputFormatType;
    }

    public float getOutputQuality() {
        return this.outputQuality;
    }

    public List<ImageFilter> getImageFilters() {
        return this.filters;
    }

    public Resizer getResizer() {
        return this.resizerFactory.getResizer();
    }

    public ResizerFactory getResizerFactory() {
        return this.resizerFactory;
    }

    public boolean useOriginalImageType() {
        return this.imageType == -1;
    }

    public Region getSourceRegion() {
        return this.sourceRegion;
    }

    public boolean fitWithinDimenions() {
        return this.fitWithinDimensions;
    }

    public boolean useExifOrientation() {
        return this.useExifOrientation;
    }
}

