/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IStatus;
import org.xmind.ui.io.IDownloadTarget;

public class FileDownloadTarget
implements IDownloadTarget,
IDownloadTarget.IDownloadTarget2 {
    private String filePath;
    private String tempFilePath;

    public FileDownloadTarget(String filePath, boolean useTempPath) {
        this.filePath = filePath;
        this.tempFilePath = useTempPath ? String.valueOf(filePath) + ".tmp" : filePath;
    }

    @Override
    public String getPath() {
        return this.filePath;
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        File dir = new File(this.tempFilePath).getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        return new FileOutputStream(this.tempFilePath);
    }

    @Override
    public void afterDownload(IStatus status) {
        if (!status.isOK()) {
            new File(this.tempFilePath).delete();
        } else if (!this.filePath.equals(this.tempFilePath)) {
            new File(this.tempFilePath).renameTo(new File(this.filePath));
        }
    }
}

