/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.xmind.ui.viewers.ISliderContentProvider;

public abstract class AbstractSnapSliderContentProvider
implements ISliderContentProvider {
    protected static final double DEFAULT_TOLERANCE = 0.015;
    private SortedMap<Double, SnapData> snaps = new TreeMap<Double, SnapData>();

    protected void addSnap(double ratio, Object value) {
        this.addSnap(ratio, value, 0.015, -0.015);
    }

    protected void addSnap(double ratio, Object value, double positiveTolerance, double negativeTolerance) {
        this.snaps.put(ratio, new SnapData(value, positiveTolerance, negativeTolerance));
    }

    protected void addSnap(double ratio, Object value, double tolerance) {
        this.addSnap(ratio, value, tolerance, -tolerance);
    }

    protected void removeSnap(double ratio) {
        this.snaps.remove(ratio);
    }

    protected void clearSnaps() {
        this.snaps.clear();
    }

    @Override
    public double getRatio(Object input, Object value) {
        Double ratio = this.checkSnappedRatio(value);
        if (ratio != null) {
            return ratio;
        }
        return this.getOtherRatio(input, value);
    }

    protected Double checkSnappedRatio(Object value) {
        if (value != null) {
            for (Map.Entry<Double, SnapData> entry : this.snaps.entrySet()) {
                if (!value.equals(entry.getValue().value)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    protected abstract double getOtherRatio(Object var1, Object var2);

    @Override
    public Object getValue(Object input, double ratio) {
        Object value = this.checkSnappedValue(ratio);
        if (value != null) {
            return value;
        }
        return this.getOtherValue(input, ratio);
    }

    protected abstract Object getOtherValue(Object var1, double var2);

    protected Object checkSnappedValue(double ratio) {
        Map.Entry<Double, SnapData> next;
        Iterator<Map.Entry<Double, SnapData>> it = this.snaps.entrySet().iterator();
        Map.Entry<Double, SnapData> entry = next = it.hasNext() ? it.next() : null;
        if (next == null) {
            return null;
        }
        Map.Entry<Double, SnapData> prev = null;
        Map.Entry<Double, SnapData> current = null;
        do {
            prev = current;
            current = next;
            next = it.hasNext() ? it.next() : null;
            if (!this.isSnapped(ratio, current.getKey(), current.getValue().positiveTolerance, current.getValue().negativeTolerance, prev == null ? null : prev.getKey(), next == null ? null : next.getKey())) continue;
            return current.getValue().value;
        } while (next != null);
        return null;
    }

    private boolean isSnapped(double r, double r0, double t1, double t2, Double r1, Double r2) {
        double min = Math.max(r0 + t2, r1 == null ? 0.0 : r1);
        double max = Math.min(r0 + t1, r2 == null ? 1.0 : r2);
        return r == r0 || r > min && r < max;
    }

    private static class SnapData {
        Object value;
        double positiveTolerance;
        double negativeTolerance;

        public SnapData(Object value, double positiveTolerance, double negativeTolerance) {
            this.value = value;
            this.positiveTolerance = positiveTolerance;
            this.negativeTolerance = negativeTolerance;
        }
    }
}

