/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import javax.annotation.Nullable;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.BuildOperationTimeSupplier;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;

public class DefaultBuildOperationProgressEventEmitter
implements BuildOperationProgressEventEmitter {
    private final BuildOperationTimeSupplier clock;
    private final CurrentBuildOperationRef current;
    private final BuildOperationListener listener;

    public DefaultBuildOperationProgressEventEmitter(BuildOperationTimeSupplier clock, CurrentBuildOperationRef current, BuildOperationListener listener) {
        this.clock = clock;
        this.current = current;
        this.listener = listener;
    }

    @Override
    public void emit(@Nullable OperationIdentifier operationIdentifier, long timestamp, @Nullable Object details) {
        if (operationIdentifier == null) {
            throw new IllegalArgumentException("operationIdentifier is null");
        }
        this.doEmit(operationIdentifier, timestamp, details);
    }

    @Override
    public void emitNow(@Nullable OperationIdentifier operationIdentifier, @Nullable Object details) {
        this.emit(operationIdentifier, this.clock.getCurrentTime(), details);
    }

    @Override
    public void emitNowIfCurrent(Object details) {
        this.emitIfCurrent(this.clock.getCurrentTime(), details);
    }

    @Override
    public void emitIfCurrent(long time, Object details) {
        OperationIdentifier currentOperationIdentifier = this.current.getId();
        if (currentOperationIdentifier != null) {
            this.doEmit(currentOperationIdentifier, time, details);
        }
    }

    @Override
    public void emitNowForCurrent(Object details) {
        this.emitForCurrent(this.clock.getCurrentTime(), details);
    }

    private void emitForCurrent(long time, Object details) {
        OperationIdentifier currentOperationIdentifier = this.current.getId();
        if (currentOperationIdentifier == null) {
            throw new IllegalStateException("No current build operation");
        }
        this.doEmit(currentOperationIdentifier, time, details);
    }

    private void doEmit(OperationIdentifier operationIdentifier, long timestamp, @Nullable Object details) {
        this.listener.progress(operationIdentifier, new OperationProgressEvent(timestamp, details));
    }
}

