/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.AbstractLibrary;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.FileReference;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.gradle.plugins.ide.eclipse.model.UnresolvedLibrary;
import org.gradle.plugins.ide.eclipse.model.Variable;
import org.gradle.plugins.ide.eclipse.model.internal.EclipseClassPathUtil;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;
import org.gradle.plugins.ide.eclipse.model.internal.ProjectDependencyBuilder;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.resolver.GradleApiSourcesResolver;
import org.gradle.plugins.ide.internal.resolver.IdeDependencySet;
import org.gradle.plugins.ide.internal.resolver.IdeDependencyVisitor;
import org.gradle.plugins.ide.internal.resolver.UnresolvedIdeDependencyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseDependenciesCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EclipseDependenciesCreator.class);
    private final EclipseClasspath classpath;
    private final ProjectDependencyBuilder projectDependencyBuilder;
    private final ProjectComponentIdentifier currentProjectId;
    private final GradleApiSourcesResolver gradleApiSourcesResolver;
    private final boolean inferModulePath;

    public EclipseDependenciesCreator(EclipseClasspath classpath, IdeArtifactRegistry ideArtifactRegistry, GradleApiSourcesResolver gradleApiSourcesResolver, boolean inferModulePath) {
        this.classpath = classpath;
        this.projectDependencyBuilder = new ProjectDependencyBuilder(ideArtifactRegistry);
        this.currentProjectId = ((ProjectInternal)classpath.getProject()).getOwner().getComponentIdentifier();
        this.gradleApiSourcesResolver = gradleApiSourcesResolver;
        this.inferModulePath = inferModulePath;
    }

    public List<AbstractClasspathEntry> createDependencyEntries() {
        EclipseDependenciesVisitor visitor = new EclipseDependenciesVisitor(this.classpath.getProject());
        Set testConfigurations = (Set)this.classpath.getTestConfigurations().getOrElse(Collections.emptySet());
        new IdeDependencySet(this.classpath.getProject().getDependencies(), (JavaModuleDetector)((ProjectInternal)this.classpath.getProject()).getServices().get(JavaModuleDetector.class), this.classpath.getPlusConfigurations(), this.classpath.getMinusConfigurations(), this.inferModulePath, this.gradleApiSourcesResolver, testConfigurations).visit(visitor);
        return visitor.getDependencies();
    }

    private class EclipseDependenciesVisitor
    implements IdeDependencyVisitor {
        private final List<AbstractClasspathEntry> projects = new ArrayList<AbstractClasspathEntry>();
        private final List<AbstractClasspathEntry> modules = new ArrayList<AbstractClasspathEntry>();
        private final List<AbstractClasspathEntry> files = new ArrayList<AbstractClasspathEntry>();
        private final Multimap<String, String> pathToSourceSets = this.collectLibraryToSourceSetMapping();
        private final UnresolvedIdeDependencyHandler unresolvedIdeDependencyHandler = new UnresolvedIdeDependencyHandler();
        private final Project project;

        public EclipseDependenciesVisitor(Project project) {
            this.project = project;
        }

        @Override
        public boolean isOffline() {
            return EclipseDependenciesCreator.this.classpath.isProjectDependenciesOnly();
        }

        @Override
        public boolean downloadSources() {
            return EclipseDependenciesCreator.this.classpath.isDownloadSources();
        }

        @Override
        public boolean downloadJavaDoc() {
            return EclipseDependenciesCreator.this.classpath.isDownloadJavadoc();
        }

        @Override
        public void visitProjectDependency(ResolvedArtifactResult artifact, boolean testDependency, boolean asJavaModule) {
            Project artifactProject;
            ProjectComponentIdentifier componentIdentifier = (ProjectComponentIdentifier)artifact.getId().getComponentIdentifier();
            if (componentIdentifier.equals(EclipseDependenciesCreator.this.currentProjectId)) {
                return;
            }
            LibraryElements libraryElements = (LibraryElements)artifact.getVariant().getAttributes().getAttribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE);
            if (libraryElements == null || !libraryElements.getName().equals("jar")) {
                return;
            }
            ComponentArtifactIdentifier artifactId = artifact.getId();
            TaskDependency buildDependencies = null;
            if (artifactId instanceof ComponentArtifactMetadata) {
                buildDependencies = ((ComponentArtifactMetadata)artifactId).getBuildDependencies();
            }
            if (!asJavaModule && (artifactProject = this.project.findProject(componentIdentifier.getProjectPath())) != null) {
                asJavaModule = EclipseClassPathUtil.isInferModulePath(artifactProject);
            }
            this.projects.add(EclipseDependenciesCreator.this.projectDependencyBuilder.build(componentIdentifier, EclipseDependenciesCreator.this.classpath.getFileReferenceFactory().fromFile(artifact.getFile()), buildDependencies, testDependency, asJavaModule));
        }

        @Override
        public void visitModuleDependency(ResolvedArtifactResult artifact, Set<ResolvedArtifactResult> sources, Set<ResolvedArtifactResult> javaDoc, boolean testDependency, boolean asJavaModule) {
            File sourceFile = sources.isEmpty() ? null : sources.iterator().next().getFile();
            File javaDocFile = javaDoc.isEmpty() ? null : javaDoc.iterator().next().getFile();
            ModuleComponentIdentifier componentIdentifier = (ModuleComponentIdentifier)artifact.getId().getComponentIdentifier();
            ModuleVersionIdentifier moduleVersionIdentifier = DefaultModuleVersionIdentifier.newId((ModuleIdentifier)componentIdentifier.getModuleIdentifier(), (String)componentIdentifier.getVersion());
            this.modules.add(this.createLibraryEntry(artifact.getFile(), sourceFile, javaDocFile, EclipseDependenciesCreator.this.classpath, moduleVersionIdentifier, this.pathToSourceSets, testDependency, asJavaModule));
        }

        @Override
        public void visitFileDependency(ResolvedArtifactResult artifact, boolean testDependency) {
            this.files.add(this.createLibraryEntry(artifact.getFile(), null, null, EclipseDependenciesCreator.this.classpath, null, this.pathToSourceSets, testDependency, false));
        }

        @Override
        public void visitGradleApiDependency(ResolvedArtifactResult artifact, File sources, boolean testConfiguration) {
            this.files.add(this.createLibraryEntry(artifact.getFile(), sources, null, EclipseDependenciesCreator.this.classpath, null, this.pathToSourceSets, testConfiguration, false));
        }

        @Override
        public void visitUnresolvedDependency(UnresolvedDependencyResult unresolvedDependency) {
            File unresolvedFile = this.unresolvedIdeDependencyHandler.asFile(unresolvedDependency, this.project.getProjectDir());
            UnresolvedLibrary unresolvedLib = (UnresolvedLibrary)this.createUnresolvedLibraryEntry(unresolvedFile, EclipseDependenciesCreator.this.classpath, this.pathToSourceSets, false, false);
            unresolvedLib.setAttemptedSelector(unresolvedDependency.getAttempted());
            this.files.add(unresolvedLib);
            this.unresolvedIdeDependencyHandler.log(unresolvedDependency);
        }

        public List<AbstractClasspathEntry> getDependencies() {
            ArrayList dependencies = Lists.newArrayListWithCapacity((int)(this.projects.size() + this.modules.size() + this.files.size()));
            dependencies.addAll(this.projects);
            dependencies.addAll(this.modules);
            dependencies.addAll(this.files);
            return dependencies;
        }

        private Multimap<String, String> collectLibraryToSourceSetMapping() {
            LinkedHashMultimap pathToSourceSetNames = LinkedHashMultimap.create();
            Iterable<SourceSet> sourceSets = EclipseDependenciesCreator.this.classpath.getSourceSets();
            if (sourceSets == null) {
                return pathToSourceSetNames;
            }
            for (SourceSet sourceSet : sourceSets) {
                for (File f : this.collectClasspathFiles(sourceSet)) {
                    pathToSourceSetNames.put((Object)f.getAbsolutePath(), (Object)sourceSet.getName().replace(",", ""));
                }
            }
            return pathToSourceSetNames;
        }

        private Collection<File> collectClasspathFiles(SourceSet sourceSet) {
            ImmutableList.Builder result = ImmutableList.builder();
            try {
                result.addAll((Iterable)sourceSet.getRuntimeClasspath());
            }
            catch (Exception e) {
                LOGGER.debug("Failed to collect source sets for Eclipse dependencies", (Throwable)e);
            }
            return result.build();
        }

        private AbstractLibrary createLibraryEntry(File binary, File source, File javadoc, EclipseClasspath classpath, ModuleVersionIdentifier id, Multimap<String, String> pathToSourceSets, boolean testDependency, boolean asJavaModule) {
            return this.createLibraryEntry(binary, source, javadoc, classpath, id, pathToSourceSets, testDependency, asJavaModule, true);
        }

        private AbstractLibrary createUnresolvedLibraryEntry(File binary, EclipseClasspath classpath, Multimap<String, String> pathToSourceSets, boolean testDependency, boolean asJavaModule) {
            return this.createLibraryEntry(binary, null, null, classpath, null, pathToSourceSets, testDependency, asJavaModule, false);
        }

        private AbstractLibrary createLibraryEntry(File binary, File source, File javadoc, EclipseClasspath classpath, ModuleVersionIdentifier id, Multimap<String, String> pathToSourceSets, boolean testDependency, boolean asJavaModule, boolean resolved) {
            FileReferenceFactory referenceFactory = classpath.getFileReferenceFactory();
            FileReference binaryRef = referenceFactory.fromFile(binary);
            FileReference sourceRef = referenceFactory.fromFile(source);
            FileReference javadocRef = referenceFactory.fromFile(javadoc);
            AbstractLibrary out = binaryRef.isRelativeToPathVariable() ? new Variable(binaryRef) : (resolved ? new Library(binaryRef) : new UnresolvedLibrary(binaryRef));
            out.setJavadocPath(javadocRef);
            out.setSourcePath(sourceRef);
            out.setExported(false);
            out.setModuleVersion(id);
            Collection sourceSets = pathToSourceSets.get((Object)binary.getAbsolutePath());
            if (sourceSets != null) {
                out.getEntryAttributes().put("gradle_used_by_scope", Joiner.on((char)',').join((Iterable)sourceSets));
            }
            if (testDependency) {
                out.getEntryAttributes().put("test", "true");
            }
            if (asJavaModule) {
                out.getEntryAttributes().put("module", "true");
            }
            return out;
        }
    }
}

