/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.OrdinalGroup;
import org.gradle.execution.plan.OrdinalGroupFactory;
import org.gradle.execution.plan.OrdinalNode;

public class OrdinalNodeAccess {
    private final OrdinalGroupFactory ordinalGroups;
    private final Set<OrdinalNode> requiredNodes = new LinkedHashSet<OrdinalNode>();

    public OrdinalNodeAccess(OrdinalGroupFactory ordinalGroups) {
        this.ordinalGroups = ordinalGroups;
    }

    void addDestroyerNode(OrdinalGroup ordinal, LocalTaskNode destroyer, Consumer<Node> ordinalNodeConsumer) {
        ordinal.getDestroyerLocationsNode().addDependenciesFrom(destroyer);
        if (ordinal.getPrevious() != null) {
            OrdinalNode producerLocations = ordinal.getPrevious().getProducerLocationsNode();
            this.maybeSchedule(ordinalNodeConsumer, producerLocations);
            destroyer.addDependencySuccessor(producerLocations);
        }
    }

    void addProducerNode(OrdinalGroup ordinal, LocalTaskNode producer, Consumer<Node> ordinalNodeConsumer) {
        ordinal.getProducerLocationsNode().addDependenciesFrom(producer);
        if (ordinal.getPrevious() != null) {
            OrdinalNode destroyerLocations = ordinal.getPrevious().getDestroyerLocationsNode();
            this.maybeSchedule(ordinalNodeConsumer, destroyerLocations);
            producer.addDependencySuccessor(destroyerLocations);
        }
    }

    private void maybeSchedule(Consumer<Node> ordinalNodeConsumer, OrdinalNode node) {
        if (this.requiredNodes.add(node)) {
            node.require();
            for (Node successor : node.getDependencySuccessors()) {
                if (!(successor instanceof OrdinalNode)) continue;
                this.maybeSchedule(ordinalNodeConsumer, (OrdinalNode)successor);
            }
            ordinalNodeConsumer.accept(node);
        }
    }

    List<OrdinalGroup> getAllGroups() {
        return this.ordinalGroups.getAllGroups();
    }

    Collection<? extends Node> getAllNodes() {
        return this.requiredNodes;
    }

    public OrdinalGroup group(int ordinal) {
        return this.ordinalGroups.group(ordinal);
    }

    public void reset() {
        this.requiredNodes.clear();
        this.ordinalGroups.reset();
    }
}

