/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.kryo;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.internal.serialize.AbstractDecoder;
import org.gradle.internal.serialize.Decoder;

public class StringDeduplicatingKryoBackedDecoder
extends AbstractDecoder
implements Decoder,
Closeable {
    public static final int INITIAL_CAPACITY = 32;
    private final Input input;
    private final InputStream inputStream;
    private String[] strings;
    private long extraSkipped;

    public StringDeduplicatingKryoBackedDecoder(InputStream inputStream) {
        this(inputStream, 4096);
    }

    public StringDeduplicatingKryoBackedDecoder(InputStream inputStream, int bufferSize) {
        this.inputStream = inputStream;
        this.input = new Input(this.inputStream, bufferSize);
    }

    @Override
    protected int maybeReadBytes(byte[] buffer, int offset, int count) {
        return this.input.read(buffer, offset, count);
    }

    @Override
    protected long maybeSkip(long count) throws IOException {
        int remaining = this.input.limit() - this.input.position();
        if (remaining == 0) {
            long skipped = this.inputStream.skip(count);
            if (skipped > 0L) {
                this.extraSkipped += skipped;
            }
            return skipped;
        }
        if (count <= (long)remaining) {
            this.input.setPosition(this.input.position() + (int)count);
            return count;
        }
        this.input.setPosition(this.input.limit());
        return remaining;
    }

    private RuntimeException maybeEndOfStream(KryoException e) throws EOFException {
        if (e.getMessage().equals("Buffer underflow.")) {
            throw (EOFException)new EOFException().initCause(e);
        }
        throw e;
    }

    @Override
    public byte readByte() throws EOFException {
        try {
            return this.input.readByte();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public void readBytes(byte[] buffer, int offset, int count) throws EOFException {
        try {
            this.input.readBytes(buffer, offset, count);
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public long readLong() throws EOFException {
        try {
            return this.input.readLong();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public long readSmallLong() throws EOFException, IOException {
        try {
            return this.input.readLong(true);
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public int readInt() throws EOFException {
        try {
            return this.input.readInt();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public int readSmallInt() throws EOFException {
        try {
            return this.input.readInt(true);
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public short readShort() throws EOFException, IOException {
        try {
            return this.input.readShort();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public float readFloat() throws EOFException, IOException {
        try {
            return this.input.readFloat();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public double readDouble() throws EOFException, IOException {
        try {
            return this.input.readDouble();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public boolean readBoolean() throws EOFException {
        try {
            return this.input.readBoolean();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public String readString() throws EOFException {
        return this.readNullableString();
    }

    @Override
    public String readNullableString() throws EOFException {
        try {
            int idx = this.readInt();
            if (idx == -1) {
                return null;
            }
            if (this.strings == null) {
                this.strings = new String[32];
            }
            String string = null;
            if (idx >= this.strings.length) {
                String[] grow = new String[this.strings.length * 3 / 2];
                System.arraycopy(this.strings, 0, grow, 0, this.strings.length);
                this.strings = grow;
            } else {
                string = this.strings[idx];
            }
            if (string == null) {
                this.strings[idx] = string = this.input.readString();
            }
            return string;
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    public long getReadPosition() {
        return this.input.total() + this.extraSkipped;
    }

    @Override
    public void close() throws IOException {
        this.strings = null;
        this.input.close();
    }
}

