/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import com.google.common.annotations.VisibleForTesting;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.gradle.cache.HasCleanupAction;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.StatefulNextGenBuildCacheService;
import org.gradle.internal.time.Clock;
import org.h2.Driver;

public class H2BuildCacheService
implements StatefulNextGenBuildCacheService,
HasCleanupAction {
    private static final String DATABASE_NAME = "filestore";
    private final int removeUnusedEntriesAfterDays;
    private HikariDataSource dataSource;
    private final Clock clock;
    private final Path dbPath;
    private final int maxPoolSize;

    public H2BuildCacheService(Path dbPath, int maxPoolSize, int removeUnusedEntriesAfterDays, Clock clock) {
        this.dbPath = dbPath;
        this.maxPoolSize = maxPoolSize;
        this.clock = clock;
        this.removeUnusedEntriesAfterDays = removeUnusedEntriesAfterDays;
    }

    public void open() {
        HikariConfig hikariConfig = new HikariConfig();
        String h2JdbcUrl = H2BuildCacheService.getH2JdbcUrl(this.dbPath, "");
        hikariConfig.setJdbcUrl(h2JdbcUrl);
        hikariConfig.setDriverClassName(Driver.class.getName());
        hikariConfig.setUsername("sa");
        hikariConfig.setPassword("");
        hikariConfig.setCatalog(DATABASE_NAME);
        hikariConfig.setPoolName("filestore-pool");
        hikariConfig.setMaximumPoolSize(this.maxPoolSize);
        hikariConfig.setConnectionInitSql("select 1;");
        this.dataSource = new HikariDataSource(hikariConfig);
    }

    private static String getH2JdbcUrl(Path dbPath, String additionalConfiguration) {
        String configuration = "RETENTION_TIME=0;AUTO_COMPACT_FILL_RATE=0;COMPRESS=false;MODE=MySQL" + additionalConfiguration;
        return String.format("jdbc:h2:file:%s;%s;INIT=runscript from 'classpath:/h2/schemas/org.gradle.caching.local.internal.H2BuildCacheService.sql'", dbPath.resolve(DATABASE_NAME), configuration);
    }

    /*
     * Exception decompiling
     */
    public boolean contains(BuildCacheKey key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void store(BuildCacheKey key, StatefulNextGenBuildCacheService.NextGenWriter writer) throws BuildCacheException {
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement("insert ignore into filestore.lru(entry_key, entry_accessed) values (?, ?);insert ignore into filestore.catalog(entry_key, entry_size, entry_content) values (?, ?, ?);");
             InputStream input = writer.openStream();){
            stmt.setString(1, key.getHashCode());
            stmt.setLong(2, this.clock.getCurrentTime());
            stmt.setString(3, key.getHashCode());
            stmt.setLong(4, writer.getSize());
            stmt.setBinaryStream(5, input);
            stmt.executeUpdate();
        }
        catch (IOException | SQLException e) {
            throw new BuildCacheException("storing " + key, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public boolean remove(BuildCacheKey key) throws BuildCacheException {
        try (Connection conn = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement("delete from filestore.catalog where entry_key = ?");
                try {
                    stmt.setString(1, key.getHashCode());
                    boolean bl2 = bl = stmt.executeUpdate() > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new BuildCacheException("storing " + key, (Throwable)e);
        }
    }

    public void close() {
        this.dataSource.close();
    }

    public void cleanup() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
        new H2Janitor(this.dbPath, this.removeUnusedEntriesAfterDays, this.clock).cleanup();
    }

    private static class H2Janitor
    implements HasCleanupAction {
        private final Clock clock;
        private final int removeUnusedEntriesAfterDays;
        private final Path dbPath;

        public H2Janitor(Path dbPath, int removeUnusedEntriesAfterDays, Clock clock) {
            this.dbPath = dbPath;
            this.removeUnusedEntriesAfterDays = removeUnusedEntriesAfterDays;
            this.clock = clock;
        }

        public void cleanup() {
            this.deleteLruEntries();
        }

        private void deleteLruEntries() throws RuntimeException {
            try (Connection conn = this.getConnection();){
                long deleteThresholdMillis = this.clock.getCurrentTime() - TimeUnit.DAYS.toMillis(this.removeUnusedEntriesAfterDays);
                try (PreparedStatement stmt = conn.prepareStatement("delete from filestore.catalog where entry_key in (select entry_key FROM filestore.lru where entry_accessed < ?);delete from filestore.lru where entry_accessed < ?;");){
                    stmt.setLong(1, deleteThresholdMillis);
                    stmt.setLong(2, deleteThresholdMillis);
                    stmt.execute();
                }
                try (Statement stat = conn.createStatement();){
                    stat.execute("shutdown compact");
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to delete LRU entries", e);
            }
        }

        private Connection getConnection() throws SQLException {
            String additionalConfiguration = ";MAX_COMPACT_TIME=10000";
            String h2JdbcUrl = H2BuildCacheService.getH2JdbcUrl(this.dbPath, additionalConfiguration);
            return DriverManager.getConnection(h2JdbcUrl, "sa", "");
        }
    }
}

