/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.cache;

import com.google.common.collect.Interner;
import java.io.Closeable;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.incremental.cache.GeneralCompileCaches;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.serialization.HierarchicalNameSerializer;
import org.gradle.cache.Cache;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.IndexedCacheParameters;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.MinimalPersistentCache;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;

public class UserHomeScopedCompileCaches
implements GeneralCompileCaches,
Closeable {
    private final Cache<HashCode, ClassSetAnalysisData> classpathEntrySnapshotCache;
    private final PersistentCache cache;
    private final Cache<HashCode, ClassAnalysis> classAnalysisCache;

    public UserHomeScopedCompileCaches(GlobalScopedCacheBuilderFactory cacheBuilderFactory, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory, StringInterner interner) {
        this.cache = cacheBuilderFactory.createCacheBuilder("javaCompile").withDisplayName("Java compile cache").withInitialLockMode(FileLockManager.LockMode.OnDemand).open();
        IndexedCacheParameters jarCacheParameters = IndexedCacheParameters.of((String)"jarAnalysis", (Serializer)new HashCodeSerializer(), (Serializer)new ClassSetAnalysisData.Serializer(() -> new HierarchicalNameSerializer((Interner<String>)interner))).withCacheDecorator(inMemoryCacheDecoratorFactory.decorator(20000, true));
        this.classpathEntrySnapshotCache = new MinimalPersistentCache(this.cache.createIndexedCache(jarCacheParameters));
        IndexedCacheParameters classCacheParameters = IndexedCacheParameters.of((String)"classAnalysis", (Serializer)new HashCodeSerializer(), (Serializer)new ClassAnalysis.Serializer(interner)).withCacheDecorator(inMemoryCacheDecoratorFactory.decorator(400000, true));
        this.classAnalysisCache = new MinimalPersistentCache(this.cache.createIndexedCache(classCacheParameters));
    }

    @Override
    public void close() {
        this.cache.close();
    }

    @Override
    public Cache<HashCode, ClassSetAnalysisData> getClassSetAnalysisCache() {
        return this.classpathEntrySnapshotCache;
    }

    @Override
    public Cache<HashCode, ClassAnalysis> getClassAnalysisCache() {
        return this.classAnalysisCache;
    }
}

