/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultResolutionResultBuilder;
import org.gradle.api.internal.artifacts.result.DefaultMinimalResolutionResult;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;
import org.gradle.api.internal.attributes.ImmutableAttributes;

public class InMemoryResolutionResultBuilder
implements DependencyGraphVisitor {
    private final DefaultResolutionResultBuilder resolutionResultBuilder = new DefaultResolutionResultBuilder();
    private ResolvedComponentResult root;
    private ImmutableAttributes requestAttributes;

    @Override
    public void visitNode(DependencyGraphNode node) {
        DependencyGraphComponent component = node.getOwner();
        this.resolutionResultBuilder.startVisitComponent(component.getResultId(), component.getSelectionReason(), component.getRepositoryName());
        this.resolutionResultBuilder.visitComponentDetails(component.getComponentId(), component.getModuleVersion());
        for (ResolvedGraphVariant variant : component.getSelectedVariants()) {
            this.resolutionResultBuilder.visitSelectedVariant(variant.getNodeId(), variant.getResolveState().getVariantResult(null));
        }
        this.resolutionResultBuilder.visitComponentVariants(component.getResolveState().getAllSelectableVariantResults());
        this.resolutionResultBuilder.endVisitComponent();
    }

    @Override
    public void visitEdges(DependencyGraphNode node) {
        this.resolutionResultBuilder.visitOutgoingEdges(node.getOwner().getResultId(), node.getOutgoingEdges());
    }

    @Override
    public void finish(RootGraphNode root) {
        Long resultId = root.getOwner().getResultId();
        this.root = this.resolutionResultBuilder.getRoot(resultId);
        this.requestAttributes = root.getResolveState().getAttributes();
    }

    public MinimalResolutionResult getResolutionResult() {
        if (this.requestAttributes == null) {
            throw new IllegalStateException("Resolution result not computed yet");
        }
        return new DefaultMinimalResolutionResult(() -> this.root, this.requestAttributes);
    }
}

