#!/usr/bin/perl

package Imapd2Md;

use IO::File;

my $_DEBUG = 0;
my $_WINDOWS = 0;
my $_SKIP_CONVERT = 0;

sub maildirmake
{
  foreach(@_) {
     -d $_ or mkdir $_,0700 or die("Fatal: Directory $_ doesn't exist and can't be created.\n");
     -d "$_/tmp" or mkdir("$_/tmp",0700) or die("Fatal: Unable to make $_/tmp/ subdirectory.\n");
     -d "$_/new" or mkdir("$_/new",0700) or die("Fatal: Unable to make $_/new/ subdirectory.\n");
     -d "$_/cur" or mkdir("$_/cur",0700) or die("Fatal: Unable to make $_/cur/ subdirectory.\n");
 }
}


#this is result of code analyze from sources ftp://ftp.cac.washington.edu/imap/imap.tar.Z  [file imap-2007a\src\osdep\unix\mbx.c: mbx_parse function]

sub convertit{
  my( $srcfilename, $maildir ) = @_;

  return "Message convertaion skipped by configuration value!" if $_SKIP_CONVERT;
  return "File not found '$srcfilename'." if ! -e $srcfilename;

  my $buffer;
  my $unique = time;

  #open mbox file
  sysopen(MBX, $srcfilename, O_RDONLY | O_BINARY) or return "Cannot open '$srcfilename'!";
  #binmode( MBX ) or die "Cannot set binary reading mode for file '$srcfilename'!";

  #read common header
  if( read( MBX, $buffer, 2048 )!=2048 ){
      close(MBX);
      return "Cannot read header from '$srcfilename'!";
  }
  #check for mbox format
  my $format = substr( $buffer, 0, 5 );
  if( substr( $buffer, 0, 5 ) eq '*mbx*' ){
     #create target maildirs
     maildirmake( $maildir );
     my $msgCount = 1;
     my $curpos = 2048;
     #read mail messages
     M1:
     while( not eof(MBX) ){
         #seek to begin of next mail message
         seek( MBX, $curpos, SEEK_SET );
         #read message header
         my $readed = read( MBX, $buffer, 64 );
         last M1 if  $readed<=0;

         $buffer = substr( $buffer, 0, $readed );
         print "Read buffer: $buffer\n" if $_DEBUG;
         #parse header
         my ( $eol, $idx1, $idx2 );
         $eol = index( $buffer, "\x0D\x0A" );
         $idx1 = index( $buffer, "," );
         $idx2 = index( substr($buffer,$idx1), ";" ) if $idx1>=0;
         $idx2 += $idx1 if $idx2>=0;
         if( $eol<0 or $idx1<0 or $idx2<0 ){ die "Cannot parse internal message header of message number '$msgCount', filepos: $curpos!"; }

         #extract message information
         my $msgflags = substr( $buffer, $idx2+1, 12 );
         my $msguid = substr( $buffer, $idx2+1+12, 8 );
         my $msglen = substr( $buffer, $idx1+1, $idx2 - $idx1 - 1 );
         print "Message number $msgCount info: $msgflags, $msguid, $msglen\n" if $_DEBUG;

         #create message file name
         my $msgfilename = sprintf ("cur/%d.%06d.mbox:2,", $unique, $msgCount) ;
         $msgfilename = sprintf ("cur/%d.%06d.mbox_2,", $unique, $msgCount) if $_WINDOWS;
         $msgfilename .= "S" if hex($msgflags) & 0x01; #Seen
         $msgfilename .= "T" if hex($msgflags) & 0x02; #Deleted
         $msgfilename .= "F" if hex($msgflags) & 0x04; #Flagged
         $msgfilename .= "R" if hex($msgflags) & 0x08; #Answered

         #read message body
         seek( MBX, $curpos+$eol+2, SEEK_SET );
         my $len = $msglen;

         sysopen(OUT, "$maildir/$msgfilename", O_WRONLY | O_CREAT | O_BINARY ) or die("Fatal: unable to create new message '$maildir/$messagefn'!");
         #binmode( OUT );
         while( $len>0 and $readed>0 ){
           $readed = read( MBX, $buffer, $len<4096 ? $len : 4096 );
           if( $readed>0 ){
              $len -= $readed;
              syswrite( OUT, $buffer, $readed ) or die "Cannot write message '$msgCount' body to file '$maildir/$messagefn'!";
           }
         }
         close( OUT );
         #calc next message offset
         $curpos += $eol + 2 + $msglen;
         $msgCount += 1;
     }
  }
  else {
    close(MBX);
    return "Cannot convert mail messages from file '$srcfilename'. Only '*mbx*' format is supported, but found '$format'!";
  }
  close(MBX);
  return 0;

}


#convertit( 'C:/cygwin/Drafts', 'C:/!mtest' );

1;
