# Copyright 1999-2012. Parallels IP Holdings GmbH. All Rights Reserved.
package DatabaseContentDumper;

use strict;
use warnings;

use Logging;
use XmlNode;

# TODO copied as-is from PPCPL migration agent
sub getDatabaseContent {
  my ($base, $dbAdminLogin, $dbAdminPassword, $dbName, $dbType, $domainName, $domainId, $dumpOptions) = @_;

  my $contentFileName = $base->{namecreator}->getDbDstFile('sqldump', $domainName, $dbName, $domainId);
  my $sqldumpNode = $base->{archive_transport}->addDbContent($contentFileName, (
    'type' => $dbType,
    'name' => $dbName,
    'user' => $dbAdminLogin,
    'password' => $dbAdminPassword
), %$dumpOptions);
  if (ref($sqldumpNode) eq 'XmlNode') {
    return XmlNode->new('content', 'children' => [$sqldumpNode]);
  }

  Logging::warning("No database content found for '$dbName'.");
  return;
}

1;
