# Copyright 1999-2014. Parallels IP Holdings GmbH. All Rights Reserved.
package PreMigrationMessages;

use strict;
use warnings;

use PreMigration;

# Context variables common to all messages
our %COMMON_CONTEXT = (
    'panel_name' => 'Parallels Confixx',
  );

our $pleskDoesNotSupport = 'They will not be migrated because there is no such a feature in Parallels Plesk Panel.';

our %MESSAGES = (
  'AUTORESPONDER_FOR_CATCH_ALL_EMAIL' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::MAIL,
    'briefMessage' => 'Autoresponder for *@{domain} catch-all e-mail will not be migrated because it is not supported by Parallels Plesk Panel.',
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support autoresponders on catch-all e-mails.'
  },
  'GLOBAL_MAILBOX_QUOTA_IS_LESS' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::MAIL,
    'briefMessage' => "The quota '{mboxQuotaValue}' of mailbox '{mboxName}' on domain '{domain}' exceeds the global mailbox limit '{globalQuotaValue}'. Mailbox quota value will be set to the global quota value.",
    'detailedMessage' => 'The quota for a mailbox will be set equal to the global quota. After migration, you can change it manually. Most probably, this is not a critical issue.'
  },
  'PHONE_CONTAINS_SLASHES' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::CP,
    'briefMessage' => "The phone number '{phone}' of the user '{user}' contains slashes which are not allowed in Parallels Plesk Panel. All slashes will be removed.",
    'detailedMessage' => 'After migration, check the phone number and correct it, if necessary.'
  },
  'FAX_CONTAINS_SLASHES' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::CP,
    'briefMessage' => "The fax number '{fax}' of the user '{user}' contains slashes which are not allowed in Parallels Plesk Panel. All slashes will be removed.",
    'detailedMessage' => 'After migration, check the fax number and correct it, if necessary.'
  },
  'CAN_NOT_CONVERT_COUNTRY_CODE' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::CP,
    # TODO Cannot recognize country name {country} specified in profile of the user {user}
    'briefMessage' => "The record about the user '{user}' country '{country}' will not be migrated because the migration agent is unable to map it to a country supported by Parallels Plesk Panel.",
    'detailedMessage' => 'After migration, check the country name and select the proper value, if necessary.'
  },
  'CAN_NOT_CONVERT_LOCALE' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::CP,
    'briefMessage' => "The record about the language '{language}' for the user '{user}' will not be migrated because migration agent is unable to map it to a language supported by Parallels Plesk Panel.",
    'detailedMessage' => 'After migration, set the correct language for the user, if necessary.'
  },
  'CAN_NOT_CONVERT_IDN_DOMAIN' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::WEB,
    'briefMessage' => "Unable to convert the IDN domain {domain} to UTF-8: {reason}. After migration, this domain name will be represented by a string in Punycode.",
    'detailedMessage' => 'Check that idnconv utility is installed on the server and works correctly. For detailed information on how to install idnconv, refer to Parallels Confixx Installation and Upgrade Guide, section "Install IDNKit": http://download1.parallels.com/Confixx/ConfixxPro3.3/3.3.8/docs/manuals/en/Installation/confixx-3.3.8-installation-upgrade-guide.pdf.'
  },
  'SPAMASSASSIN_DUPLICATE_SETTING' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::MAIL,
    'briefMessage' => "SpamAssassin configuration for the mailbox '{mboxName}' on the domain '{domain}' contains duplicate '{param_name}' values. The last of these values will be used during migration.",
    'detailedMessage' => 'Most probably, it is a misconfiguration of SpamAssassin. After migration, check that SpamAssassin settings are properly set for that mailbox.'
  },
  'SPAMASSASSIN_NO_SUCH_OPTION_IN_PLESK' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::MAIL,
    'briefMessage' => "SpamAssassin configuration for the mailbox '{mboxName}' on the domain '{domain}' contains the parameter '{param_name}' with the value '{param_value}' which cannot be migrated to Parallels Plesk Panel.",
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support advanced configuration of SpamAssassin.'
  },
  'MAIL_MAPPING_MBOX_TARGET' => {
    'severity' => PreMigration::MAPPING,
    'component' => PreMigration::MAIL,
    'briefMessage' => "The mailbox '{mboxName}' on the domain '{domain}' will be migrated to Parallels Plesk Panel's e-mail address '{destinationEmail}'.",
    'detailedMessage' => ''
  },
  'MAIL_MAPPING_CATCH_ALL_EMAIL_TARGET' => {
    'severity' => PreMigration::MAPPING,
    'component' => PreMigration::MAIL,
    'briefMessage' => "All catch-all e-mail addresses on the domain '{domain}' will be migrated to Parallels Plesk Panel's e-mail address '{destinationEmail}'.",
    'detailedMessage' => ''
  },
  'MAIL_MAPPING_EMAIL_MIGRATED_AS_IS' => {
    'severity' => PreMigration::MAPPING,
    'component' => PreMigration::MAIL,
    'briefMessage' => "The e-mail address '{email}' will be migrated as is.",
    'detailedMessage' => ''
  },
  'MAIL_MAPPING_EMAIL_MIGRATED_WITH_MAILBOX' => {
    'severity' => PreMigration::MAPPING,
    'component' => PreMigration::MAIL,
    'briefMessage' => "The e-mail address '{email}' will be migrated as is, along with its mailbox '{mboxName}'.",
    'detailedMessage' => ''
  },
  'MAIL_MAPPING_FORWARDING' => {
    'severity' => PreMigration::MAPPING,
    'component' => PreMigration::MAIL,
    'briefMessage' => "The e-mail address '{email}' will be added to forwarders of Parallels Plesk Panel's e-mail address '{destinationEmail}'.",
    'detailedMessage' => ''
  },
  'MAIL_MAPPING_ALIAS' => {
    'severity' => PreMigration::MAPPING,
    'component' => PreMigration::MAIL,
    'briefMessage' => "The e-mail address '{email}' will be migrated as an alias of Parallels Plesk Panel's e-mail address '{destinationEmail}'.",
    'detailedMessage' => ''
  },
  'MAIL_MAPPING_PLESK_CATCH_ALL_FORWARDED_TO' => {
    'severity' => PreMigration::MAPPING,
    'component' => PreMigration::MAIL,
    'briefMessage' => "All mail sent to nonexistent users on the domain '{domain}' in Parallels Plesk Panel will be forwarded to '{email}'.",
    'detailedMessage' => ''
  },
  'MAIL_CATCH_ALL' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::MAIL,
    'briefMessage' => "Catch-all setting for emails '{email_list}' cannot be migrated, because there is more than one catch-all address set by the client '{client}'.",
    'detailedMessage' => "Confixx client '{client}' specified more than one catch-all address. This configuration cannot be reproduced in Plesk: in Parallels Plesk Panel, catch-all email has effect for the all domains of the subscription at once."
  },
  'CUSTOMER_WITH_NO_DOMAINS' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::CP,
    'briefMessage' => "The user '{user}' does not have any domains, therefore, a system domain '{systemDomain}' will be created.",
    'detailedMessage' => 'In Parallels Plesk Panel, most of the features, like databases and file storage, are available only if a customer has at least one domain name. In Parallels Confixx, a customer is not obliged to have domains to use these features.'
  },
  'CUSTOMER_HAS_NO_SYSTEM_DOMAIN' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::CP,
    'briefMessage' => "The user '{user}' does not have a system domain. Migration agent will generate a new system domain: '{systemDomain}'.",
    'detailedMessage' => ""
  },
  'DOMAIN_HTTPD_SPECIALS' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::WEB,
    'briefMessage' => "The Apache configuration for the domain '{domain}' is customized with HTTPD specials.",
    'detailedMessage' => "All options for HTTPD specials are migrated to the vhost.conf files and are commented out. The specials you added in the advanced mode are migrated as well. We recommend that you review these entries after migration and uncomment them if they are needed. Also, be sure to replace the variables like ##user## and ##user_home## with the exact values because the variables will no longer work. For example, ##user_home##/##user## can be replaced with /var/www/vhosts/some-user-domain.tld/httpdocs."
  },
  'SHARED_DOMAINS' => {
    'severity' => PreMigration::CRITICAL,
    'component' => PreMigration::WEB,
    'briefMessage' => "The user '{user}' has one or more shared domains ({domains}). $pleskDoesNotSupport",
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support shared domains.'
  },
  'RESELLER_EXCLUSIVE_IPS' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::WEB,
    'briefMessage' => "The reseller '{user}' has one or more exclusive IP addresses ({ips}). They will be migrated as shared IP addresses due to limitations imposed by Parallels Plesk Panel migration manager.",
    'detailedMessage' => "After migration, allocate exclusive IP addresses to the reseller, if required."
  },
  'PERSONAL_INFO_CUSTOM_FIELDS' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::CP,
    'briefMessage' => "There are custom fields defined in customer profile of '{user}'. $pleskDoesNotSupport",
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support custom fields.'
  },
  'PERSONAL_INFO_NOT_FULLY_MIGRATED' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::CP,
    # TODO let's keep brief messages brief.
    'briefMessage' => "Parallels Plesk Panel has fewer personal information fields and some of them have stricter validation. The values that do not conform to Parallels Plesk Panel rules will not be migrated. For example, there is no gender field in Parallels Plesk Panel, so the values from the gender field cannot be migrated.",
    'detailedMessage' => ''
  },
  'COMPLEX_PASSWORDS_NOT_MIGRATED' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::CP,
    'briefMessage' => 'Parallels Plesk Panel has more restrictions on password text. For example, national symbols are not allowed.',
    'detailedMessage' => 'As Parallels Confixx stores password as hashes, there is no way to detect and fix problem automatically: we do not know password text, we know only hash. So you should expect that some customers will not be able to login to CP and you should changes passwords for them manually.'
  },
  'CUSTOMER_TEMPLATES' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::CP,
    'briefMessage' => "Customer templates owned by the reseller '{user}' will be migrated as service plans.",
    'detailedMessage' => "Customer templates are migrated as Parallels Plesk Panel service plans. However, registration e-mail template settings are not migrated. Note the difference between customer account templates in Confixx and service plans in Parallels Plesk Panel: Unlike service plans in Parallels Plesk Panel, customer account templates in Confixx are used only for creating new accounts. Modifying customer account templates does not affect accounts that were created based on them. In Parallels Plesk Panel, subscriptions and user accounts maintain relations with their service plans."
  },
  'CUSTOMER_TEMPLATES_DOMAIN_LIMIT' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::CP,
    'briefMessage' => "Service plan in Plesk requires a limit of domains to be set. There is no corresponding limit in Confixx. Domain limit is set to a default value '1'",
    'detailedMessage' => "After migration, review the service plan limit named 'Domains', set it accordingly."
  },
  'CUSTOMER_TEMPLATE_SUBDOMAIN_LIMIT' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::CP,
    'briefMessage' => "Template '{template}' has non-zero value for the limit for wildcard subdomains. Limit of wildcard subdomains set in template '{template}' will be added to the limit of regular subdomains.",
    'detailedMessage' => "Plesk Service plans do not distinguish between regular and wildcard subdomains. The sum of both limits is migrated to subdomain limits."
  },
   
  'SCPONLY_NOT_SUPPORTED' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::WEB,
    'briefMessage' => "Scp/SFTP shell type is not supported by Parallels Plesk Panel; therefore, after migration, no shell access will be granted to the user '{user}'.",
    'detailedMessage' => 'Consider using FTP or enabling shell access for that user.'
  },
  'BOTH_AWSTATS_AND_WEBALIZER_ENABLED' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::WEB,
    'briefMessage' => "Both AWStats and Webalizer are enabled for the user '{user}'. Parallels Plesk Panel can have only one of them enabled per domain, therefore, only the default one will be enabled.",
    'detailedMessage' => "The user can later select another statistics tool in subscription settings. The statistics data (Webalizer HTML and data files, AWStats data files) are put into the private/confixx-statistics directory, relatively to a customer's home directory."
  },
  'RESELLER_DNS_SPECIALS' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::DNS,
    'briefMessage' => "Reseller's DNS template is found for '{user}'. It will not be migrated because Parallels Plesk Panel does not support that feature.",
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support reseller DNS templates.'
  },
  'CLIENT_CUSTOM_ERROR_DOCS' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::WEB,
    'briefMessage' => "The user '{user}' has custom error documents. Their migration is not supported, and in general, Parallels Confixx supports per-directory error documents, while Parallels Plesk Panel supports only per-site error documents.",
    'detailedMessage' => 'Migrate all the necessary error documents manually.'
  },
  'IP_RESTRICTIONS' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::CP,
    'briefMessage' => 'Restriction of access to Parallels Confixx is based on IP addresses. This feature is not migrated by migration manager.',
    'detailedMessage' => 'After migration, you can manually set up the restrictions: log in as administrator to Parallels Plesk Panel, go to Tools & Settings > Restrict Administrative Access.'
  },
  'DOMAIN_BLACKLIST' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::CP,
    'briefMessage' => "Parallels Plesk Panel does not support the feature that prohibits users from creating domain names with reserved addresses.",
    'detailedMessage' => 'As a workaround, you can create such domains under administrator\'s subscription in Parallels Plesk Panel and suspend them.'
  },
  'AT_DOMAINS' => {
    'severity' => PreMigration::CRITICAL,
    'component' => PreMigration::WEB,
    'briefMessage' => "The user '{user}' has one or more at-domains ({atdomains}). $pleskDoesNotSupport",
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support at-domains.'
  },
  'EMAILS_WITH_PERCENT_SIGN' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::MAIL,
    'briefMessage' => "The user '{user}' has one or more e-mail addresses with percentage sign ('%') in their names ({emails}). Such e-mail addresses will not be migrated because they are not supported by Parallels Plesk Panel.",
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support percentage signs in e-mail addresses.'
  },
  'STATISTICS_MODEL' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::WEB,
    'briefMessage' => 'Parallels Plesk Panel and Parallels Confixx have slightly different models for web statistics and Apache logs. Refer to the official documentation for more information.',
    'detailedMessage' => 'Confixx uses a single log file per user. In Parallels Plesk Panel, access log files are per-domain, so statistics for different domains are not mixed. Logs are migrated for a system domain only, so, (1) if log files are large, duplicate log files will significantly increase disk space usage, and (2) for every domain, you will have clean statistics without any previous records.'
  },
  'RESELLER_INDEX_PAGE_WITH_USER_VARIABLE' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::WEB,
    'briefMessage' => 'There is the ##user## variable found in the index document template of the reseller {user}. The template will be migrated, but the variable will not be substituted.',
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support substitution of variables for virtual host templates.'
  },
  'RESELLER_HELP_MESSAGE' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::WEB,
    'briefMessage' => "A custom help message was found for the reseller '{user}'. It will not be migrated because Parallels Plesk Panel does not support such a feature.",
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support showing custom messages from Resellers in Panel.'
  },
  'ADDRESSBOOK' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::MAIL,
    'briefMessage' => "The user '{user}' has entries in the address book. Not everything from the address book can be migrated.",
    'detailedMessage' => "For example, first and last names are not migrated, only the formatted name is migrated to an alias. After migration, check that nothing important was lost during migration."
  },
  'NS_TEMPLATE_RECORDS' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::DNS,
    'briefMessage' => 'NS records were found in the DNS template. They will not be migrated. Parallels Plesk Panel will create a standard NS record based on its own template.',
    'detailedMessage' => 'Create NS records for all domains manually, if necessary, fix Parallels Plesk Panel\'s DNS template for new domains.'
  },
  'UNKNOWN_MAILDROP' => {
    'severity' => PreMigration::CRITICAL,
    'component' => PreMigration::MAIL,
    'briefMessage' => "Maildrop '{maildrop}' is not supported by migration agent. Mail content will not be migrated.",
    'detailedMessage' => 'Check that confixx_main.conf is correct. Only migrations from "HOMEDIR/Maildir/", "HOMEDIR/Mailbox", and "/var/spool/mail/USER" are supported. Switch to one of these values before migration.'
  },
  'SINGLE_WORD_DOMAIN' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::WEB,
    'briefMessage' => "User '{user}' has a single-word domain '{domain}' which is not supported by Parallels Plesk Panel. Domain will be renamed to '{newDomain}'.",
    'detailedMessage' => ''
  },
  'CRON_JOBS' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::WEB,
    'briefMessage' => "User '{user}' has crontab entries. Cron jobs are migrated as-is, without verification of filesystem paths or commands.",
    'detailedMessage' => 'After migration is completed, check that the commands and filesystem paths specified in cron jobs exist on the Plesk server.'
  },
  'APACHE_UID_UNKNOWN' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::WEB,
    'briefMessage' => "Unable to determine Apache uid/gid",
    'detailedMessage' => "Apache uid/gid are necessary for proper file permissions transfer. Please contact support for details."
  },

);
