# Copyright 1999-2014. Parallels IP Holdings GmbH. All Rights Reserved.
package Db::DbConnect;

use Db::Connection;
use Logging;
use XmlNode;

sub getDbConnect {
  my ($myDbType, $myDbUser, $myDbPasswd, $myDbDB, $myDbHost,
      $continueAfterError, $myDbSocket, $variables, $utf, $port) = @_;

  my $connection;

  if ($myDbType eq 'Pg') {
    $myDbType = 'postgresql';
  }

  my %params;
  $params{'name'} = $myDbDB;
  $params{'user'} = $myDbUser;
  $params{'password'} = $myDbPasswd;
  $params{'host'} = $myDbHost if $myDbHost;
  $params{'socket'} = $myDbSocket if $myDbSocket;
  $params{'port'} = $port if $port;
  $params{'preload_dirs'} = $variables if $variables;
  $params{'type'} = $myDbType;

  $connection = Db::Connection::getConnection(%params);

  my $this =
    {
     'DISCONNECT' => sub { return $connection->disconnect(@_); },
     'EXECUTE' => sub { return $connection->execute_rownum(@_); },
     'FETCHROW' => sub { return $connection->fetchrow(@_); },
     'FETCHHASH' => sub { return $connection->fetchhash(@_); },
     'FINISH' => sub { return $connection->finish(@_); },
     'PING' => sub { return $connection->ping(@_); },
     'USER' => sub { return $myDbUser; },
     'PASSWORD' => sub { return $myDbPasswd; },
     'HOST' => sub { return $myDbHost; }
    };
  return $this;
}

#
# end class for handle database
#

1;
