# Copyright 1999-2015. Parallels IP Holdings GmbH. All Rights Reserved.
package FormatConverter;

use strict;
use warnings;

my %_mapCountries = (
  'deutschland' => 'DE',
  'afghanistan' => 'AF',
  'albania' => 'AL',
  'algeria' => 'DZ',
  'american samoa' => 'AS',
  'andorra' => 'AD',
  'angola' => 'AO',
  'anguilla' => 'AI',
  'antigua and barbuda' => 'AG',
  'argentina' => 'AR',
  'armenia' => 'AM',
  'aruba' => 'AW',
  'australia' => 'AU',
  'austria' => 'AT',
  'azerbaijan' => 'AZ',
  'bahamas' => 'BS',			
  'bahrain' => 'BH',
  'bangladesh' => 'BD',
  'barbados' => 'BB',
  'belarus' => 'BY',
  'belgium' => 'BE',
  'belize' => 'BZ',
  'benin' => 'BJ',
  'bermuda' => 'BM',
  'bhutan' => 'BT',
  'bolivia' => 'BO',
  'bosnia and herzegovina' => 'BA',
  'botswana' => 'BW',
  'brazil' => 'BR',
  'brunei' => 'BN',
  'bulgaria' => 'BG',
  'burkina faso' => 'BF',
  'burundi' => 'BI',
  'cambodia' => 'KH',
  'cameroon' => 'CM',
  'canada' => 'CA',
  'cape verde' => 'CV',
  'central african republic' => 'CF',
  'chad' => 'TD',
  'chile' => 'CL',
  'china' => 'CN',
  'colombia' => 'CO',
  'congo' => 'CG',
  'costa rica' => 'CR',
  'croatia' => 'HR',
  'cuba' => 'CU',
  'cyprus' => 'CY',
  'czech republic' => 'CZ',
  'denmark' => 'DK',
  'djibouti' => 'DJ',
  'dominica' => 'DM',
  'dominican republic' => 'DO',
  'ecuador' => 'EC',
  'egypt' => 'EG',
  'el salvador' => 'SV',
  'equatorial guinea' => 'GQ',
  'eritrea' => 'ER',
  'estonia' => 'EE',
  'ethiopia' => 'ET',
  'faroe islands' => 'FO',
  'fiji' => 'FJ',
  'finland' => 'FI',
  'france' => 'FR',
  'gabon' => 'GA',
  'gambia' => 'GM',
  'georgia' => 'GE',
  'germany' => 'DE',
  'ghana' => 'GH',
  'gibraltar' => 'GI',
  'greece' => 'GR',
  'greenland' => 'GL',
  'grenada' => 'GD',
  'guadeloupe' => 'GP',
  'guam' => 'GU',
  'guatemala' => 'GT',
  'guinea' => 'GN',
  'guinea-bissau' => 'GW',
  'guyana' => 'GY',
  'haiti' => 'HT',
  'honduras' => 'HN',
  'hong kong' => 'HK',
  'hungary' => 'HU',
  'iceland' => 'IS',
  'india' => 'IN',
  'indonesia' => 'ID',
  'iran' => 'IR',
  'iraq' => 'IQ',
  'ireland' => 'IE',
  'israel' => 'IL',
  'italy' => 'IT',
  'jamaica' => 'JM',
  'japan' => 'JP',
  'jordan' => 'JO',
  'kazakhstan' => 'KZ',
  'kenya' => 'KE',
  'korea republic' => 'KR',
  'kuwait' => 'KW',
  'kyrgyzstan' => 'KG',
  'latvia' => 'LV',
  'lebanon' => 'LB',
  'lesotho' => 'LS',
  'liberia' => 'LR',
  'liechtenstein' => 'LI',
  'lithuania' => 'LT',
  'luxembourg' => 'LU',
  'macao' => 'MO',
  'macedonia' => 'MK',
  'madagascar' => 'MG',
  'malawi' => 'MW',
  'malaysia' => 'MY',
  'maldives' => 'MV',
  'mali' => 'ML',
  'malta' => 'MT',
  'martinique' => 'MQ',
  'mauritania' => 'MR',
  'mauritius' => 'MU',
  'mayotte' => 'YT',
  'mexico' => 'MX',
  'moldova' => 'MD',
  'monaco' => 'MC',
  'mongolia' => 'MN',
  'montenegro' => 'ME',
  'montserrat' => 'MS',
  'morocco' => 'MA',
  'mozambique' => 'MZ',
  'myanmar' => 'MM',
  'namibia' => 'NA',
  'nauru' => 'NR',
  'nepal' => 'NP',
  'netherlands' => 'NL',
  'netherlands antilles' => 'AN',
  'new caledonia' => 'NC',
  'new zealand' => 'NZ',
  'nicaragua' => 'NI',
  'niger' => 'NE',
  'nigeria' => 'NG',
  'norway' => 'NO',
  'oman' => 'OM',
  'pakistan' => 'PK',
  'palau' => 'PW',
  'panama' => 'PA',
  'papua new guinea' => 'PG',
  'paraguay' => 'PY',
  'peru' => 'PE',
  'philippines' => 'PH',
  'pitcairn' => 'PN',
  'poland' => 'PL',
  'portugal' => 'PT',
  'puerto rico' => 'PR',
  'qatar' => 'QA',
  'reunion' => 'RE',
  'romania' => 'RO',
  'russia' => 'RU',
  'rwanda' => 'RW',
  'samoa' => 'WS',
  'san marino' => 'SM',
  'saudi arabia' => 'SA',
  'senegal' => 'SN',
  'serbia' => 'RS',
  'seychelles' => 'SC',
  'sierra leone' => 'SL',
  'singapore' => 'SG',
  'slovakia' => 'SK',
  'slovenia' => 'SI',
  'somalia' => 'SO',
  'south africa' => 'ZA',
  'spain' => 'ES',
  'sri lanka' => 'LK',
  'sudan' => 'SD',
  'suriname' => 'SR',
  'swaziland' => 'SZ',
  'sweden' => 'SE',
  'switzerland' => 'CH',
  'syrian' => 'SY',
  'taiwan' => 'TW',
  'tajikistan' => 'TJ',
  'tanzania' => 'TZ',
  'thailand' => 'TH',
  'togo' => 'TG',
  'tokelau' => 'TK',
  'tonga' => 'TO',
  'trinidad and tobago' => 'TT',
  'tunisia' => 'TN',
  'turkey' => 'TR',
  'turkmenistan' => 'TM',
  'tuvalu' => 'TV',
  'uganda' => 'UG',
  'ukraine' => 'UA',
  'united arab emirates' => 'AE',
  'united kingdom' => 'GB',
  'united states' => 'US',
  'uruguay' => 'UY',
  'uzbekistan' => 'UZ',
  'vanuatu' => 'VU',
  'venezuela' => 'VE',
  'vietnam' => 'VN',
  'western sahara' => 'EH',
  'yemen' => 'YE',
  'zambia' => 'ZM',
  'zimbabwe' => 'ZW'
);

sub convertCountry {
  my ($country) = @_;
  return $_mapCountries{lc($country)};
}
    
my %_mapLocales = (
  'de' => 'de-DE',
  'en' => 'en-US',
  'es' => 'es-ES',
  'fr' => 'fr-FR',
  'gr' => 'el-GR',
  'it' => 'it-IT',
  'ru' => 'ru-RU'
);

sub convertLocale {
  my ($locale) = @_;
  return $_mapLocales{$locale};
}

1;
