# Copyright 1999-2015. Parallels IP Holdings GmbH. All Rights Reserved.
use strict;
use warnings;

package DateUtils;

use POSIX;

# @param $year year in YYYY format (for example 2011) 
# @param $month from 1 to 12
# @return day in range from 28 to 31
sub lastMonthDay {
  my ($year, $month) = @_;

  # Use 0 day of the next month - it is interpreted by mktime as the last day of this month
  # $month is not changed as:
  # - mktime uses 0 to 11 format, and we should subtract 1 to convert to this format, 
  # - to get the next month, we should add 1
  # The idea was taken from http://www.perlmonks.org/?node_id=97120
  my $time = POSIX::mktime(0, 0, 0, 0, $month, $year - 1900);
  return (localtime($time))[3];
}

1;
