from parallels.core.migrated_subscription import MigratedSubscription
from parallels.core.utils.common import cached


class CustomPanelMigratedSubscription(MigratedSubscription):
	@property
	@cached
	def hosting_description(self):
		"""Get hosting description of specified subscription

		Returns object model over part of the hosting description file which is related to that subscription.

		:rtype: parallels.custom_panel_migrator.hosting_description.HostingDescriptionSubscription | None
		"""
		if self._migrator.global_context.conn.has_hosting_description_config(self.model.source):
			hosting_description = self._migrator.global_context.get_hosting_description(self.model.source)
			return hosting_description.get_subscription(self.name)
		else:
			return None